package com.example.twolibs.FaresGUI;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.FaresBL.TNSearchResults;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SupportBL.DataConvert;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

public class FaresLookup extends ListActivity {

	// Support for menu switching
	int iCurrentMenu = -1;
	int iCurrentSelection = -1;

	ArrayList<TNFare> list = new ArrayList<>();
	TicketListAdaptor adapter;

	ListView listview;


	int iNumRequested = 10;
	Context context = null;
	String nextAction = "";

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}

	/** Called when the activity is first created. */

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_fareslookup);
		context = this;

		Intent intent = getIntent();
		if (intent != null) {
			// (if it was null then somebody hit cancel to get here so we don't
			// need to look further)
			nextAction = intent.getStringExtra("nextAction");
			if (nextAction != null) {
				if (nextAction.equals("search")) {
					setTitle(" Anywhere to Anywhere");

				} else if (nextAction.equals("historic")) {
					setTitle(" Repeat Fares");

				} else if (nextAction.equals("instant")) {
					setTitle(" Instant Fare");

				} else if (nextAction.equals("favourite")) {
					setTitle(" Favourite Fare");

				} else if (nextAction.equals("addToFareSet")) {
					setTitle(" Add Fare");

				} else {
					setTitle(" Fares");
				}
			} else {
				nextAction = "";
			}

		}

		// here, we dynamically load the library at runtime
		// before calling the native method.
		//

		//System.loadLibrary("twolib-second");
		final AppContext bb = (AppContext) getApplicationContext();

		doLoad(bb);

		listview =  findViewById(android.R.id.list);

		adapter = new TicketListAdaptor(this, list, bb);
		setListAdapter(adapter);

		listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, final View view,
					int position, long id) {

				// Clear the visual list
				for (int j = 0; j < parent.getChildCount(); j++) {
					View rowView = parent.getChildAt(j);
					rowView.setBackgroundColor(Color.TRANSPARENT);
					TextView txtFulfillmentType =  rowView
							.findViewById(R.id.txtFulfillmentType);
					txtFulfillmentType.setTextColor(JMgetColor(R.color.edit_text, getTheme()));
					txtFulfillmentType.setBackgroundColor(Color.TRANSPARENT);
					TNFare fare = list.get(j);
					txtFulfillmentType.setText(fare.getFa_FulfillmentMethod());
				}

				if (position == iCurrentSelection) {
					if (nextAction.equals("addToFareSet")) {
						setMenu(2);
					} else {
						setMenu(0);
					}
					// Null the selected journey
					bb.selFare = null;
					iCurrentSelection = -1;
					list.get(position).itemSelected = 0;

				} else {

					if (nextAction.equals("addToFareSet")) {
						setMenu(2);
					} else {
						setMenu(1);
					}

					// Record the selected journey
					bb.selFare = list.get(position);
					iCurrentSelection = position;

					// change the background colour of the selected element
					list.get(position).itemSelected = 1;
					// Keep this code in sync with adaptor
					view.setBackgroundColor(JMgetColor(R.color.selection_background, getTheme()));
					TextView txtFulfillmentType = view
							.findViewById(R.id.txtFulfillmentType);
					txtFulfillmentType.setTextColor(JMgetColor(R.color.button_text, getTheme()));
					txtFulfillmentType.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
				}
			}

		});

		iNumRequested = 10;

		if (nextAction.equals("search")) {
			// Do the requested search
			doSearch();

		} else if (nextAction.equals("historic")) {
			// Display history
			doHistory();

		} else if (nextAction.equals("instant")) {
			doInstant();

		} else if (nextAction.equals("favourite")) {
			doFavourite();

		} else if (nextAction.equals("addToFareSet")) {
			// Do the requested search
			doSearch();

		} else {
			setTitle(" Fares");
		}

		if (nextAction.equals("addToFareSet")) {
			setMenu(2);
		} else {
			setMenu(0);
		}

	}

	public void doLoad(AppContext bb) {

		FareManager.STDResponse resp;
		String fibFile;
		// fibFile = Environment.getExternalStorageDirectory() +
		// "/com.example.twolibs/FIBb5_0s2v1g449.FIB";
		fibFile = Environment.getExternalStorageDirectory()
				+ "/com.example.twolibs/FARES.FIB";


		resp = bb.fareManager.doLoad(fibFile);

		TextView tv =  findViewById(R.id.textView2);

		tv.setText(resp.extra + resp.trace);

	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void doSearch() {

		String sProgress = "";

		TextView tv =  findViewById(R.id.textView2);

		AppContext bb = (AppContext) getApplicationContext();

		TNSearchCriteria TNCrit = new TNSearchCriteria();

		//
		// The origin and destination is dependent on the context
		// Add settings control
		//
		Location objOrigin = bb.getOrigin();
		Location objDestination = bb.getDestination();

		if (objOrigin.getNLC().equals("")) {
			tv.setText("No origin specified");
			return;
		}
		TNCrit.OriginUIC = objOrigin.getUIC();

		if (objDestination.getNLC().equals("")) {
			tv.setText("No destination specified");
			return;
		}
		TNCrit.DestinationUIC = objDestination.getUIC();

		TNCrit.OutDateTime = bb.getSearchDate();
		TNCrit.ReturnDateTime = null;
		TNCrit.CurrentDateTime = bb.getSearchDate();

		TNCrit.NumAdults = bb.getNumAdults();
		TNCrit.NumChildren = bb.getNumChildren();
		TNCrit.NumAAA = bb.getNumAAA();

		TNCrit.RailcardCode = bb.getRailcardCode(); // "SRN" ; //
													// bb.getRailcardCode();
		TNCrit.VariableDiscount = bb.getVariableDiscount();
		TNCrit.UseFutureFares = false;
		TNCrit.TicketCode = "";
		TNCrit.RouteCode = "";

		String outDate;
		outDate = DataConvert.displayyyyyMMddHHmm(TNCrit.OutDateTime);
		String retDate;
		if (TNCrit.ReturnDateTime == null) {
			retDate = "000000000000";
		} else {
			retDate = DataConvert.displayyyyyMMddHHmm(TNCrit.ReturnDateTime);
		}

		String TicketCode = "";
		String RouteCode = "";

		TNSearchResults objTNSearchResults = new TNSearchResults();

		String fileName = Environment.getExternalStorageDirectory()
				+ "/com.example.twolibs/Fare-" + TNCrit.OriginUIC + "-"
				+ TNCrit.DestinationUIC + ".txt";
		File file = new File(fileName);

		// String fileName = "Fare-" + TNCrit.OriginUIC + "-" +
		// TNCrit.DestinationUIC + ".txt";

		FareManager.SearchResponse result = bb.fareManager.doSearch(TNCrit,
				bb.faresClass, bb.getShowAllFares());

		if (bb.faresSortType == 0) {
			if (bb.faresSortOrder == 0) {
				Collections.sort(result.fares, new Comparator() {

					public int compare(Object o1, Object o2) {
						TNFare p1 = (TNFare) o1;
						TNFare p2 = (TNFare) o2;
						return (p1.getFa_TotalFareS() - p2.getFa_TotalFareS());
					}

				});
			} else {
				Collections.sort(result.fares, new Comparator() {

					public int compare(Object o1, Object o2) {
						TNFare p1 = (TNFare) o1;
						TNFare p2 = (TNFare) o2;
						return (p2.getFa_TotalFareS() - p1.getFa_TotalFareS());
					}

				});
			}
		} else {
			if (bb.faresSortOrder == 0) {
				Collections.sort(result.fares, new Comparator() {

					public int compare(Object o1, Object o2) {
						TNFare p1 = (TNFare) o1;
						TNFare p2 = (TNFare) o2;
						return (p1.getFa_PublicationSequence()
								.compareToIgnoreCase(p2
										.getFa_PublicationSequence()));
					}

				});
			} else {
				Collections.sort(result.fares, new Comparator() {

					public int compare(Object o1, Object o2) {
						TNFare p1 = (TNFare) o1;
						TNFare p2 = (TNFare) o2;
						return (p2.getFa_PublicationSequence()
								.compareToIgnoreCase(p1
										.getFa_PublicationSequence()));
					}

				});
			}
		}

		sProgress = sProgress + "Found " + result.fares.size();
		tv.setText(sProgress);

		adapter.clear();
		adapter.addAll(result.fares);
		adapter.notifyDataSetChanged();

	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void doHistory() {

		String sProgress = "";
		AppContext bb = (AppContext) getApplicationContext();

		sProgress = sProgress + "Found " + bb.fareManager.historicFares.size();
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(sProgress);

		for (TNFare fare : bb.fareManager.historicFares) {
			fare.itemSelected = 0;
		}
		adapter.clear();
		adapter.addAll(bb.fareManager.historicFares);
		adapter.notifyDataSetChanged();

	}

	public void doInstant() {

		String sProgress = "";
		AppContext bb = (AppContext) getApplicationContext();
		ArrayList<TNFare> fares = new ArrayList<TNFare>();

		if (bb.fareSetManager.instantFareSet == null) {
			sProgress = "No instant fares set";

		} else {
			fares = bb.fareSetManager.getPresetFares(bb,
					bb.fareSetManager.instantFareSet);
			if (fares.size() > 0) {
				sProgress = sProgress + "Found " + fares.size();

				for (TNFare fare : fares) {
					fare.itemSelected = 0;
				}
			} else {
				sProgress = "No fares setup";
			}
		}
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(sProgress);

		adapter.clear();
		adapter.addAll(fares);
		adapter.notifyDataSetChanged();

	}

	public void doFavourite() {

		String sProgress = "";
		AppContext bb = (AppContext) getApplicationContext();
		ArrayList<TNFare> fares = new ArrayList<TNFare>();

		if (bb.fareSetManager.favouriteFareSet == null) {
			sProgress = "No favourite fares set";

		} else {
			fares = bb.fareSetManager.getPresetFares(bb,
					bb.fareSetManager.favouriteFareSet);
			if (fares.size() > 0) {
				sProgress = sProgress + "Found " + fares.size();

				for (TNFare fare : fares) {
					fare.itemSelected = 0;
				}
			} else {
				sProgress = "No fares setup";
			}
		}
		TextView tv = (TextView) findViewById(R.id.textView2);
		tv.setText(sProgress);

		adapter.clear();
		adapter.addAll(fares);
		adapter.notifyDataSetChanged();

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu items for use in the action bar
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.menu_logon, menu);
		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle item selection
		if (item.getItemId() == R.id.cmdSync) {
			Toast.makeText(FaresLookup.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(FaresLookup.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}


	@Override
	public Intent getParentActivityIntent() {

		Intent newIntent = new Intent(getApplicationContext(), FaresCriteria.class);

		/*
		 * Intent parentIntent= getIntent(); //getting the parent class name
		 * String className = parentIntent.getStringExtra("ParentClassName");
		 * 
		 * Intent newIntent=null;
		 * 
		 * 
		 * try { //you need to define the class with package name newIntent =
		 * new
		 * Intent(TopMenu.this,Class.forName("com.example.TwoLibs."+className));
		 * 
		 * 
		 * } catch (ClassNotFoundException e) { e.printStackTrace(); }
		 */
		return newIntent;

	}

	private void setMenu(int iMenu) {
		if (iMenu == iCurrentMenu) {
			// No change required
		} else {
			// Delete the current
			LinearLayout layFormMenu = (LinearLayout) findViewById(R.id.layFormMenu);
			layFormMenu.removeAllViews();
			// Create new LayoutInflater - this has to be done this way, as you
			// can't directly inflate an XML without creating an inflater object
			// first

			LayoutInflater inflater = getLayoutInflater();
			if (iMenu == 0) {
				layFormMenu.addView(inflater.inflate(
						R.layout.fareslookup_menu0, null));

				// setup callbacks
				Button cmdEarlier = (Button) findViewById(R.id.cmdBasket);
				cmdEarlier.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "basket");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

				Button cmdOrder = (Button) findViewById(R.id.cmdOrder);
				cmdOrder.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						Toast.makeText(FaresLookup.this, "Order  Clicked",
								Toast.LENGTH_SHORT).show();

					}
				});

				Button cmdDone = (Button) findViewById(R.id.cmdDone);
				cmdDone.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "");
						setResult(RESULT_OK, returnIntent);
						finish();

					}
				});

			} else if (iMenu == 1) {
				layFormMenu.addView(inflater.inflate(
						R.layout.fareslookup_menu1, null));

				// setup callbacks
				Button cmdEarlier = (Button) findViewById(R.id.cmdBasket);
				cmdEarlier.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						AppContext bb = (AppContext) getApplicationContext();
						Basket bs = bb.basket;
						if (bb.selFare != null) {
							TNFare tt = bb.selFare;
							bs.addTicket(tt, tt.getFa_TotalFareS());
						}
						Toast.makeText(FaresLookup.this,
								"Basket  items: " + bs.basketProducts.size(),
								Toast.LENGTH_SHORT).show();

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

				Button cmdLater = (Button) findViewById(R.id.cmdCard);
				cmdLater.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						AppContext bb = (AppContext) getApplicationContext();
						Basket bs = bb.basket;
						if (bb.selFare != null) {
							TNFare tt = bb.selFare;
							bs.addTicket(tt, tt.getFa_TotalFareS());
						}
						Toast.makeText(
								FaresLookup.this,
								"Card  Clicked - Basket  items: "
										+ bs.basketProducts.size(),
								Toast.LENGTH_SHORT).show();

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "card");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

				Button cmdCash = (Button) findViewById(R.id.cmdCash);
				cmdCash.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						AppContext bb = (AppContext) getApplicationContext();
						Basket bs = bb.basket;
						if (bb.selFare != null) {
							TNFare tt = bb.selFare;
							bs.addTicket(tt, tt.getFa_TotalFareS());
						}
						Toast.makeText(
								FaresLookup.this,
								"Cash  Clicked - Basket  items: "
										+ bs.basketProducts.size(),
								Toast.LENGTH_SHORT).show();

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "cash");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

			} else {
				layFormMenu.addView(inflater.inflate(
						R.layout.fareslookup_menu2, null));

				// setup callbacks
				Button cmdAdd = (Button) findViewById(R.id.cmdAdd);
				cmdAdd.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {
						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

				Button cmdDone = (Button) findViewById(R.id.cmdDone);
				cmdDone.setOnClickListener(new OnClickListener() {

					public void onClick(View view) {

						AppContext bb = (AppContext) getApplicationContext();
						bb.selFare = null;

						Intent returnIntent = new Intent();
						returnIntent.putExtra("nextAction", "");
						setResult(RESULT_OK, returnIntent);
						finish();
					}
				});

			}

			// Setup the new
			iCurrentMenu = iMenu;
		}

	}

	// public native int loadFib(String s, byte[] buff);

	// public native FIBQueryResults queryView(String p_ViewName, String
	// p_Params, int result);

	// public native int findLocations(int iSearchType, String sHome,boolean
	// bToSearch, String sSearch,int iRequested, byte[] results, byte[] buff);

	// public native TNSearchResults faresSearch(String p_OriginUIC, String
	// p_DestinationUIC,
	// String p_OutDateTime, String p_ReturnDateTime, String p_CurrentDateTime,
	// int p_NumAdults, int p_NumChildren, int p_NumAAA,
	// String p_RailcardCode, int p_VariableDiscount,boolean p_UseFutureFares,
	// String p_TicketCode, String p_Route);

}
