package com.example.twolibs.FaresGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R.color;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;


public class TicketListAdaptor extends ArrayAdapter<TNFare> {
	  private final Activity context;
	  private final ArrayList<TNFare> faresList;
	  private final AppContext bb;



	  static class ViewHolder {
		public TextView txtClass;
		public TextView txtTicketCode;
		public TextView txtTicketDesc;
		public TextView txtCost;
		public TextView txtOrigin;
		public TextView txtDestination;
		public TextView txtFlowOwner;
		public TextView txtRoute;
		public TextView txtRestrictionCode;
		public TextView txtFulfillmentMethod;
		public LinearLayout layReasons;
		public LinearLayout layFulfillmentType;
	  }

	  public TicketListAdaptor(Activity context, ArrayList<TNFare> list, AppContext bb) {
	    super(context, R.layout.ticket_summary, list);
	    this.context = context;
	    this.faresList = list;
	    this.bb = bb;
	  }

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (context.getResources().getColor(Color, TH));
		}else{
			return (context.getResources().getColor(Color));
		}
	}

	  @Override
	  public View getView(int position, View convertView, ViewGroup parent) {
	    View rowView = convertView;
	    LayoutInflater inflater = context.getLayoutInflater();
	      
	    // reuse views
	    if (rowView == null) {
	      rowView = inflater.inflate(R.layout.ticket_summary, null);
	      // configure view holder
	      ViewHolder viewHolder = new ViewHolder();
	      viewHolder.txtClass = (TextView) rowView.findViewById(R.id.txtClass);
	      viewHolder.txtTicketCode = (TextView) rowView.findViewById(R.id.txtTicketCode);
	      viewHolder.txtTicketDesc = (TextView) rowView.findViewById(R.id.txtTicketDesc);
	      viewHolder.txtCost = (TextView) rowView.findViewById(R.id.txtCost);
	      viewHolder.txtOrigin = (TextView) rowView.findViewById(R.id.txtOrigin);
	      viewHolder.txtDestination = (TextView) rowView.findViewById(R.id.txtDestination);
	      viewHolder.txtFlowOwner = (TextView) rowView.findViewById(R.id.txtFlowOwner);
	      viewHolder.txtRoute = (TextView) rowView.findViewById(R.id.txtRoute);
	      viewHolder.txtRestrictionCode = (TextView) rowView.findViewById(R.id.txtRestrictionCode);
	      viewHolder.txtFulfillmentMethod = (TextView) rowView.findViewById(R.id.txtFulfillmentType);
	      viewHolder.layReasons = (LinearLayout) rowView.findViewById(R.id.layReasons);
	      viewHolder.layFulfillmentType = (LinearLayout) rowView.findViewById(R.id.layFulfillmentType);
	      

	      rowView.setTag(viewHolder);
	    }

	    // fill data
	    ViewHolder holder = (ViewHolder) rowView.getTag();
	    TNFare s = faresList.get(position);
	    
	    // Do this to negate any selected row
	    if(s.itemSelected == 0 ){
	    	rowView.setBackgroundColor(Color.TRANSPARENT);
	    } else {
	    	rowView.setBackgroundColor(JMgetColor(R.color.selection_background, context.getTheme()));
	    }
	    
	    if (s.getFa_FareClass() == 1) {
	    	holder.txtClass.setText("1st");
	    	holder.txtClass.setTextColor(JMgetColor(R.color.fj_blue_3, context.getTheme()));
	    } else {
	    	holder.txtClass.setText("STD");
	    	holder.txtClass.setTextColor(JMgetColor(R.color.fj_black_0, context.getTheme()));
	    }
	    
	    holder.txtTicketCode.setText(s.getFa_TicketTypeCode());
	    
       	TicketDetails tkt;
       	String txtTicketCode = s.getFa_TicketTypeCode();
 		if (FareManager.ticketCodes.containsKey(txtTicketCode)){
 			tkt = FareManager.ticketCodes.getValue(txtTicketCode);
 		    holder.txtTicketDesc.setText(tkt.getTd_TicketTypeDesc());
 		} else {
 		    holder.txtTicketDesc.setText(txtTicketCode + "????");
 		}
 		
 		double intCost =((double)s.getFa_TotalFareS()) / 100;
 		holder.txtCost.setText(String.format("£%.2f", intCost));

 		Location loc;
       	String txtNLCCode, txtLoc;
       	
       	txtNLCCode = s.getFa_FareOriginLocation();
		loc = Location.getLocationByNLC(txtNLCCode);
		if (loc != null){
			txtLoc = loc.getDescription().trim();
		} else {
			txtLoc = "";
		}
       	
		if(txtLoc.length()>0) {
 		    holder.txtOrigin.setText(txtLoc);
 		} else {
 		    holder.txtOrigin.setText(txtNLCCode);
 		}
		
		txtNLCCode = s.getFa_FareDestinationLocation();
		loc = Location.getLocationByNLC(txtNLCCode);
		if (loc != null){
			txtLoc = loc.getDescription().trim();
		} else {
			txtLoc = "";
		}
		if(txtLoc.length()>0) {
 		    holder.txtDestination.setText(txtLoc);
 		} else {
 		    holder.txtDestination.setText(txtNLCCode );
 		}
		
	    holder.txtFlowOwner.setText(s.getFa_FlowOwner());
 		
	    holder.txtRoute.setText(s.getFa_RouteDescription());
 		
	    holder.txtRestrictionCode.setText(s.getFa_RestrictionCode());
	    
	    // Field changes when selected
	    holder.txtFulfillmentMethod.setText(s.getFa_FulfillmentMethod());
	    
    	holder.layFulfillmentType.setOnClickListener(mOnFulfillmentClickListener);
	    if(s.itemSelected == 0 ){
	    	holder.txtFulfillmentMethod.setEnabled(false);
		    //holder.txtFulfillmentMethod.setTextSize(JMgetColorgetDimension(R.dimen.edit_text_size));
		    holder.txtFulfillmentMethod.setTextColor(JMgetColor(R.color.edit_text, context.getTheme()));
		    holder.txtFulfillmentMethod.setBackgroundColor(Color.TRANSPARENT);
	    } else {
	    	holder.txtFulfillmentMethod.setEnabled(true);
		    //holder.txtFulfillmentMethod.setTextSize(JMgetColorgetDimension(R.dimen.edit_text_size));
		    holder.txtFulfillmentMethod.setTextColor(JMgetColor(R.color.button_text, context.getTheme()));
		    holder.txtFulfillmentMethod.setBackgroundColor(JMgetColor(R.color.button_background, context.getTheme()));
	    }
	    
	    String txtNoSaleReason = s.getFa_NoSaleReason();
	    if (txtNoSaleReason.length() == 0){
	    	holder.layReasons.removeAllViews();               
	    } else {
	    	holder.layReasons.removeAllViews();               
	    	holder.layReasons.addView(inflater.inflate(R.layout.ticket_summary_reason, null));
	    	TextView txtNotes = (TextView) rowView.findViewById(R.id.txtNotes);
	    	txtNotes.setText(s.getFa_NoSaleReason());
	    }
	    
	    
	    
	    
	    return rowView;
	  }
 
		private OnClickListener mOnFulfillmentClickListener = new OnClickListener() {
	        @Override
	        public void onClick(View v) {

	        	// Note need to navigate parents, so take care when changing layout
	        	LinearLayout container_1 = (LinearLayout) v.getParent();
	           	LinearLayout container_2 = (LinearLayout) container_1.getParent();
	        	LinearLayout container_3 = (LinearLayout) container_2.getParent();
	           	//LinearLayout container_4 = (LinearLayout) container_3.getParent();
	           	RelativeLayout row_container = (RelativeLayout) container_3.getParent();
	           	
	            ListView parent = (ListView) row_container.getParent();
	            int position = parent.getPositionForView(v);
  	        	final TNFare fare = faresList.get(position);


	  	        if (position != ListView.INVALID_POSITION) {
  	        	
				    // TODO Auto-generated method stub   
				    final String[] items = {"CCST", "SMART", "ROLL", "BAR CODED"};
				    AlertDialog.Builder listBuilder = new AlertDialog.Builder(context);
				    listBuilder.setTitle("Fulfilment");
				    listBuilder.setItems(items, new DialogInterface.OnClickListener() {
					       public void onClick(DialogInterface dialog, int item) {
	//				           Toast.makeText(getApplicationContext(), items[item], Toast.LENGTH_SHORT).show();
						    	fare.setFa_FulfillmentMethod(items[item]);
					       }
					    });
					    AlertDialog alertList = listBuilder.create();
					    alertList.show();    
		               
		
					}  
	  	        
		        }
	         	
	    };

	} 
