package com.example.twolibs.FulfilmentBL;

import java.util.Date;

import android.util.Log;

import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.BasketSupport.ItemType;
import com.example.twolibs.SessionBL.SDCIData;
import com.example.twolibs.SupportBL.DataConvert;

public class CCSTCoupon {
	private  String  TAG = "CCSTCoupon";

	public BasketSupport	bsItem;
	public SDCIData 		sdci;

	
	// Things that are unique to this coupon	
	public String couponFormat;
	
	// TODO set these when creating the coupon
	public TNFare			ticket;
	public TicketDetails   tkt;
  	
  	public boolean blnAdvanced = false;
  	public boolean blnPlusBus = false;
  	public String strCustomerName = ""; //TODO
  	public String strCouponMethodOfPayment = ""; 
  	public int intNumAdults =0;
  	public int intNumChildren =0;
  	public int intNumCoupons =0;
  	public double dlbCouponValue =0;
  	public boolean blnReverseFlow = false; // Set to true for a return
	
  	public String strTravelDirection  = "SGL"; //"SGL", "OUT" or "RTN".
	
  	public String strWarrantDetails = ""; //"12345 1234567 1"
  	public String strNRSBookingReference = "";
  	public String strCTRReference = "";
  	public String strOriginalCTRReference = "";
	
  	public String strPrintMessage = "";
  	
	public void SetupFare(AppContext bb){
		
		ticket = bsItem.ticket;
		if (FareManager.ticketCodes.containsKey(ticket.getFa_TicketTypeCode())){
      		tkt = FareManager.ticketCodes.getValue(ticket.getFa_TicketTypeCode());
       		// TODO check date and resetup if date different.
      	} else {
       		// TODO error
       	}
		
		//boolean blnAdvanced = false;
		//boolean blnPlusBus = false;

	}
	
	
    public String LookupField(String sFieldID){
 

       	if(bsItem.itemType == ItemType.FARE){
    		return  LookupTicketField(sFieldID);
    	}
    	
    	//TODO other types
    	return "";
    }

	
	

    private String LookupTicketField(String sFieldID){
    	
    	//TODO need to return invert attribute etc;
    	
    	String sValue ="";
    	
    	sValue = sFieldID;
//    	if(1==1){
//    		return sValue;
//    	}
    	
    	if (sFieldID.equals( "00101")){ //Accompanying ticket number / Original Ticket transaction number
	    		sValue = "";
    	} else if (sFieldID.equals( "00102")){ //Advance Issue Indicator
    		if(blnAdvanced){
    			sValue = "A";
    		} else {
    			sValue = " "; // space or A
    		}
    		
    	} else if (sFieldID.equals( "00107")){ //PlusBus add-on
    		if(blnPlusBus){
    			sValue = "+BUS";
    		} else {
    			sValue = " "; // space or A
    		}
    		
    		
    	} else if (sFieldID.equals( "00115")){ //Class (Description)
    		sValue =tkt.getTd_FareClassDesc(); // "1ST" or "STD". 
    		
    		
    	} else if (sFieldID.equals( "00118")){ //Via London Indicator
    		if(ticket.isFa_CrossLondon()){
    			sValue ="+"; //TODO A dagger can be used as an alternative only if the Maltesse Cross cannot be used.
    		} else {
    			sValue ="";
    		}
    		
    	} else if (sFieldID.equals( "00120")){ //Customer name
    		sValue = strCustomerName; //If local operational processes require it, otherwise blank. 
    								// (Alternatively a number to facilitate ticket sorting can be printed
    								// - in this event the field is to be prefixed with "Sort Ref. "
    		
    		
    	} else if (sFieldID.equals( "00122")){ //Date and time of print
    		 //"Printed HH:MM on DD-MON-YY" note: RSP 3018 specified month abbreviations.
    		sValue = "Printed " + dateToTime(sdci.saleTimestamp);
    		sValue = sValue + " on " + DateToString(sdci.saleTimestamp);
     		
    	} else if (sFieldID.equals( "00126")){//Location (Destination)
    		if(blnReverseFlow){
        		sValue = ticket.getFa_FareOriginLocation(); //
    		} else {
        		sValue = ticket.getFa_FareDestinationLocation(); //
    		}
    		
    		
    	} else if (sFieldID.equals( "00127")){ //Discount Percentage
    		//TODO
    		sValue = ""; //"MIN", "MAX", or "nn%"
    		
    		
    	} else if (sFieldID.equals( "00128")){ //Date of Expiry/Valid until
    		// If outward then out data + tkt.td_tv_OutDays + tkt.td_tv_OutMonths
    		//TODO 
    		sValue = DateToString(ticket.getFa_FareDateDt()); //Calculated by the TIS, from the start date and period of validity in Fares data.
    							  //TODO Jnr if format Xnn!
    		
    		
    	} else if (sFieldID.equals( "00136")){ //Kiosk ID
    		//TODO
    		sValue = ""; //4-digit TAPSIS code of the issuer + a number uniquely identifying the kiosk at the issuing location.
    		
    		
    	} else if (sFieldID.equals( "00139")){ //Method of Payment Code
    		sValue = strCouponMethodOfPayment; //Refer to RSPS3018 for the print rules that apply to Method of Payment Codes
    		
    		
    	} else if (sFieldID.equals( "00142")){ //NRS booking reference
    		sValue = strNRSBookingReference; //Note that OUT and RTN coupons may have different NRS References depending on how NRS is used.
    		
    		
    	} else if (sFieldID.equals( "00143")){ //Number of Adults
    		sValue = NumberToWords(intNumAdults); //If 1-9 adults then print as alpha ("ONE", "THREE" etc.) otherwise print numeric (10-99) 
    					//EXCEPT where a barcode is being printed where the format should be "*n*" or "*nn". 
						//If no adults are on the ticket then the text "NIL" should be printed. 
    		
    		
    	} else if (sFieldID.equals( "00144")){ //Number of Children
    		sValue = NumberToWords(intNumChildren); //If 1-9 Children then print as alpha ("ONE", "THREE" etc.) otherwise print numeric (10-99) 
							//EXCEPT where a barcode is being printed where the format should be "*n*" or "*nn". 
							//If no Children are on the ticket then the text "NIL" should be printed. 
    		
    		
    	} else if (sFieldID.equals( "00145")){ //Number of Coupons
    		if(intNumCoupons > 0){
    			sValue = String.format("%01", intNumCoupons);
    		} else {
    			sValue = ""; //Only to be printed where additional tickets and other coupons are issued as part of a package and/or where a reservation is mandatory, as a number from 1 to 99. 
    		}			//NOTE: card vouchers, optional reservations and receipt coupons are not included in this count.
    		
    		
    	} else if (sFieldID.equals( "00150")){ //Location (Origin)
    		if(blnReverseFlow){
        		sValue = ticket.getFa_FareDestinationLocation(); //
    		} else {
        		sValue = ticket.getFa_FareOriginLocation(); //
    		}
    		
    		
    	} else if (sFieldID.equals( "00155")){ //Price
    		//byte[] bPound = {127};
    		String sPound ="#";
    		sValue = sPound + DataConvert.doubleToDisplayFormat(dlbCouponValue);
    		
    		
    	} else if (sFieldID.equals( "00159")){ //Restriction Code
    		sValue = ticket.getFa_RestrictionCode(); //This field is used to display restrictions (known in The Manual as 'Validity Code') 
    					//associated with a specific ticket type if required by the TOC. 
    					//Leading spaces if required, otherwise blank.
    		
    		
    	} else if (sFieldID.equals( "00160")){ //Route
    		sValue = ticket.getFa_RouteDescription(); 
    		
    		
    	} else if (sFieldID.equals( "00171")){ //Date of Start of Validity
    		//TODO
    		sValue = DateToString(ticket.getFa_FareDateDt()); //If printing to a Format with an ID of "Xnn" then {
					    	//  	print date with format DD-Mon-YY ; for example 12-Jnr-14
					    	//   } else {
					    	//  Print date with format DD-MON-YY - for example 12-JNR-14
					    	//  If an Advance Issue the date must be printed in inverted text. i.e. White text on black background. 
					    	//  If a (season) renewal print "RENEWAL" with no inverted text.
    		
    		
    	} else if (sFieldID.equals( "00172")){ //Status disount -  description
    		//TODO
    		sValue = "ADULT"; //If the status of a ticket is "CHILD", then this shall be printed in inverted text (i.e. white text, black background).
				    		//If the status of a ticket includes "CHILD" status (e.g, child ticket purchased with a family railcard) this shall also be inverted. 
				    		//The same applies to Juvenile ("JUV") ITX tickets i.e. (white text, black background).
    		
    		
    	} else if (sFieldID.equals( "00177")){ //Ticket Description
    		sValue = tkt.getTd_TicketTypeDesc(); 
    		
    		
    	} else if (sFieldID.equals( "00178")){ //Ticket Number
    		sValue =  DataConvert.intToDisplayFormat(sdci.intTicketNumber,DataConvert.DecimalFormats.FIVEDIGITS);

    		
    	} else if (sFieldID.equals( "00181")){ //CTR Reference
    		sValue = strCTRReference; //To be printed If the ticket is issued as ToD
    		
    		
    	} else if (sFieldID.equals( "00186")){ //Travel direction
    		sValue = strTravelDirection; //"SGL", "OUT" or "RTN". 
    		
    		
    	} else if (sFieldID.equals( "00189")){ //Validity description
    		sValue = tkt.getTd_TicketValidityDesc(); //Out or Rtn description as appropriate. 
    		// TODO
    		//In the case of a Rover, DAYS_TRAVEL should be printed followed by the literal "DAYS". For example, "28 DAYS".
    		//In the case of Supplements it is the validity of the associated ticket type. For the case when "Both" or "Either" is indicated, use DESCRIPTION
    		
    		
    	} else if (sFieldID.equals( "00191")){ //Warrant Details
    		sValue =strWarrantDetails ; //
    		
    		
    	} else if (sFieldID.equals( "00198")){ //NLC (Selling Office)
    		sValue =  sdci.SellingNLC; //
    		
    		
    	} else if (sFieldID.equals( "00201")){ //Original CTR Reference
    		sValue = strOriginalCTRReference; //
    		
    		
    	} else if (sFieldID.equals( "00230")){ //Audit Code
    		//Audit code formed of Machine Number {FIELD_137}, NLC {FIELD_141} and Window number{FIELD_192
    		
    		sValue =  DataConvert.intToDisplayFormat(sdci.MachineNumber,DataConvert.DecimalFormats.FOURDIGITS);
    		sValue = sValue + sdci.SellingNLC;
    		sValue = sValue + DataConvert.intToDisplayFormat(sdci.WindowNumber,DataConvert.DecimalFormats.TWODIGITS);

    		
    	} else if (sFieldID.equals( "A1_A")){ //Table A1_A
    		//TODO
    		sValue = ""; // Ticket Type: Single or Two Part Return
    		//Condition: If reservations required for the journey. (The Ticket Types record field RESERVATION_REQUIRED specifies whether reservations are mandatory).
    		//Value: "VALID ONLY WITH RESERVATION(S)"
    		//Otherwise: <blank>

    		//Ticket Type: Excess
    		//Condition: Where a TOD sale has not yet been issued
    		//Value: "VALID ONLY WITH CTR {FIELD_00201}
    		//Otherwise: "VALID ONLY WITH TICKET {FIELD_00101}
    		
    		
    	} else if (sFieldID.equals( "A1_B")){ //Table A1_B
    		//TODO
    		sValue = ""; //Single or Two-Part Return
    		//Condition: One or more journey related coupons are to be printed with the ticket. 
    		//DO NOT INCLUDE OPTIONAL RESERVATIONS IN COUNT.
    		//e.g. for a single with optional reservation this field would not be printed,for a single with mandatory reservation this field would be printed.
    		//This would also be printed where the ticket type is a package.
    		//Value: ISSUED AS
    		//Otherwise: <blank>
    		//Ticket Type: Excess
    		//Condition: All
    		
    		
    	} else if (sFieldID.equals( "A1_C")){ //Table A1_C
    		sValue = ""; // "2 COUPONS"; //Single or Two-Part Return
    		//Condition: One or more journey related coupons are to be printed with the ticket
    		//DO NOT INCLUDE OPTIONAL RESERVATIONS IN COUNT.
    		//e.g. for a single with optional reservation this field would not be printed,for a single with mandatory reservation this field would be printed.
    		//Value: {FIELD_00145} COUPONS
    		
    		
    	} else if (sFieldID.equals( "A1_D")){ //Table A1_D
    		//byte[] bPound = {127};
    		String sPound = "#"; //new String(bPound);;
    		sValue = sPound + DataConvert.doubleToDisplayFormat(dlbCouponValue);

    		//Single, Two-Part Return or Excess
    		//Condition: All
    		//Value: Column 34 - {FIELD_00155} price
    		
    		
    	} else if (sFieldID.equals( "A1_E")){ //Table A1_E
    		if(blnPlusBus){
    			sValue = "+BUS";
    		} else {
    			sValue = " "; // space or A
    		}
    		 //Ticket type: Single, Two-Part Return or Excess
    		//Condition: All
    		//Value: Column 9 - {FIELD_00107}
    		
    		
    	} else if (sFieldID.equals( "A1_F")){ //Table A1_F
    		//TODO
    		if (ticket.getFa_SingleOrReturn().equals("S")){
    			sValue = "SINGLE";
				
			} else if (ticket.getFa_SingleOrReturn().equals("R")){
    			sValue = "2-PART RETURN";
			}
    		
    		//sValue = "SINGLE"; //Single: "SINGLE"
    		//Two-Part Return: "2-PART RETURN"
    		//	Excess: "EXCESS"
    		
    		
    	} else if (sFieldID.equals( "A1_G")){ //Table A1_G
    		//TODO
    		sValue = ""; // Ticket type: All ToDable products
    		//Condition: Ticket on Departure
    		//Value: "ToD CTR: {FIELD_00181}/{FIELD_00198}"
    		//Otherwise: <blank>
    		//Ticket type: Single, Two-Part Return, Excess
    		//Condition: Kiosk printing
    		//Value: "Kiosk: {FIELD_00136}"
    		//Otherwise: <blank>
    		//Ticket type: All
    		//Not Kiosk and not ToD
    		//Condition: An optional retailer reference
    		//Otherwise: <blank>
    		
    	} else {
    		Log.e(TAG,"Coupon " + couponFormat + " field " + sFieldID + " not defined");
    		sValue = "??";
    	}
    	
     	
    	return sValue;
    	
    }
    
	String dateToTime(Date dteDate){
		
		return( DataConvert.displayTextTime(dteDate));
	
	}
	String DateToString(Date dteDate){
		int year = 0;
		int month = 0;
		int dayOfMonth = 0;
		 //TODO check  RSP 3018 specified month abbreviations.
		String rspMonth[] = {"JNR","FEB","MAR", "APR","MAY","JUN","JLY","AUG","SEP","OCT","NOV","DEC"};
		
	    
		year = DataConvert.getYear(dteDate);
		month = DataConvert.getMonth(dteDate);
		dayOfMonth = DataConvert.getDayOfMonth(dteDate);
		
		String strYear = String.format("%02d", (year - 2000) );
		String strMonth = rspMonth[month];
		String strDay = String.format("%02d", dayOfMonth );

	    
	    return strDay + "-" + strMonth + "-" + strYear;
	}
	
	Date stringToDate(String strDate){
		int year = 0;
		int month = 0;
		int dayOfMonth = 0;
		int hour = 0;
		int minute = 0;
		
		// Input format is CCYYMMDDhhmm

	    
	    if (strDate.length() >= 4){
	    	year = Integer.parseInt(strDate.substring(0, 4)); 
		}
	    if (strDate.length() >= 6){
	    	month = Integer.parseInt(strDate.substring(4, 6)); 
		}
	    if (strDate.length() >= 8){
	    	dayOfMonth = Integer.parseInt(strDate.substring(6, 8)); 
		}
	    if (strDate.length() >= 10){
	    	hour = Integer.parseInt(strDate.substring(8, 10)); 
		}
	    if (strDate.length() >= 12){
	    	minute = Integer.parseInt(strDate.substring(10, 12)); 
		}
	    
	    Date dateRepresentation = DataConvert.setDate(null, year, month, dayOfMonth);
	    dateRepresentation = DataConvert.setTime(dateRepresentation, hour, minute, 0);
	    
	    return dateRepresentation;
	}
	
	private String NumberToWords(int intNumber){
		String strNumbers[] = {"NIL","ONE","TWO","THREE","FOUR","FIVE","SIX","SEVERN","EIGHT","NINE"};
		if (intNumber > 9) {
			return String.format("00", intNumber);
		} else if (intNumber < 0) {
			return "ERROR"; // TODO
		} else {
			return strNumbers[intNumber];
		}
		
	}
	
}
