package com.example.twolibs.FulfilmentBL;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DataTransferBL.DataTransferManager.FileType;

public class CCSTFulfilment {
	private static String CLASS_NAME = "CCSTFulfilment";  // Used for tracing
	//
	// This class supports the fulfilment to CCST stock functions of the application
	//
	// It handles the interface to the c coupon formating code
	//    
	public enum Response {
		OK,
		Error
	}
	public static class STDResponse  {
		public Response result = Response.OK;
		public String extra = "";
		public String trace = "";
	}


	public STDResponse doGenPectabs() {
	    // Calls the C library to parse the ccst data and setup the coupons
   
		STDResponse result = new STDResponse();
		result.result = Response.Error;
		result.trace = "Begin";
		
        //System.loadLibrary("twolib-second");

		
		DataTransferManager.STDContentResponse resp = DataTransferManager.getContent(FileType.CCSTFORMATS);

	    if(resp.result == DataTransferManager.Response.OK){ 
	    	
	        byte[] bTrace;
		    int iTraceSize=10000;
		    int libResult;	
		    
		    bTrace = StringToCBuff(iTraceSize,"");	
		    libResult = GenPectabs(resp.content,(int)resp.content.length+ 10,bTrace);
		    result.trace = CBuffToString(iTraceSize,bTrace);
		    
			if(libResult == 0){
				result.result = CCSTFulfilment.Response.OK;
			} else {
				result.result = CCSTFulfilment.Response.Error;
			}        

	    }
    	
		return(result);
	}
	    
	public STDResponse doGetFieldIds(String sFormatID) {
	    	
		// Calls the C library to field list for a given CCST format
   

		STDResponse result = new STDResponse();
		result.result = Response.Error;
		result.trace = "Not set";

       
		byte[] bIdList;
		int iIdListSize=10000;
		bIdList = StringToCBuff(iIdListSize,"");
       
		byte[] bTrace;
		int iTraceSize=10000;
		bTrace = StringToCBuff(iTraceSize,"");
       
		int libResult = GetFieldIds(sFormatID, bIdList,  iIdListSize, bTrace);
		result.extra = CBuffToString(iIdListSize,bIdList);  
		result.trace = CBuffToString(iTraceSize,bTrace);
		if (libResult == 0){
			result.result = CCSTFulfilment.Response.OK;
		} else {
			result.result = CCSTFulfilment.Response.Error;
		}   
       
		return (result);   	    	
   }

	public STDResponse doGetFieldData(String sFieldList,CCSTCoupon coupon) {
	
		// Get the data from the fare for all of the required fields
		
		STDResponse result = new STDResponse();
		result.result = Response.Error;
		result.trace = "Not set";
		
		String[] fieldIds = sFieldList.split("\\|");	
		
		String fieldId="";
		String fieldValue="";
		StringBuilder fieldValuePairs = new StringBuilder(10000);
		for(int i=0; i < fieldIds.length; i++){
			fieldId = fieldIds[i];
			if (fieldId.length()>0){
				
		        //TODO need to lookup fields from a ticket
				fieldValue = coupon.LookupField(fieldId);
				fieldValuePairs.append(fieldId);
				fieldValuePairs.append("^");
				fieldValuePairs.append(fieldValue);
				fieldValuePairs.append("|");
			}
		}
		result.result = Response.OK;
		result.extra = fieldValuePairs.toString();
		result.trace = "OK";
	
		return (result);
	
	}
	   
	public STDResponse doGetPrintData(String sFormatID, String sFieldValueList) {
	   	
		STDResponse result = new STDResponse();
		result.result = Response.Error;
		result.trace = "Not set";

		   
		byte[] bPrintData;
		int iPrintDataSize=10000;
		bPrintData = StringToCBuff(iPrintDataSize,"");
		   
		byte[] bTrace;
		int iTraceSize=10000;
		bTrace = StringToCBuff(iTraceSize,"");
		   
		int libResult =  GetPrintData(sFormatID,sFieldValueList, sFieldValueList.length()+1, bPrintData,  iPrintDataSize, bTrace);	
		result.extra = CBuffToString(iPrintDataSize,bPrintData);  
		result.trace = CBuffToString(iTraceSize,bTrace);  
		   
		if (libResult == 0){
			result.result = CCSTFulfilment.Response.OK;
		} else {
			result.result = CCSTFulfilment.Response.Error;
		}   
		
		return (result);   	    	
	   	
	}
	   
	private String CBuffToString(int iSize, byte[] bInput ){
		StringBuilder sNew = new StringBuilder(iSize);
		
       char ch;
       for(int i = 0; i < iSize; i=i+1){
       	if( bInput[i] == 0 ){
       		break;
       	}
       	ch = (char)bInput[i];
       	sNew.append( ch);
       }
		
		return sNew.toString();
	}

   private static byte[] StringToCBuff(int iSize, String sInput ){
   	byte[] bNewBuffer;
   	
   	bNewBuffer = new byte[iSize];
   	int l = sInput.length();
   	if (l > iSize){
   		l = iSize;
   	}
   	
   	if (l>0){
   		// Copy the string into the buffer
   		int i;
	    	for(i=0; i<l; i++){
	    		bNewBuffer[i] = (byte) sInput.charAt(i);
	    		
	    	}
	    	// Add a null to terminate for C
	    	if (i>=l){
	    		bNewBuffer[l-1]=0;
	    	} else {
	    		bNewBuffer[i]=0;
	    	} 	
	    	
   	}
   	
   	return bNewBuffer;
   }
   
    public native int GenPectabs( byte[] PectabXml,int PectabXmlSize, byte[] buff);
    public native int GetFieldIds(String FormatId,byte[] IdList, int IdListSize, byte[] buff);
    public native int GetPrintData(String FormatId,String FieldValueList, int FieldValueListSize, byte[] PrintData, int PrintDataSize, byte[] buff);

}
