package com.example.twolibs.FulfilmentBL;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;


import com.example.twolibs.AppContext;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.BasketSupport.ItemType;
import com.example.twolibs.SessionBL.SDCIData;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class FulfilmentManager {
	private static String CLASS_NAME = "FulfilmentManager";  // Used for tracing
	//
	// This class supports the fulfilment related functions of the application
	//
	// It handles the interface to the c coupon formating code
	//    

	// Refresh flag - if set will force a refresh when required.
	private static boolean refreshRequired = true;
	private static String DataDomain = "FulfilmentData";
	
	private static boolean ready = false;
	private static CCSTFulfilment ccstFulf = new CCSTFulfilment();

	public enum Response {
		OK,
		Error
	}
	
	public static class STDResponse  {
		public Response result = Response.OK;
		public String extra = "";
		public String trace = "";
	}

	public static class STDCreateCouponsResponse extends STDResponse {
		public ArrayList<SDCIData> sdciRecords = new ArrayList<SDCIData>();
		public ArrayList<CCSTCoupon> ccstCoupons = new ArrayList<CCSTCoupon>();
	}
	
	
	public static void dataChanged(String pDataDomain){
		//
		// Method is called whenever the dataDownLoad service updates a data domain
		//
		if(pDataDomain.equals(DataDomain)){
			refreshRequired = true;
		}
	}

	
	public static void refreshdata(){
		final String FUNC_NAME = "refreshdata"; 	   	
    	// 
    	// Resets all the data associated with the Fulfilment subsystem
    	// 
		// Returns the load list of duties
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		if(refreshRequired){

			CCSTFulfilment.STDResponse resp = ccstFulf.doGenPectabs();
		    if(resp.result == CCSTFulfilment.Response.OK){ 
				ready=true;
			} else {
				ready=false;
			}        
				
			refreshRequired = false;
			
		} 
	
		return ;
	}
	
	
	public static AppContext.DomainStatusResponse checkStatus(){
		final String FUNC_NAME = "checkStatus"; 	   	
    	// 
    	// Find out whether there is a due duty
    	// If so we need to flag action is required and setup a title
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		AppContext.DomainStatusResponse resp = new AppContext.DomainStatusResponse();
		
   	
		// If a duty has been selected then update task states as time might have past
		
		if(ready ){
			resp.status = AppContext.MenuState.NORMAL;
			resp.shortDescrition = "Fulfilment";
		} else {
			resp.status = AppContext.MenuState.NOTIFY;
			resp.shortDescrition = "Fulfilment\n(Data)";
		}
        
       return resp;
	}
	
	
	public static STDCreateCouponsResponse createFulfilmentCoupons(AppContext bb, Basket pBasket){
		final String FUNC_NAME = "createFulfilmentCoupons"; 	   	
		
		// Create a list of coupons (+ SDCI) to fulfill for the basket
		
		STDCreateCouponsResponse resp = new STDCreateCouponsResponse();
		resp.result = Response.OK;
		
		// Set up data ready for fulfilment
		
		// Process tenders to determine the Method of payment
		String methodOfPayment = determineMOP(pBasket);
		
		
		int intTicketNumber;
		Date dteSaleDate = DataConvert.getNow();
		
		
		//TODO shift data etc.
		intTicketNumber = 1000;
		
		
		for(BasketSupport bs: pBasket.basketProducts){
			SDCIData sd;
			CCSTCoupon coupon;

			if(bs.itemType == ItemType.FARE){
				sd = new SDCIData();
				
				// TODO shift data
				sd.MachineNumber = 1120;
				sd.SellingNLC = "5520";
				sd.WindowNumber = 31;
				
				sd.saleTimestamp = dteSaleDate;
				intTicketNumber += 1;
				sd.intTicketNumber = intTicketNumber;
				
				resp.sdciRecords.add(sd); //TODO do we need this or whould we just use the coupon links
				
				// TODO groups of passengers..
				
				coupon = createCoupon(bb,bs,sd,methodOfPayment);
				
				if (bs.ticket.getFa_SingleOrReturn().equals("S")){
					coupon.strTravelDirection ="SGL";
					coupon.blnReverseFlow = false;
					resp.ccstCoupons.add(coupon);
					
				} else if (bs.ticket.getFa_SingleOrReturn().equals("R")){
					coupon.strTravelDirection ="OUT";
					coupon.blnReverseFlow = false;
					resp.ccstCoupons.add(coupon);
					
					coupon = createCoupon(bb,bs,sd,methodOfPayment);
					coupon.strTravelDirection ="RET";
					coupon.blnReverseFlow = true;
					resp.ccstCoupons.add(coupon);
					
				} else {
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.ERROREXIT,  "Unhandled "+ bs.ticket.getFa_SingleOrReturn(), 0);
					resp.result = Response.Error;
				}
								
				
			}

		}		
		
		// Now process the coupons to get them ready to be processed.
		CCSTFulfilment.STDResponse formatResp;
		String fieldList = "";
		String sFieldValueList = "";
		for(CCSTCoupon coupon:resp.ccstCoupons){
			
			// TODO Check type of print...
			// Get the fields that are required for the coupon
			formatResp = ccstFulf.doGetFieldIds(coupon.couponFormat);
			if(formatResp.result == CCSTFulfilment.Response.OK){
				fieldList = formatResp.extra;
				
				// Get the data for the fields 
				
				formatResp = ccstFulf.doGetFieldData(fieldList, coupon);
				sFieldValueList = formatResp.extra;
				if(formatResp.result == CCSTFulfilment.Response.OK){
					
					// Format the printer message with the data for the coupon
					
					formatResp = ccstFulf.doGetPrintData(coupon.couponFormat, sFieldValueList);
					if(formatResp.result == CCSTFulfilment.Response.OK){
						coupon.strPrintMessage = formatResp.extra;
						
					} else {
						TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
								Category.ERROREXIT,  "Can't format msg "+ coupon.couponFormat, 0);
						
						resp.result = Response.Error;
					}

				} else {
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.ERROREXIT,  "Can't format data "+ coupon.couponFormat, 0);
					
					resp.result = Response.Error;
				}
				
				
				
			} else {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT,  "Can't format "+ coupon.couponFormat, 0);
				
				resp.result = Response.Error;
			}
		}
		
		return resp;
	}

	public static STDCreateCouponsResponse createTestCoupon(){
		final String FUNC_NAME = "createFulfilmentCoupons"; 	   	
		
		// Create a list of coupons (+ SDCI) to fulfill for the basket
		
		STDCreateCouponsResponse resp = new STDCreateCouponsResponse();
		resp.result = Response.OK;
		
		// Set up data ready for fulfilment
		
		// Process tenders to determine the Method of payment
		String methodOfPayment = "M";
		
		
		int intTicketNumber;
		Date dteSaleDate = DataConvert.getNow();
		
		
		//TODO shift data etc.
		intTicketNumber = 1000;
		
		
		SDCIData sd;
		sd = new SDCIData();
		
		// TODO shift data
		sd.MachineNumber = 1120;
		sd.SellingNLC = "5520";
		sd.WindowNumber = 31;
		
		sd.saleTimestamp = dteSaleDate;
		intTicketNumber += 1;
		sd.intTicketNumber = intTicketNumber;
		
		resp.sdciRecords.add(sd); //TODO do we need this or whould we just use the coupon links
		
		// TODO split with CCSTFulfilment...
		
		CCSTCoupon coupon = new CCSTCoupon();
		resp.ccstCoupons.add(coupon);
		coupon.sdci = sd;		
		
		coupon.couponFormat = "P01";
		
		coupon.bsItem = new BasketSupport();
		// TODO if the test coupon has data we may need to create a type?
		coupon.bsItem.itemType = ItemType.COMMENT;
		
		
		// Now process the coupons to get them ready to be processed.
		CCSTFulfilment.STDResponse formatResp;
		String fieldList = "";
		String sFieldValueList = "";

		// TODO Check type of print...
		// Get the fields that are required for the coupon
		formatResp = ccstFulf.doGetFieldIds(coupon.couponFormat);
		if(formatResp.result == CCSTFulfilment.Response.OK){
			fieldList = formatResp.extra;
			
			// Get the data for the fields 
			
			formatResp = ccstFulf.doGetFieldData(fieldList, coupon);
			sFieldValueList = formatResp.extra;
			if(formatResp.result == CCSTFulfilment.Response.OK){
				
				// Format the printer message with the data for the coupon
				
				formatResp = ccstFulf.doGetPrintData(coupon.couponFormat, sFieldValueList);
				if(formatResp.result == CCSTFulfilment.Response.OK){
					coupon.strPrintMessage = formatResp.extra;
					
				} else {
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.ERROREXIT,  "Can't format msg "+ coupon.couponFormat, 0);
					
					resp.result = Response.Error;
				}

			} else {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT,  "Can't format data "+ coupon.couponFormat, 0);
				
				resp.result = Response.Error;
			}
								
				
		} else {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ERROREXIT,  "Can't format "+ coupon.couponFormat, 0);
			
			resp.result = Response.Error;
		}
	
		
		return resp;
	}

	
	private static String determineMOP(Basket basket){
		String sMOP = "";

		for(BasketSupport bs: basket.basketTenders){
			if(sMOP.contains(bs.tender.methodOfPayment())){
				sMOP = sMOP + bs.tender.methodOfPayment();
			}

		}
		
		// TODO implement proper precedence table
		if(sMOP.contains("X")){
			return "X";
		}	
		
		return sMOP;
	}

	private static CCSTCoupon createCoupon(AppContext bb, BasketSupport bs, SDCIData sd, String methodOfPayment){
		
		// TODO split with CCSTFulfilment...
		
		CCSTCoupon coupon = new CCSTCoupon();
		coupon.sdci = sd;
		coupon.bsItem = bs;
		coupon.SetupFare(bb);
		coupon.strCouponMethodOfPayment = methodOfPayment;
		
		// TODO use correct ticket format
		coupon.couponFormat = coupon.tkt.getTd_CouponFormat();
		// TODO correct number of tickets..
		coupon.intNumAdults = bs.ticket.getFa_NumAdults();
		coupon.intNumChildren = bs.ticket.getFa_NumChildren();
		
		coupon.intNumCoupons =0;
		coupon.dlbCouponValue =bs.ticket.getFa_TotalFareS();
		
		return coupon;
	}

}
