package com.example.twolibs.FulfilmentGUI;


import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DevicesBL.CCSTPrinterService;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;

public class CCSTPrinting extends Activity {

	private String TAG = "CCSTPrinting";
	
    
    private int currentCoupon=0;
    private AppContext bb = null;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_ccst_printing);

		setTitle(" CCST Printing");
	  	bb  = (AppContext)getApplicationContext();
	  	bb.basket.refreshBasket(bb);
	    		
		Button cmdTestPrint = (Button)findViewById(R.id.cmdTestPrint);
		cmdTestPrint.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			    Log.e(TAG,"cmdTestPrint requested");
			    doPrintTestCoupon();
	    
		    	
			}
		});
		
		Button cmdDone = (Button)findViewById(R.id.cmdDone);
		cmdDone.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			    Log.e(TAG,"cmdDone requested");
			    
             	Intent returnIntent = new Intent();
               	setResult(RESULT_OK,returnIntent);
               	finish(); 
		    	
			}
		}); 		

		
		
		Button cmdCCSTStatus = (Button)findViewById(R.id.cmdCCSTStatus);
		cmdCCSTStatus.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {
				
			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);
			    txtCCSTStatus.setText("Checking printer");
			    
			    Intent intent = new Intent(CCSTPrinting.this, CCSTPrinterService.class);
			    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_STATUS);
			    intent.putExtra(CCSTPrinterService.MAC_ADDRESS, "");
			    startService(intent);
			}
		});
		
	
        Intent intent = getIntent();
        if(intent != null){
        	// (if it was null then somebody hit cancel to get here so we don't need to look further)
	        String nextAction = intent.getStringExtra("nextAction");
	        if(nextAction != null){
		        if(nextAction.equals("print")) {
		        	// Start printing
		        	doPrintCouponNext();
		        }
	        }              			  
        }
        
	}
	
	
	// CCST - Code
	private final BroadcastReceiver receiverCCST = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				int resultCode = bundle.getInt(CCSTPrinterService.RESULT);
				String string = bundle.getString(CCSTPrinterService.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(CCSTPrinterService.MESSAGE_ORIGIN);
				if(origin == null) {
					origin = "no origin";
				}
				
				Log.e("DS","BC1 received " + origin);
				    
				TextView tv = (TextView) findViewById(R.id.txtCCSTStatus);
				if(origin.equals(CCSTPrinterService.CLASS_NAME)) {
					if (resultCode == RESULT_OK) {
						tv.setText("CCST ok" + string);
						tv.setBackgroundColor(Color.GREEN);
						tv.setTextColor(Color.BLACK);		
	
					} else {
						tv.setText("CCST failed " + resultCode + "\n" +  string);
						tv.setBackgroundColor(Color.RED);
						tv.setTextColor(Color.BLACK);		
					}
				}
				
				if(origin.equals(CCSTPrinterService.CLASS_NAME)){
					int request = bundle.getInt(CCSTPrinterService.MESSAGE_REQUEST);
					if(request == CCSTPrinterService.REQUEST_PRINT ){
						doPrintCouponNext();
					}
				}

			}
		}
	};
	

    @Override
    protected void onResume() {
        super.onResume();
        // Register the BroadcastReceiver for ACTION_FOUND
        this.registerReceiver(receiverCCST, new IntentFilter(CCSTPrinterService.NOTIFICATION));

    }

    @Override
    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(receiverCCST);
    }


	public void doPrintTestCoupon(){	
		TextView txtCCSTStatus = (TextView) findViewById(R.id.txtCCSTStatus);
		
		// Create a test print coupon
		FulfilmentManager.STDCreateCouponsResponse resp = FulfilmentManager.createTestCoupon();
		if(resp.ccstCoupons.size() < 1){
			txtCCSTStatus.setText("Error formating test coupon ");		
			return;
		}
		
		CCSTCoupon coupon = resp.ccstCoupons.get(0);
		
		// TODO control the print better....
		// This sets the size bigger then the current list to ensure we don't reprint coupons.
		currentCoupon = bb.basket.ccstCoupons.size() +1;
		txtCCSTStatus.setText("Printing test coupon ");			    
				
	    Intent intent = new Intent(CCSTPrinting.this, CCSTPrinterService.class);
	    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_PRINT);
	    intent.putExtra(CCSTPrinterService.MESSAGE_CONTENT, coupon.strPrintMessage);
	    startService(intent);	
		
	}
    
	public void doPrintCouponNext(){	
		TextView txtCCSTStatus = (TextView) findViewById(R.id.txtCCSTStatus);
		currentCoupon = currentCoupon +1;
		if(currentCoupon <= bb.basket.ccstCoupons.size()){
			txtCCSTStatus.setText("Printing coupon " + currentCoupon + " of " + bb.basket.ccstCoupons.size());			    
		} else {
			txtCCSTStatus.setText("Finished printing " + bb.basket.ccstCoupons.size());
			currentCoupon = 0;
			return;
		}
		
		CCSTCoupon coupon =  bb.basket.ccstCoupons.get(currentCoupon-1);
		
	    Intent intent = new Intent(CCSTPrinting.this, CCSTPrinterService.class);
	    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_PRINT);
	    intent.putExtra(CCSTPrinterService.MESSAGE_CONTENT, coupon.strPrintMessage);
	    startService(intent);	
		
	}
	
}