package com.example.twolibs.LocationBL;

import java.io.Serializable;
import java.util.HashMap;

public class Location implements Serializable  {

	static HashMap<String, Location> crsCodes = new HashMap<String, Location>();
	static HashMap<String, Location> nlcCodes = new HashMap<String, Location>();

	static LocationManager locSearch = new LocationManager();
	
	String strNLC="";
	String strCRS="";
	String strSize="";
	String strDescription="";
	
	 public String getNLC(){
		   return strNLC;
		  }

	 public void setNLC(String p){
		 strNLC = p;
		  }
	 
	 public String getUIC(){
		   if (strNLC.length() == 4){
			   return "70" + strNLC + "0";
		   } else if (strNLC.length() == 6){
			   return strNLC + "0";
		   } else {
			   return strNLC;
		   }
		  }
	 
	 public String getCRS(){
		   return strCRS;
		  }

	 public void setCRS(String p){
		 strCRS = p;
		  }
	 public String getSize(){
		   return strSize;
		  }

	 public void setSize(String p){
		 strSize = p;
		  }
	 public String getDescription(){
		   return strDescription;
		  }

	 public void setDescription(String p){
		 strDescription = p;
		  }	 
	 
	 public void setBaseString(String p){
		 
		 String delims = "[|]";
		 String[] tokens = p.split(delims);
		 strNLC = tokens[0];
		 strCRS = tokens[1];
		 strSize = tokens[2];
		 strDescription = tokens[3];
		 
		 
		 }	 
	 
	 public static Location getLocationByCRS(String crsCode){
		Location loc;
		if (crsCodes.containsKey(crsCode)){
			loc = crsCodes.get(crsCode);
		} else {
			LocationManager.LookupResponse resp = locSearch.GetLocationByCRS(crsCode);
			if(resp.result == 0){
				loc = resp.location;			
				crsCodes.put(crsCode,loc);
			} else {
				loc = null;
			}
 		}
		return loc;

	 }
	 
	 public static Location getLocationByNLC(String nlcCode){
		Location loc;
		if (nlcCodes.containsKey(nlcCode)){
			loc = nlcCodes.get(nlcCode);
		} else {
			LocationManager.LookupResponse resp = locSearch.GetLocationByNLC(nlcCode);
			if(resp.result == 0){
				loc = resp.location;			
				nlcCodes.put(nlcCode,loc);
			} else {
				loc = null;
			}
 		}
		return loc;

	 }
}
