package com.example.twolibs.LocationBL;

import java.io.File;
import java.util.ArrayList;

import android.os.Environment;

public class LocationManager {

	private static String CLASS_NAME = "LocationManager"; // Used for tracing

	// This class handles the location search interface
	//
	// Refresh flag - if set will force a refresh when required.
	private static boolean refreshRequired = true;
	private static String DataDomain = "LocationData";

	private static LocationManager myInstance = new LocationManager();

	public LocationManager()
	{
		//System.loadLibrary("LOCATIONS");
	}
	
	public static class STDResponse {
		public int result = 0;
		public String extra = "";
		public String trace = "";
	}

	public class SearchResponse extends STDResponse {
		public ArrayList<Location> locations = new ArrayList<Location>();
	}

	class LookupResponse extends STDResponse {
		public Location location = null;
	}

	public static void dataChanged(String pDataDomain) {
		//
		// Method is called whenever the dataDownLoad service updates a data
		// domain
		//
		if (pDataDomain.equals(DataDomain)) {
			refreshRequired = true;
		}
	}

	public static void refreshdata(String locfile) {
		final String FUNC_NAME = "refreshdata";
		//
		// Resets all the data associated with the Duty subsystem
		//
		// Returns the load list of duties
		// TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
		// Category.ENTRY, "", 0);

		if (refreshRequired) {

			STDResponse resp = new STDResponse();
			resp.result = -1;
			resp.trace = "Begin";

			File file = new File(locfile);
			byte[] bTrace;
			int iTraceSize = 10000;

			bTrace = StringToCBuff(iTraceSize, "");

			int iLocs = myInstance.loadData(locfile, bTrace);
			if (iLocs > 0) {
				resp.result = 0;
			}

			resp.extra = locfile + " " + iLocs + " ";
			resp.trace = CBuffToString(iTraceSize, bTrace);

			// TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
			// Category.EXIT, "Loaded " + iLocs, 0);
		}

		return;

	}

	public LookupResponse GetLocationByNLC(String sSearchNLC) {

		LookupResponse resp = new LookupResponse();

		ArrayList<Location> resultList;
		Location objLocation;

		byte[] bResults;
		int iResultsSize = 5000;

		byte[] bTrace;
		int iTraceSize = 10000;

		bResults = StringToCBuff(iResultsSize, "");
		bTrace = StringToCBuff(iTraceSize, "");

		int iLocs = 0;
		int iSearchType = 2; // NLC search

		iLocs = findLocations(iSearchType, "", false, sSearchNLC.toUpperCase(),
				1, bResults, bTrace);

		if (iLocs <= 0) {
			objLocation = new Location();

		} else {
			resultList = CBuffToLocations(iResultsSize, bResults);
			objLocation = resultList.get(0);
		}

		resp.extra = sSearchNLC + " " + iLocs + " ";
		resp.trace = CBuffToString(iTraceSize, bTrace);
		resp.location = objLocation;

		return resp;
	}

	public LookupResponse GetLocationByCRS(String sSearchCRS) {

		LookupResponse resp = new LookupResponse();

		ArrayList<Location> resultList;
		Location objLocation;

		byte[] bResults;
		int iResultsSize = 5000;

		byte[] bTrace;
		int iTraceSize = 10000;

		String sFindTrace;
		String sOutput;
		String sProgress;

		bResults = StringToCBuff(iResultsSize, "");
		bTrace = StringToCBuff(iTraceSize, "");

		int iLocs = 0;
		int iSearchType = 1;

		iLocs = findLocations(iSearchType, "", false, sSearchCRS.toUpperCase(),
				1, bResults, bTrace);

		sProgress = sSearchCRS + "Res " + iLocs + " ";

		sFindTrace = CBuffToString(iTraceSize, bTrace);

		if (iLocs <= 0) {
			objLocation = new Location();

		} else {
			resultList = CBuffToLocations(iResultsSize, bResults);
			objLocation = resultList.get(0);
		}

		resp.extra = sSearchCRS + " " + iLocs + " ";
		resp.trace = CBuffToString(iTraceSize, bTrace);
		resp.location = objLocation;

		return resp;

	}

	public static SearchResponse GetMatchingLocations(String sHome,
			boolean bToSearch, String sSearch, int iRequested) {

		SearchResponse resp = myInstance.new SearchResponse();
		resp.result = -1;
		resp.trace = "Begin";

		byte[] bResults;
		int iResultsSize = 10000;

		byte[] bTrace;
		int iTraceSize = 10000;

		bResults = StringToCBuff(iResultsSize, "");
		bTrace = StringToCBuff(iTraceSize, "");

		int iLocs = 0;
		int iSearchType = 0;

		// Just checking....
		if (sHome == null) {
			sHome = "";
		}
		if (sSearch == null) {
			sSearch = "";
		}

		// if (DutyManager.activeTask != null){
		//
		// if (DutyManager.activeTask.trainStopsNLC.size() > 0){
		// if((DutyManager.activeTask.trainStopsNLC.size()-1) >iRequested ){
		// iRequested =DutyManager.activeTask.trainStopsNLC.size() -1;
		// } else if (sSearch.length() == 0){
		// iRequested = DutyManager.activeTask.trainStopsNLC.size();
		// }
		// String stops = convertToDelim(DutyManager.activeTask.trainStopsNLC);
		// iLocs = myInstance.findLocations(iSearchType, stops, bToSearch,
		// sSearch.toUpperCase(), iRequested, bResults, bTrace);
		// } else {
		// iLocs = myInstance.findLocations(iSearchType, sHome, bToSearch,
		// sSearch.toUpperCase(), iRequested, bResults, bTrace);
		// }
		// }else {
		
		//sHome = "7031550|7031490|7064690|7064880|7064980|7064990|7065110|7065240|7031550|7065270|7065300|7065320|7065460|7065480|7065510|7065650|7065700|7065740|7066150|7066160|7066630|7066640|7066670|7066760|7066800|7066860|7066880|7066900|7066910|7067070|7067290|7067320|7067740|7067810|7067820|7067860|7067940|7068000|7068010|7068040|";
		iLocs = myInstance.findLocations(iSearchType, sHome, bToSearch,
				sSearch.toUpperCase(), iRequested, bResults, bTrace);
		// }

		resp.extra = sSearch + "Res " + iLocs + " ";

		if (iLocs <= 0) {
			resp.result = -2;
			resp.locations = new ArrayList<Location>();
			resp.trace = CBuffToString(iTraceSize, bTrace);

		} else {
			resp.result = 0;
			resp.locations = CBuffToLocations(iResultsSize, bResults);
			resp.trace = CBuffToString(iResultsSize, bTrace);

		}
		return resp;
	}

	private static String convertToDelim(ArrayList<String> pList) {
		// Routine to convert a list into a | separating string
		StringBuilder delimString = new StringBuilder(1000);
		boolean first = true;
		if (pList == null) {
			return "";
		}
		for (String entry : pList) {
			if (!first) {
				delimString.append("|");
			}
			delimString.append(entry);
			first = false;
		}
		return delimString.toString();
	}

	private static ArrayList<Location> CBuffToLocations(int iSize, byte[] bInput) {

		StringBuilder sNew = new StringBuilder(200);
		ArrayList<String> myList = new ArrayList<String>();

		ArrayList<Location> locList = new ArrayList<Location>();
		StringBuilder sField = new StringBuilder(200);

		Location loc = new Location();

		char ch;

		int iFieldNo = 0;

		for (int i = 0; i < iSize; i = i + 1) {

			if (bInput[i] == 0) {
				break;
			}
			ch = (char) bInput[i];
			switch (ch) {
			case '|':
				switch (iFieldNo) {
				case 0:
					loc.strNLC = sField.toString();
					break;
				case 1:
					loc.strCRS = sField.toString();
					break;
				case 2:
					loc.strSize = sField.toString();
					break;
				case 3:
					loc.strDescription = sField.toString();
					break;
				}
				sField = new StringBuilder(200);

				iFieldNo++;

				sNew.append(ch);
				break;

			case '\r':

				myList.add(sNew.toString());
				// myList.add(loc.strDescription);

				sNew = new StringBuilder(200);

				iFieldNo = 0;

				locList.add(loc);

				loc = new Location();

				break;
			case '\n':
				//
				break;
			default:
				//
				sNew.append(ch);

				sField.append(ch);

			}

		}

		return locList;
	}

	private static byte[] StringToCBuff(int iSize, String sInput) {
		byte[] bNewBuffer;

		bNewBuffer = new byte[iSize];
		int l = sInput.length();
		if (l > iSize) {
			l = iSize;
		}

		if (l > 0) {
			// Copy the string into the buffer
			int i;
			for (i = 0; i < l; i++) {
				bNewBuffer[i] = (byte) sInput.charAt(i);

			}
			// Add a null to terminate for C
			if (i >= l) {
				bNewBuffer[l - 1] = 0;
			} else {
				bNewBuffer[i] = 0;
			}

		}

		return bNewBuffer;
	}

	private static String CBuffToString(int iSize, byte[] bInput) {
		StringBuilder sNew = new StringBuilder(iSize);

		char ch;
		for (int i = 0; i < iSize; i = i + 1) {
			if (bInput[i] == 0) {
				break;
			}
			ch = (char) bInput[i];
			sNew.append(ch);
		}

		return sNew.toString();
	}

	public static native int loadData(String s, byte[] buff);

	public static native int findLocations(int iSearchType, String sHome,
			boolean bToSearch, String sSearch, int iRequested, byte[] results,
			byte[] buff);

}
