/*
 * clsIJQLocation.java
 *
 * Created on 05 October 2005, 14:02
 *
 * @author MountfordABJ
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 * 02.06.2006       RS              Added CRSCode amd made Serializable.
 * 12.07.2006       abjm            QR00010: Quality Report,
 *                                      Properties documented.
 */

package com.example.twolibs.LocationBL;
// JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

/**
 * Contains the IJQ subset of Location information.
 *
 */
public class clsIJQLocation implements java.io.Serializable {

    private static final long serialVersionUID = 4520136122351929499L;

    /** Location description for ATB (airline) size tickets for the outward 
     *  journey from this location. */ 
    public  String  ATBDescOut;

    /** Location description for ATB (airline) size tickets for the return 
     *  journey from this location. */ 
    public  String  ATBDescRet;

    /** Location description for credit card size tickets for the outward 
     *  journey from this location. */ 
    public  String  CCDescOut;

    /** Location description for credit card size tickets for the return 
     *  journey from this location. */ 
    public  String  CCDescRet;

    /** Used for LUL magnetic stripe encoding. Permitted values are 0, 1, 2
     *  and 3.
     *  0 means use LOC-UTS-NORTH
     *  1 means use LOC-UTS-EAST
     *  2 means use LOC-UTS-SOUTH
     *  3 means use LOC-UTS-WEST */
    public  String  directionInd;

    /** Identifies the location along with the UIC Code. */
    public  String  NLCCode;

    /** 3 character Code. Administrative area code (e.g. "70 " = Britain),
     *  used in combination with the NLC code to produce a unique code for
     *  this location.*/
    public  String  UICCode;

    /** Station's 3 character CRS code. */
    public  String  CRSCode;

    /** Alternative UTS code. used for LUL magnetic stripe encoding. */
    public  String  UTSACode;

    /** Location code for UTS. Only applies to locations which are Underground
     *  stations. used for LUL magnetic stripe encoding. */
    public  String  UTSCode;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSEast;

    /** Indicates whether the station is a London station. Used for LUL 
     *  magnetic stripe encoding. */
    public  String  UTSLondonStationInd;

    /** Used on location records to indicate which transport modes are 
     *  encoded in the ticket (LUL magnetic stripe encoding). */
    public  String  UTSMode;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSNorth;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSOffset;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSPTRBias;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSSouth;

    /** Used for LUL magnetic stripe encoding. */
    public  String  UTSWest;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone1;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone2;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone3;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone4;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone5;

    /** Identifies one of the 6 London zones. Values used in magnetic stripe
     *  encoding. */
    public  String  UTSZone6;

    /** Creates a new instance of clsIJQLocation */
    public clsIJQLocation() {
    }

    /** Creates a new instance of clsIJQLocation */
    public clsIJQLocation(String ATBDescOut,
                          String ATBDescRet,
                          String CCDescOut,
                          String CCDescRet,
                          String directionInd,
                          String NLCCode,
                          String UICCode,
                          String CRSCode,
                          String UTSACode,
                          String UTSCode,
                          String UTSEast,
                          String UTSLondonStationInd,
                          String UTSMode,
                          String UTSNorth,
                          String UTSOffset,
                          String UTSPTRBias,
                          String UTSSouth,
                          String UTSWest,
                          String UTSZone1,
                          String UTSZone2,
                          String UTSZone3,
                          String UTSZone4,
                          String UTSZone5,
                          String UTSZone6) {

        if  (ATBDescOut != null) {
            this.ATBDescOut = new String(ATBDescOut);
        }                          

        if  (ATBDescRet != null) {
            this.ATBDescRet = new String(ATBDescRet);
        }                          

        if  (CCDescOut != null) {
            this.CCDescOut = new String(CCDescOut);
        }                          

        if  (CCDescRet != null) {
            this.CCDescRet = new String(CCDescRet);
        }                          

        if  (directionInd != null) {
            this.directionInd = new String(directionInd);
        }                          

        if  (NLCCode != null) {
            this.NLCCode = new String(NLCCode);
        }                          

        if  (UICCode != null) {
            this.UICCode = new String(UICCode);
        }                          

        if  (CRSCode != null) {
            this.CRSCode = new String(CRSCode);
        }                          
        if  (UTSACode != null) {
            this.UTSACode = new String(UTSACode);
        }                          

        if  (UTSCode != null) {
            this.UTSCode = new String(UTSCode);
        }                          

        if  (UTSEast != null) {
            this.UTSEast = new String(UTSEast);
        }                          

        if  (UTSLondonStationInd != null) {
            this.UTSLondonStationInd = new String(UTSLondonStationInd);
        }                          

        if  (UTSMode != null) {
            this.UTSMode = new String(UTSMode);
        }                          

        if  (UTSNorth != null) {
            this.UTSNorth = new String(UTSNorth);
        }                          

        if  (UTSOffset != null) {
            this.UTSOffset = new String(UTSOffset);
        }                          

        if  (UTSPTRBias != null) {
            this.UTSPTRBias = new String(UTSPTRBias);
        }                          

        if  (UTSSouth != null) {
            this.UTSSouth = new String(UTSSouth);
        }                          

        if  (UTSWest != null) {
            this.UTSWest = new String(UTSWest);
        }                          

        if  (UTSZone1 != null) {
            this.UTSZone1 = new String(UTSZone1);
        }                          

        if  (UTSZone2 != null) {
            this.UTSZone2 = new String(UTSZone2);
        }                          

        if  (UTSZone3 != null) {
            this.UTSZone3 = new String(UTSZone3);
        }                          

        if  (UTSZone4 != null) {
            this.UTSZone4 = new String(UTSZone4);
        }                          

        if  (UTSZone5 != null) {
            this.UTSZone5 = new String(UTSZone5);
        }                          

        if  (UTSZone6 != null) {
            this.UTSZone6 = new String(UTSZone6);
        }                          
    
    }

    /** Returns a string representation of this object, for logging purposes */
    public  String toString() {
        StringBuffer            logBuffer	= new StringBuffer();
        final                   String PREFIX = "\n            ";
        logBuffer.append("\n      clsIJQLocation:");
        logBuffer.append(PREFIX + "ATBDescOut          = " + this.ATBDescOut);
        logBuffer.append(PREFIX + "ATBDescRet          = " + this.ATBDescRet);
        logBuffer.append(PREFIX + "CCDescOut           = " + this.CCDescOut);
        logBuffer.append(PREFIX + "CCDescRet           = " + this.CCDescRet);
        logBuffer.append(PREFIX + "directionInd        = " + this.directionInd);
        logBuffer.append(PREFIX + "NLCCode             = " + this.NLCCode);
        logBuffer.append(PREFIX + "UICCode             = " + this.UICCode);
        logBuffer.append(PREFIX + "CRSCode             = " + this.CRSCode);
        logBuffer.append(PREFIX + "UTSACode            = " + this.UTSACode);
        logBuffer.append(PREFIX + "UTSCode             = " + this.UTSCode);
        logBuffer.append(PREFIX + "UTSEast             = " + this.UTSEast);
        logBuffer.append(PREFIX + "UTSLondonStationInd = " +
                                                    this.UTSLondonStationInd);
        logBuffer.append(PREFIX + "UTSMode             = " + this.UTSMode);
        logBuffer.append(PREFIX + "UTSNorth            = " + this.UTSNorth);
        logBuffer.append(PREFIX + "UTSOffset           = " + this.UTSOffset);
        logBuffer.append(PREFIX + "UTSPTRBias          = " + this.UTSPTRBias);
        logBuffer.append(PREFIX + "UTSSouth            = " + this.UTSSouth);
        logBuffer.append(PREFIX + "UTSWest             = " + this.UTSWest);
        logBuffer.append(PREFIX + "UTSZone1            = " + this.UTSZone1);
        logBuffer.append(PREFIX + "UTSZone2            = " + this.UTSZone2);
        logBuffer.append(PREFIX + "UTSZone3            = " + this.UTSZone3);
        logBuffer.append(PREFIX + "UTSZone4            = " + this.UTSZone4);
        logBuffer.append(PREFIX + "UTSZone5            = " + this.UTSZone5);
        logBuffer.append(PREFIX + "UTSZone6            = " + this.UTSZone6);

        return logBuffer.toString();
    
    }

}
