/*
 * clsAccomAttribute.java
 *
 * Created on 10 June 2005, 10:00
 *
 * @author lambertonr
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 *  10.06.2005      Auto Gen.       Initial.
 *  09.01.2006      abjm            Serialize UID Removed.
 *  14.06.2007      abjm            IR12184: equals() method signature changed
 *                                  from overload to override.
 * 
 */

package com.example.twolibs.LocationBL;
// JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

/** A location link defines the relationship between one location and another.
 *  The equivalent Forte objects also have attributes of class ClsLocationCode
 * which have been removed in this implementation. */
public class clsLocationLink implements java.io.Serializable {

    private static final long serialVersionUID = 3682972358773283797L;

    /** 7 character code that uniquely identifies a location */
    public  String     UIC7Code;
    
    /** 7 character code that uniquely identifies a location linked
     *  to this one (note it may be itself) */
    public  String     linkedUIC7Code;
    
    /** The type of link */
    public  int        type;
    
    /** Qualifies the type of link */
    public  int        qualifier;
    
    
    // Default constructor
    public clsLocationLink() {
        // Initialisation code goes here
    }
    
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n\t\t\t\t- ";
        sData.append(PREFIX + "UIC7Code=" + this.UIC7Code +
                "\t linkedUIC7Code=" + this.linkedUIC7Code +
                "\t type=" + this.type +
                "\t qualifier=" + this.qualifier);
        
        return sData.toString();
    }
    
    /**
     * Determines whether this LocationLink matches another,
     *  based on its attributes
     * 
     *  PROGRAMMING NOTE:
     *     This method overrides the original (inherited from Object)
     *      as we need it to use the Vector.contains() method.
     *      See LocationsHelper.addLocLinks()
     * @param linkObj   Object to be compared. 
     * @return          true if Object values match.
     */
    public boolean equals(Object linkObj) {

        if  (linkObj instanceof clsLocationLink) {
            clsLocationLink link = (clsLocationLink) linkObj;
            if (link==null) {
                return false;
            } else if ((link.qualifier == this.qualifier) &&
                    (link.type == this.type) &&
                    (link.UIC7Code.equals(this.UIC7Code)) &&
                    (link.linkedUIC7Code.equals(this.linkedUIC7Code))) {
                return true;
            }
        }
        return false;
    }    
}
