package com.example.twolibs.LocationGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class LocationListAdaptor extends ArrayAdapter<Location> {
	private final Activity context;
	private final ArrayList<Location> locList;
	
	
	static class ViewHolder {
		public TextView txtDescription;
	}
		
	public LocationListAdaptor(Activity context,ArrayList<Location> locList) {
		super(context, R.layout.location_summary, locList);
		this.context = context;
		this.locList = locList;
	}
		
		  @Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View rowView = convertView;
		// reuse views
		if (rowView == null) {
			LayoutInflater inflater = context.getLayoutInflater();
			rowView = inflater.inflate(R.layout.location_summary, null);
			// configure view holder
			ViewHolder viewHolder = new ViewHolder();
			viewHolder.txtDescription = (TextView) rowView.findViewById(R.id.txtDescription);
			rowView.setTag(viewHolder);
		}
		
		// fill data
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

		Location l = locList.get(position);
		holder.txtDescription.setText(l.getDescription().trim() + " (" + l.getCRS() + ")");
		
		
		return rowView;
	}
  
}
