package com.example.twolibs.LocationGUI;

import java.util.ArrayList;
import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationBL.LocationManager;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;
import android.app.ActionBar;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;


public class LocationLookup extends ListActivity 
	{
	//
	// LocationLookup class is a GUI class to support the picking of locations 
	// It displays a shortlist of location options based on the context and
	// the search text that is entered
	//	
	private static String CLASS_NAME = "DutyMain";    // Used for tracing
	
	// List support for a list of locations that match the criteria
	ArrayList<Location> list = new ArrayList<Location>(); // The list of location objects
	LocationListAdaptor adapter; // The adaptor that will be used to display the list		
	ListView listview; // The part of the screen that will display the locations
		
		
    // The location screen can be called in two contexts:
    // From - to find the origin 
    // To - to find the destination
	public enum CallingContext {
		FROM_SEARCH,		// Task is on the list of this to do today
		TO_SEARCH, 		    // The task is near to its start time and the operator needs to be warned
	}
	
	boolean toSearch;       // Internal flag
	
    int iNumRequested = 40; // Default number of locations in the shortlist TODO get from configuration
  
    /** Called when the activity is first created. */
	
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
    	//
    	// Location lookup is a screen used to enable an operator to select a location
    	//
    	
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_locationlookup);

        // The action bar is suppressed and replaced with a bar
        // that allows text to be input to filter the locations offered
        
        ActionBar actionBar = getActionBar(); 
        actionBar.hide();
        
        // The location screen can be called in two contexts:
        // From - to find the origin 
        // To - to find the destination
        
    	// Set the internal of call from the context.
        int callContext = getIntent().getIntExtra(AppContext.CALL_CONTEXT, 0);  
        if(callContext == CallingContext.FROM_SEARCH.ordinal()){
        	toSearch = true;
        } else {
        	toSearch = false;
        }
        
        // Set the screen for the type:
    	TextView capTitle = (TextView) findViewById(R.id.capTitle);
    	if (toSearch){
    		setTitle("To");
    		capTitle.setText("To");
    	} else {
    		setTitle("From");
    		capTitle.setText("From");
    	} 
    	
    	// refresh the data (if data has not changed this will have no effect
        String locfile;
        locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/LocTable.txt";

    	LocationManager.refreshdata(locfile);
                
   	// Setup the list support
        listview = (ListView) findViewById(android.R.id.list);	  
        adapter = new LocationListAdaptor(this,list);
        setListAdapter(adapter);

        // Make the list entries (i.e. locations) clickable
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
				final String FUNC_NAME = "onItemClick"; 	
           	
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "listview " + position, 0);
           	
            	// If the list item is clicked return the item
              	 Intent returnIntent = new Intent();
               	 returnIntent.putExtra(AppContext.CALL_RESULT_DATA,list.get(position));
               	 setResult(RESULT_OK,returnIntent);
               	 finish();           	
 
            }

          });
        
        
        // The title needs to respond to touch like the action bar would have
        LinearLayout frmTitle = (LinearLayout)findViewById(R.id.frmTitle);
        frmTitle.setOnClickListener(new OnClickListener() {  
			
			public void onClick(View view) {  
				final String FUNC_NAME = "frmTitle"; 	
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, FUNC_NAME, 0);
		
		        // A click is interpreted as back.
				//
				// A bit nasty code to simulate the back being pressed
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN,	KeyEvent.KEYCODE_BACK));
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
			}  
			
		
		}); 
       
        // An edit box in the place of the action bar for the operator to enter the search filter
        EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
        txtSearch.addTextChangedListener(new TextWatcher(){
            public void afterTextChanged(Editable s) {
				final String FUNC_NAME = "afterTextChanged"; 	
            	
            	// As the search is typed we refine the list
    	        EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
    	        String sSearch = txtSearch.getText().toString();
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, FUNC_NAME + ">" + sSearch + "<", 0);
				
            	doSearch(toSearch,sSearch);
            }
            public void beforeTextChanged(CharSequence s, int start, int count, int after){}
            public void onTextChanged(CharSequence s, int start, int before, int count){}
        }); 
        
        // Base search for when the screen is first displayed
        String sSearch = txtSearch.getText().toString();
        doSearch(toSearch,sSearch);
        
        // Put the focus on the search input to pull up the keyboard	        
        txtSearch.requestFocus();               

    }
	 
	public void doSearch(boolean pToSearch, String pSearch ){
		final String FUNC_NAME = "doSearch"; 	
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, FUNC_NAME , 0);
		//
		// Performs a location search and sets up the results on the screen
    	//
     	AppContext bb  = (AppContext)getApplicationContext(); //TODO move to location	   
     	
     	// Get the NLC that the search is relative to (the seed)
    	String strSeed;
    	if (pToSearch){
    		// On a to search the seed is the origin
    		strSeed = bb.getOrigin().getNLC();
    	} else {
    		// On a from search the seed is the home NLC 
			strSeed = bb.getHomeNLC();
    	} 

    	LocationManager.SearchResponse resp = LocationManager.GetMatchingLocations(strSeed,  pToSearch,  pSearch, iNumRequested);
    	ArrayList<Location> myList= resp.locations;
    	
    	String sProgress = "To=" + pToSearch + " " + strSeed + ":" +  pSearch + "Res " + myList.size() + " ";
 		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, FUNC_NAME + " " + sProgress, 0);
                   
        adapter.clear();
        adapter.addAll(myList);
        adapter.notifyDataSetChanged();
    	
    }


}