package com.example.twolibs.MenuGUI;


import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DataTransferGUI.DataTransferMain;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyGUI.DutyMain;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.R.menu;
import com.example.twolibs.SaleGUI.BasketList;
import com.example.twolibs.SessionGUI.LicenceOverride;
import com.example.twolibs.SupportBL.GenericManager;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.app.Activity;
import android.content.Intent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class MenuAdmin extends Activity {

    public static final int REQUEST_TIPS_ACTIVITY = 1;

    public static final int REQUEST_FARE = 2;
	public static final int REQUEST_TIMETABLE = 3;
	public static final int REQUEST_BASKET = 4;
	public static final int REQUEST_DUTY = 5;
	public static final int REQUEST_DEVICES = 6;
	public static final int REQUEST_DATA_TRANSFER = 7;
	public static final int REQUEST_TOD = 8;
	public static final int REQUEST_ACCOUNTS = 9;
	public static final int REQUEST_RETAIL = 10;
	public static final int REQUEST_TRAIN = 11;
	public static final int REQUEST_VALIDATE = 12;

	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_menu_admin);
  
	    setTitle(" Administration menu");
        AppContext bb  = (AppContext)getApplicationContext();
	    
        LinearLayout cmdDuty = (LinearLayout) findViewById(R.id.cmdDuty);
        cmdDuty.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		
        		Intent nextScreen = new Intent(getApplicationContext(), DutyMain.class);  
        		nextScreen.putExtra("nextAction", "");
            	startActivityForResult(nextScreen, 99);

        	}  

        }); 
 
        LinearLayout cmdSpare1 = (LinearLayout) findViewById(R.id.cmdSpare1);
        cmdSpare1.setVisibility(View.INVISIBLE);

        LinearLayout cmdLicence = (LinearLayout) findViewById(R.id.cmdLicence);
        cmdLicence.setOnClickListener(new OnClickListener() {  

	       	public void onClick(View view) {  
	       		
        		Intent nextScreen = new Intent(getApplicationContext(), LicenceOverride.class);  
        		nextScreen.putExtra("nextAction", "");
            	startActivityForResult(nextScreen, 99);
	
	       	}  

        });   
        
        LinearLayout cmdSpare2 = (LinearLayout) findViewById(R.id.cmdSpare2);
        cmdSpare2.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSyncData = (LinearLayout) findViewById(R.id.cmdSyncData);
        cmdSyncData.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), DataTransferMain.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_DATA_TRANSFER);

        	}  

        });          
              
        LinearLayout cmdSpare3 = (LinearLayout) findViewById(R.id.cmdSpare3);
        cmdSpare3.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare4 = (LinearLayout) findViewById(R.id.cmdSpare4);
        cmdSpare4.setVisibility(View.INVISIBLE);
 
        LinearLayout cmdSpare5 = (LinearLayout) findViewById(R.id.cmdSpare5);
        cmdSpare5.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare6 = (LinearLayout) findViewById(R.id.cmdSpare6);
        cmdSpare6.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare7 = (LinearLayout) findViewById(R.id.cmdSpare7);
        cmdSpare7.setVisibility(View.INVISIBLE);

        LinearLayout cmdSpare8 = (LinearLayout) findViewById(R.id.cmdSpare8);
        cmdSpare8.setVisibility(View.INVISIBLE);

        LinearLayout cmdHome = (LinearLayout) findViewById(R.id.cmdHome);
        cmdHome.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

            	 Intent returnIntent = new Intent();
            	 returnIntent.putExtra("nextAction", "");
              	 setResult(RESULT_OK,returnIntent);
              	 finish();           	

        	}  

        }); 
        

        
        refreshData();
        
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() ==  R.id.cmdSync) {
			Toast.makeText(MenuAdmin.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(MenuAdmin.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
    }


    @Override
    public Intent getParentActivityIntent() {

       	Intent newIntent = new Intent(getApplicationContext(), MenuTop.class);          
        return newIntent;
          
     }

    private void refreshData(){
    	
        AppContext bb  = (AppContext)getApplicationContext();
        bb.checkStatus();
                
        // TODO method on all that can change state
        
        TextView txtDuty = (TextView) findViewById(R.id.txtDuty);
        ImageView imgDuty = (ImageView) findViewById(R.id.imgDuty);
        
		GenericManager.DomainStatusResponse resp = new GenericManager.DomainStatusResponse();
		resp = DutyManager.checkStatus();
        imgDuty.getBackground().setLevel(resp.status.ordinal());
        txtDuty.setText(resp.shortDescrition);        
 	  
        
        TextView txtBasket = (TextView) findViewById(R.id.txtHome);
        ImageView imgBasket = (ImageView) findViewById(R.id.imgHome);     
        imgBasket.getBackground().setLevel(bb.menuStatus);
        txtBasket.setText(bb.menuTitle);        

    }
    
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		// This code controls the follow on activity after a selected activity
		switch(requestCode) {
       		case REQUEST_TIPS_ACTIVITY:
       			break;

        	case REQUEST_FARE:
        		 if(resultCode == RESULT_OK){
        			 // Get next action (if set)
        			 String nextAction = data.getStringExtra("nextAction");
        			 
        			 if(nextAction.equals("basket")){
        		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
        	            	nextScreen.putExtra("nextAction", "");
        		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("card")){
	     		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
	     	            	nextScreen.putExtra("nextAction", nextAction);
	     		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("cash")){
		 		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
		 	            	nextScreen.putExtra("nextAction", nextAction);
		 		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 }
        		 }
        		 
     	        if (resultCode == RESULT_CANCELED) {
    	            //Write your code if there's no result
    	        }
        		break;
        	case REQUEST_TIMETABLE:
        		break;
        	case REQUEST_BASKET:
        		break;
        	case REQUEST_DUTY:
        		break;
        	case REQUEST_DEVICES:
        		break;
		}
		refreshData();

	}
	
    

}
