package com.example.twolibs.MenuGUI;


import com.example.twolibs.AppContext;
import com.example.twolibs.R;

import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.R.menu;
import com.example.twolibs.RetailGUI.Retail;
import com.example.twolibs.RetailGUI.RetailMain;
import com.example.twolibs.SaleGUI.BasketList;
import com.example.twolibs.SessionGUI.Logon;
import com.example.twolibs.TimeTableGUI.TimeTableCriteria;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.app.Activity;
import android.content.Intent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class MenuTop extends Activity {

    public static final int REQUEST_TIPS_ACTIVITY = 1;

    public static final int REQUEST_FARE = 2;
	public static final int REQUEST_TIMETABLE = 3;
	public static final int REQUEST_BASKET = 4;
	public static final int REQUEST_DUTY = 5;
	public static final int REQUEST_DEVICES = 6;
	public static final int REQUEST_DATA_TRANSFER = 7;
	public static final int REQUEST_TOD = 8;
	public static final int REQUEST_ACCOUNTS = 9;
	public static final int REQUEST_RETAIL = 10;
	public static final int REQUEST_TRAIN = 11;
	public static final int REQUEST_VALIDATE = 12;
	public static final int REQUEST_VALIDATE_MENU = 13;
	public static final int REQUEST_APPS_MENU = 14;
	

	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_menu_top);
  
	    setTitle(" Main menu");
        AppContext bb  = (AppContext)getApplicationContext();
        bb.setHomeNLC("7031460");

	    
        LinearLayout cmdFaresMenu = (LinearLayout) findViewById(R.id.cmdFaresMenu);
        cmdFaresMenu.setOnClickListener(new OnClickListener() {  

          	public void onClick(View view) {  

            	Intent nextScreen = new Intent(getApplicationContext(), MenuFares.class);  
            	nextScreen.putExtra("nextAction", "");
            	startActivityForResult(nextScreen, REQUEST_FARE);
            	}  

        });    
 
        LinearLayout cmdTimeTable = (LinearLayout) findViewById(R.id.cmdTimeTable);
        cmdTimeTable.setOnClickListener(new OnClickListener() {  

       	public void onClick(View view) {  

	        	Intent nextScreen = new Intent(getApplicationContext(), TimeTableCriteria.class);                   
           	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_TIMETABLE);
       	}  

        });  
       
        LinearLayout cmdRetail = (LinearLayout) findViewById(R.id.cmdRetail);
        cmdRetail.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), RetailMain.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_RETAIL);

        	}  

        }); 

        LinearLayout cmdValidateMenu = (LinearLayout) findViewById(R.id.cmdValidateMenu);
        cmdValidateMenu.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), MenuValidate.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_VALIDATE_MENU);

        	}  

        }); 

        LinearLayout cmdBasket = (LinearLayout) findViewById(R.id.cmdBasket);
        cmdBasket.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_BASKET);

        	}  

        });    
        
        LinearLayout cmdAppMenu = (LinearLayout) findViewById(R.id.cmdAppMenu);
        cmdAppMenu.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), MenuApps.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_APPS_MENU);

        	}  

        });          

        LinearLayout cmdAccountsMenu = (LinearLayout) findViewById(R.id.cmdAccountsMenu);
        cmdAccountsMenu.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

	           	Intent nextScreen = new Intent(getApplicationContext(), MenuAccounts.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_ACCOUNTS);

        	}  

        }); 

        LinearLayout cmdSpare1 = (LinearLayout) findViewById(R.id.cmdSpare1);
        cmdSpare1.setVisibility(View.INVISIBLE);
        
 

        LinearLayout cmdAdminMenu = (LinearLayout) findViewById(R.id.cmdAdminMenu);
        cmdAdminMenu.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		
        		Intent nextScreen = new Intent(getApplicationContext(), MenuAdmin.class);  
        		nextScreen.putExtra("nextAction", "");
            	startActivityForResult(nextScreen, 99);

        	}  

        }); 
        
        LinearLayout cmdDeviceSupport = (LinearLayout) findViewById(R.id.cmdDeviceSupport);
        cmdDeviceSupport.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
/*
	        	Intent nextScreen = new Intent(getApplicationContext(), DeviceSupport.class);                   
	        	startActivityForResult(nextScreen, REQUEST_DEVICES);
*/
        	}  

        });         
 
        LinearLayout cmdSpare2 = (LinearLayout) findViewById(R.id.cmdSpare2);
        cmdSpare2.setVisibility(View.INVISIBLE);
      

        LinearLayout cmdLogOff = (LinearLayout) findViewById(R.id.cmdLogOff);
        cmdLogOff.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

            	// Todo call LOGOFF code
            	 Intent returnIntent = new Intent();
            	 returnIntent.putExtra("nextAction", "");
              	 setResult(RESULT_OK,returnIntent);
              	 finish();           	


        	}  

        }); 
        

        
        refreshData();
        
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync){
			Toast.makeText(MenuTop.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(MenuTop.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
	}

    @Override
    public Intent getParentActivityIntent() {

    	Intent newIntent = new Intent(getApplicationContext(), Logon.class); 
    	// Todo call LOGOFF code

          
          return newIntent;
          
     }

    private void refreshData(){
        
        AppContext bb  = (AppContext)getApplicationContext();
        bb.checkStatus();
                

        // TODO method on all that can change state
        
        TextView txtBasket = (TextView) findViewById(R.id.txtBasket);
        ImageView imgBasket = (ImageView) findViewById(R.id.imgBasket);     
        imgBasket.getBackground().setLevel(bb.basket.buttonStatus);
        txtBasket.setText(bb.basket.buttonTitle);        
 	
        TextView txtAdminMenu = (TextView) findViewById(R.id.txtAdminMenu);
        ImageView imgAdminMenu = (ImageView) findViewById(R.id.imgAdminMenu);     
        imgAdminMenu.getBackground().setLevel( bb.menuAdminStatus);
        txtAdminMenu.setText(bb.menuAdminTitle); 
        

    }
    
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		// This code controls the follow on activity after a selected activity
		switch(requestCode) {
       		case REQUEST_TIPS_ACTIVITY:
       			break;

       		case REQUEST_RETAIL:
       			// Drop through
        	case REQUEST_FARE:
        		 if(resultCode == RESULT_OK){
        			 // Get next action (if set)
        			 String nextAction = data.getStringExtra("nextAction");
        			 
        			 if(nextAction.equals("basket")){
        		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
        	            	nextScreen.putExtra("nextAction", "");
        		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("card")){
	     		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
	     	            	nextScreen.putExtra("nextAction", nextAction);
	     		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("cash")){
		 		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
		 	            	nextScreen.putExtra("nextAction", nextAction);
		 		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 }
        		 }
        		 
     	        if (resultCode == RESULT_CANCELED) {
    	            //Write your code if there's no result
    	        }
        		break;
        	case REQUEST_TIMETABLE:
        		break;
        	case REQUEST_BASKET:
        		break;
        	case REQUEST_DUTY:
        		break;
        	case REQUEST_DEVICES:
        		break;
		}
		refreshData();

	}
	
    

}
