package com.example.twolibs.MenuGUI;


import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresGUI.FaresLookup;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.R.menu;
import com.example.twolibs.PassCntGUI.PassCntCapture;
import com.example.twolibs.SaleGUI.BasketList;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class MenuValidate extends Activity {

    public static final int REQUEST_TIPS_ACTIVITY = 1;

    public static final int REQUEST_FARE = 2;
	public static final int REQUEST_TIMETABLE = 3;
	public static final int REQUEST_BASKET = 4;
	public static final int REQUEST_DUTY = 5;
	public static final int REQUEST_DEVICES = 6;
	public static final int REQUEST_DATA_TRANSFER = 7;
	public static final int REQUEST_TOD = 8;
	public static final int REQUEST_ACCOUNTS = 9;
	public static final int REQUEST_RETAIL = 10;
	public static final int REQUEST_TRAIN = 11;
	public static final int REQUEST_VALIDATE = 12;
	public static final int REQUEST_PASS_COUNT = 13;

	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_menu_validate);
  
	    setTitle(" Check tickets menu");
        AppContext bb  = (AppContext)getApplicationContext();
	    
        LinearLayout cmdCheckITSO = (LinearLayout) findViewById(R.id.cmdCheckITSO);
        cmdCheckITSO.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		
                PackageManager pm = getPackageManager();
                Intent intent = pm.getLaunchIntentForPackage("com.ecebs.cardviewer");
                startActivity(intent);

        	}  

        }); 
 
        LinearLayout cmdSpare1 = (LinearLayout) findViewById(R.id.cmdSpare1);
        cmdSpare1.setVisibility(View.INVISIBLE);

        LinearLayout cmdBarCode = (LinearLayout) findViewById(R.id.cmdBarCode);
        cmdBarCode.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
               	Toast.makeText(MenuValidate.this, "Bar code sccan not implemented", Toast.LENGTH_SHORT).show();
        		 
        	}  

        }); 
        
        LinearLayout cmdSpare2 = (LinearLayout) findViewById(R.id.cmdSpare2);
        cmdSpare2.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdPassengerCount = (LinearLayout) findViewById(R.id.cmdPassengerCount);
        cmdPassengerCount.setOnClickListener(new OnClickListener() {  

       	public void onClick(View view) {  
			Intent nextScreen = new Intent(getApplicationContext(), PassCntCapture.class);                   
	        startActivityForResult(nextScreen, REQUEST_PASS_COUNT);

       	}  

        });  
              
        LinearLayout cmdSpare3 = (LinearLayout) findViewById(R.id.cmdSpare3);
        cmdSpare3.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare4 = (LinearLayout) findViewById(R.id.cmdSpare4);
        cmdSpare4.setVisibility(View.INVISIBLE);
 
        LinearLayout cmdSpare5 = (LinearLayout) findViewById(R.id.cmdSpare5);
        cmdSpare5.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare6 = (LinearLayout) findViewById(R.id.cmdSpare6);
        cmdSpare6.setVisibility(View.INVISIBLE);
        
        LinearLayout cmdSpare7 = (LinearLayout) findViewById(R.id.cmdSpare7);
        cmdSpare7.setVisibility(View.INVISIBLE);

        LinearLayout cmdSpare8 = (LinearLayout) findViewById(R.id.cmdSpare8);
        cmdSpare8.setVisibility(View.INVISIBLE);

        LinearLayout cmdHome = (LinearLayout) findViewById(R.id.cmdHome);
        cmdHome.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

            	 Intent returnIntent = new Intent();
            	 returnIntent.putExtra("nextAction", "");
              	 setResult(RESULT_OK,returnIntent);
              	 finish();           	

        	}  

        }); 
        

        
        refreshData();
        
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync ) {
			Toast.makeText(MenuValidate.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(MenuValidate.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

    @Override
    public Intent getParentActivityIntent() {

       	Intent newIntent = new Intent(getApplicationContext(), MenuTop.class); 
        return newIntent;
          
     }

    private void refreshData(){
        AppContext bb  = (AppContext)getApplicationContext();

        // In this menu the only change below the menu would be basket
        
        // TODO add device check
        
        TextView txtBasket = (TextView) findViewById(R.id.txtHome);
        ImageView imgBasket = (ImageView) findViewById(R.id.imgHome);     
        imgBasket.getBackground().setLevel(bb.menuStatus);
        txtBasket.setText(bb.menuTitle);        

    }
    
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		// This code controls the follow on activity after a selected activity
		switch(requestCode) {
       		case REQUEST_TIPS_ACTIVITY:
       			break;

        	case REQUEST_FARE:
        		 if(resultCode == RESULT_OK){
        			 // Get next action (if set)
        			 String nextAction = data.getStringExtra("nextAction");
        			 
        			 if(nextAction.equals("basket")){
        		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
        	            	nextScreen.putExtra("nextAction", "");
        		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("card")){
	     		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
	     	            	nextScreen.putExtra("nextAction", nextAction);
	     		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 } else if(nextAction.equals("cash")){
		 		           	Intent nextScreen = new Intent(getApplicationContext(), BasketList.class);                   
		 	            	nextScreen.putExtra("nextAction", nextAction);
		 		        	startActivityForResult(nextScreen, REQUEST_BASKET);
        			 }
        		 }
        		 
     	        if (resultCode == RESULT_CANCELED) {
    	            //Write your code if there's no result
    	        }
        		break;
        	case REQUEST_TIMETABLE:
        		break;
        	case REQUEST_BASKET:
        		break;
        	case REQUEST_DUTY:
        		break;
        	case REQUEST_DEVICES:
        		break;
		}
		refreshData();

	}
	
    

}
