
package com.example.twolibs.PassCntGUI;


import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.view.View;
import android.view.View.OnClickListener;


public class PassCntCapture extends Activity {
	//
	// PassCntCapture class is a GUI class to support the capturing of duties
	// It allows the counts of passengers on a train to be entered 
	//	
	private static String CLASS_NAME = "PassCntCapture";    // Used for tracing

	// The CallContext is part of the data when calling other intents 
	// It enables the context to be determined when the call returns in onActivityResult
	// It should list all the called intents
	public enum CallContext {
		SELECT_LOCATION,	// TODO
		SELECT_TRAIN;		// TODO
	}

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(savedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_pass_count);
        
        // Set the title of this screen
		setTitle(" Passenger count");

        // The BlackBoard is the base class, used to reference other managers
    	final AppContext bb  = (AppContext)getApplicationContext();
    	
 
        // Default to current Date time

	    EditText txtDate = (EditText)findViewById(R.id.txtDate);
	    txtDate.setText(DataConvert.displayTextTime(DataConvert.getNow()));

	    EditText txtTrainId = (EditText)findViewById(R.id.txtTrainId);
	    if(DutyManager.activeTask != null){
	    	DutyTaskType dutyTaskType = DutyTaskType.getTaskType(DutyManager.activeTask.taskType);
	    	if(dutyTaskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN){
	    		txtTrainId.setText(DutyManager.activeTask.trainRetailId);
	    	}
	    }
	    txtDate.setText(DataConvert.displayTextTime(DataConvert.getNow()));

	    // Done - return to menu
		Button cmdDone = (Button) findViewById(R.id.cmdDone); 
		cmdDone.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdDone", 0);
		
              	Intent returnIntent = new Intent();
                setResult(RESULT_OK,returnIntent);
               	finish();           	
			}  
			
		
		});
		
		// Final checks on the screen 
        doCheckComplete();

    }
 
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		final String FUNC_NAME = "onActivityResult"; 	
		
		//
		// This routine handles the return from called intents
		//


		// Final checks on the screen 	    
	    doCheckComplete();		    

	}
	
	
	
	
    void doCheckComplete(){
		final String FUNC_NAME = "doCheckComplete"; 			
		//
		// This routine handles the return from called intents
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);
		

        
    }


    @Override
    public Intent getParentActivityIntent() {
		final String FUNC_NAME = "getParentActivityIntent"; 			
		//
		// This routine handles a back request
		// 
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);

    	Intent newIntent = null;
    	newIntent = new Intent(getApplicationContext(), MenuTop.class); 
          
        return newIntent;
          
     }
    


}