package com.example.twolibs.RetailBL;

import java.util.ArrayList;

import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class RetailHelper {
	private static String CLASS_NAME = "RetailHelper";    // Used for tracing
	
	private static ArrayList<RetailItemSupport> baseList = new ArrayList<RetailItemSupport>();
	
	public static  ArrayList<RetailItemSupport> doGetHierarchy(){
		//
		// Returns a filtered list of matching retail items.
		// Match is either
		//	ID starts with the string
		// or
		//  Duty name contains the string
		//
		final String FUNC_NAME = "doGetHierarchy"; 	   	
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	
		ArrayList<RetailItemSupport> myList = new ArrayList<RetailItemSupport>();
		
		RetailItemSupport s1 = new RetailItemSupport();
		s1.node = new RetailItemHierarchy();
		s1.node.Description = "Snacks";
		myList.add(s1);

		RetailItemSupport ss1 = new RetailItemSupport();
		ss1.entryType = 1;
		ss1.leaf = new RetailItem();
		ss1.leaf.Description = "Crisps";
		ss1.leaf.PLU = "000123421";
		ss1.leaf.Price = 205;
		myList.add(ss1);

		RetailItemSupport ss2 = new RetailItemSupport();
		ss2.entryType = 1;
		ss2.leaf = new RetailItem();
		ss2.leaf.Description = "Nuts";
		ss2.leaf.PLU = "0003235332";
		ss2.leaf.Price = 155;
		myList.add(ss2);
		
		

		RetailItemSupport s2 = new RetailItemSupport();
		s2.node = new RetailItemHierarchy();
		s2.node.Description = "Drinks";
		myList.add(s2);

		 ss1 = new RetailItemSupport();
		ss1.entryType = 1;
		ss1.leaf = new RetailItem();
		ss1.leaf.Description = "Tea";
		ss1.leaf.PLU = "0001234788";
		ss1.leaf.Price = 150;
		myList.add(ss1);

		 ss2 = new RetailItemSupport();
		ss2.entryType = 1;
		ss2.leaf = new RetailItem();
		ss2.leaf.Description = "Coffee";
		ss2.leaf.PLU = "0001234567";
		ss2.leaf.Price = 190;
		myList.add(ss2);

		baseList = myList;
        return (ArrayList<RetailItemSupport>)myList.clone();
    	
    }

	public static  ArrayList<RetailItemSupport> doSearchItems(String pSearch){
		//
		// Returns a filtered list of matching retail items.
		// Match is either
		//	ID starts with the string
		// or
		//  Duty name contains the string
		//
		final String FUNC_NAME = "doSearchDuty"; 	   	
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, pSearch, 0);
    	
		ArrayList<RetailItemSupport> myList = new ArrayList<RetailItemSupport>();

		for(RetailItemSupport item : baseList ){
			if(item.entryType == 0){
				myList.add(item);				
			} else {
				if((item.leaf.PLU.startsWith(pSearch)) || (item.leaf.Description.startsWith(pSearch))){
					myList.add(item);				
			
				}
			}
		}

 
        
        return myList;
    	
    }

}
