package com.example.twolibs.RetailBL;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.os.Environment;

public class RetailManager extends GenericManager{
	private static String CLASS_NAME = "DataTransferManager";  // Used for tracing
	
	// The DataTransferManager provides a mechanism for bind files to physical environment
	
	// Refresh flag - if set will force a refresh when required.
	private static boolean refreshRequired = true;
		
	
	// Filter on download events
	public static String DATADOWNLOADSERVICE = "DATADOWNLOADSERVICE";
	public static String DATAGROUPUPDATED = "DATAGROUPUPDATED";
	
	// TODO integrate DataUpload mechanisms.

	public enum FileType {
		CCSTFORMATS,					
		DUTIES,					
		DUTYTASKTYPES,
		DATADOWNLOADSTATE,
		TRACELOG
	}
		
	
	public static DomainStatusResponse checkStatus(){
		final String FUNC_NAME = "checkStatus"; 	  
		//
		// Overrides GenericManager
    	// 
    	// Find out whether there is a due duty
    	// If so we need to flag action is required and setup a title
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		DomainStatusResponse resp = new DomainStatusResponse();

		resp.status = MenuState.NORMAL;
		resp.shortDescrition = "Sync\nData";

		// TODO error if nothing read

    	
   
       return resp;
	}	
	public static void handleEvent(String pSource, String pEventType, String pData){
		final String FUNC_NAME = "handleEvent"; 	  
		//
		// Overrides GenericManager
    	// 
		//
		// Method is called whenever a application wide event occurs
		// 
		// Whatever the DataGroup we need to update the file paths
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		if(pSource.equals(DATADOWNLOADSERVICE) && pSource.equals(DATAGROUPUPDATED) ){
			// handle the updates
			refreshRequired = true;
			
			// Immediate update as all the filenames need to be checked
			
			refreshdata();
		}
	}

	
	public static void refreshdata(){
		final String FUNC_NAME = "refreshdata"; 	   	
    	// 
    	// Resets all the data associated with the DataTransfer subsystem
    	// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		if(refreshRequired){
			
			// Load all the products
		
			
			refreshRequired = false;
			
		} 
	
		return ;
	}
	
	
	public static ArrayList<RetailItemSupport> doSearchItems(String pSearch){
		final String FUNC_NAME = "getTransfers"; 
	   	
    	// 
    	// Return an arraylist containing the dataGroup transfers 
    	// for display
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		
		return RetailHelper.doSearchItems(pSearch);
		
	}
	
	
}
