package com.example.twolibs.RetailGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.RetailBL.RetailItemHierarchy;
import com.example.twolibs.RetailBL.RetailItemSupport;
import com.example.twolibs.SaleBL.BasketComment;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SaleBL.BasketSupport.ItemType;
import com.example.twolibs.SaleBL.Tender.TenderType;
import com.example.twolibs.SupportBL.DataConvert;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

public class RetailListAdaptor extends ArrayAdapter<RetailItemSupport> {
	private final Activity context;
	private final ArrayList<RetailItemSupport> retailItemSupport;
	
	
	static class ViewHolder {
		public LinearLayout lay_entry;
	}
		
	public RetailListAdaptor(Activity context, ArrayList<RetailItemSupport> pRetailItemSupport) {
		super(context, R.layout.basket_entry, pRetailItemSupport);
		this.context = context;
		this.retailItemSupport = pRetailItemSupport;
	}

	


	  private void displayRetailItem(ViewHolder holder, LayoutInflater inflater, View rowView, RetailItemSupport rs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.retailitem_entry, null));

		TextView txtDomain = (TextView) rowView.findViewById(R.id.txtDomain);
		TextView txtComment = (TextView) rowView.findViewById(R.id.txtComment);
		TextView txtDirection = (TextView) rowView.findViewById(R.id.txtDirection);
		TextView txtTime = (TextView) rowView.findViewById(R.id.txtTime);
		

		txtDomain.setPadding(0, 0, 0, 0);
		txtDomain.setText(rs.leaf.Description);
		txtComment.setPadding(80, 0, 0, 0);
		txtComment.setText(rs.leaf.PLU);
		txtDirection.setText("");
		txtTime.setText("£" + DataConvert.doubleToDisplayFormat(rs.leaf.Price));
  	
	  }
	  
	  private void displayHierachy(ViewHolder holder, LayoutInflater inflater, View rowView, RetailItemSupport rs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.basket_comment_entry, null));
  	
		TextView txtComment = (TextView) rowView.findViewById(R.id.txtComment);
		TextView txtAmount = (TextView) rowView.findViewById(R.id.txtAmount);
   
		txtComment.setText(rs.node.Description);

		txtAmount.setText("");
		
	  }

	  
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View rowView = convertView;
	    LayoutInflater inflater = context.getLayoutInflater();



	    // reuse views
	    if (rowView == null) {
		   //   rowView = inflater.inflate(R.layout.datatransfer_entry, null);
	      rowView = inflater.inflate(R.layout.basket_entry, null);
	      // configure view holder
	      ViewHolder viewHolder = new ViewHolder();

	      viewHolder.lay_entry = (LinearLayout) rowView.findViewById(R.id.lay_entry);

	      rowView.setTag(viewHolder);
	    }	    
	    // reuse views

	    
		// fill data
		ViewHolder holder = (ViewHolder) rowView.getTag();


		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	    RetailItemSupport rs = retailItemSupport.get(position);
	    
		holder.lay_entry.removeAllViews();
	    if(rs.entryType == 0){
	    	displayHierachy(holder,inflater,rowView,rs);

		} else {
	    	displayRetailItem(holder,inflater,rowView,rs);


		}
	    
		return rowView;
	}
	
}
