
package com.example.twolibs.RetailGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DutyBL.Duty;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresGUI.FaresLookup;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.RetailBL.RetailHelper;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.RetailBL.RetailItemHierarchy;
import com.example.twolibs.RetailBL.RetailItemSupport;
import com.example.twolibs.RetailBL.RetailManager;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SaleGUI.TenderTypes;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.ActionBar;
import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;


public class RetailMain extends ListActivity {
	//
	// RetailMain class is a GUI class to support the picking and changing of retail items
	// It displays the mechandise heirarchy and a filtered list of products
	//	
	private static String CLASS_NAME = "RetailMain";    // Used for tracing
	
	ArrayList<RetailItemSupport> list = new ArrayList<RetailItemSupport>(); // The list that is being displayed
	int iCurrentSelection = -1;							  // The current selected task, -1 is none.
	// Support for menu switching
	int iCurrentMenu = -1;
	
	RetailListAdaptor adapter;						  // Adapter to handle the list
	ListView listview;									  // The view for the list

	// The CallContext is part of the data when calling other intents 
	// It enables the context to be determined when the call returns in onActivityResult
	// It should list all the called intents
	public enum CallContext {
		DISPLAY;		
	}


	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}

	@Override
    public void onCreate(Bundle pSavedInstanceState)
    {
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(pSavedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_retail_main);
        
        // The action bar is suppressed and replaced with a bar
        // that allows text to be input to filter the products offered
        
        ActionBar actionBar = getActionBar(); 
        actionBar.hide();

    	final AppContext bb  = (AppContext)getApplicationContext();

        // Ensure that the associated manager is initialised
		RetailManager.refreshdata();
        	        	        
		// Setup the adapter
        listview = (ListView) findViewById(android.R.id.list);
		list = RetailHelper.doGetHierarchy(); // base list
        adapter = new RetailListAdaptor(this,list);
        setListAdapter(adapter);

        setMenu(0);
        
//TODO stem search
			
			
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
				final String FUNC_NAME = "onItemClick"; 	
				
				//
				// This routine handles the emphasis of the selected item
				// and initiates any business activity
				//
				
				// Note: No specific actions for this list has been identified
				
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "listview " + position, 0);
           	

                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	View rowView = (View) parent.getChildAt(j);
                	rowView.setBackgroundColor(Color.TRANSPARENT);
                }
                

                if (position == iCurrentSelection){
                    setMenu(0);                   	
                    
                    // Null the selected journey
                    bb.selRetail =  null;
                    iCurrentSelection = -1;
                    list.get(position).itemSelected = 0;

            	} else {
            		
                    setMenu(1);                   	

                    // Record the selected journey
                    bb.selRetail =  list.get(position).leaf;
                    iCurrentSelection = position;

	                // change the background colour of the selected element
                    list.get(position).itemSelected = 1;
                    // Keep this code in sync with adaptor
	                view.setBackgroundColor(JMgetColor(R.color.selection_background, getTheme()));

            	}
            }

          });
	    // Basket - return to menu with next action as basket
		Button cmdBasket = (Button) findViewById(R.id.cmdBasket); 
		cmdBasket.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdDone", 0);
						
              	Intent returnIntent = new Intent();
                returnIntent.putExtra("nextAction","basket");
                setResult(RESULT_OK,returnIntent);
               	finish();           	
			}  
			
		
		});

/*	    // Done - return to menu
		Button cmdDone = (Button) findViewById(R.id.cmdDone); 
		cmdDone.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdDone", 0);
		
              	Intent returnIntent = new Intent();
                returnIntent.putExtra("nextAction","");
                setResult(RESULT_OK,returnIntent);
               	finish();           	
			}  
			
		
		});
*/
		
        doCheckComplete();
	    EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
	    txtSearch.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
				final String FUNC_NAME = "afterTextChanged"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "txtSearch " + s, 0);
	        	
				doSearch();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 

		
	    // Force the keyboard to be displayed for selection
	    txtSearch.requestFocus();  	            

    }
	    
    public void doSearch(){
		final String FUNC_NAME = "doSearch"; 	   			
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	//
		//	Routine to call the search to filer the task types based on the input string
    	//
		
		// Get the search string
     	EditText et = (EditText) findViewById(R.id.txtSearch);
        String search = DataConvert.toUpperCase(et.getText().toString());
 	         
        // Call the manager to do the search
        ArrayList<RetailItemSupport> listCopy= RetailManager.doSearchItems(search);
        
    	// Reset the display list now that the contents may have changed 
	    adapter.clear();
	    adapter.addAll(listCopy);
	    adapter.notifyDataSetChanged();
		
	}
    
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

	    doCheckComplete();

	}
	
    
    void doCheckComplete(){
		final String FUNC_NAME = "doCheckComplete"; 			
		//
		// This routine handles the return from called intents
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);
		
       	// TODO get products
		
  //  	ArrayList<DataTransferGroup> transfers = DataTransferManager.getTransfers();
	
 //       adapter.clear();
 //       adapter.addAll(transfers);
        adapter.notifyDataSetChanged();
        
    }

    private void setMenu(int iMenu){
    	if (iMenu == iCurrentMenu){
    		// No change required
    	} else {
    		// Delete the current
            LinearLayout layFormMenu = (LinearLayout)findViewById(R.id.layFormMenu);  
            layFormMenu.removeAllViews();               
             // Create new LayoutInflater - this has to be done this way, as you can't directly inflate an XML without creating an inflater object first             

             LayoutInflater inflater = getLayoutInflater();   
             if (iMenu == 0) {
                 layFormMenu.addView(inflater.inflate(R.layout.retailitem_main_menu0, null));
 
                 
                 // setup callbacks
                 Button cmdEarlier = (Button) findViewById(R.id.cmdBasket);
                 cmdEarlier.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  
        				final String FUNC_NAME = "onClick"; 	   			
        				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
        						Category.GUI, "cmdDone", 0);
        						
                      	Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction","basket");
                        setResult(RESULT_OK,returnIntent);
                       	finish();           	

                 	} 
                 });
                 

                 Button cmdScan = (Button) findViewById(R.id.cmdScan);
                 cmdScan.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 		Toast.makeText(RetailMain.this, "Scan  Clicked", Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                 
                 Button cmdDone = (Button) findViewById(R.id.cmdDone);
                 cmdDone.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

	                  	Intent returnIntent = new Intent();	                  	
	                    returnIntent.putExtra("nextAction","");
	                 	setResult(RESULT_OK, returnIntent);
	                 	finish();
                 	 
                 	}
                 });
                 
             } else {
                 layFormMenu.addView(inflater.inflate(R.layout.retailitem_main_menu1, null));

                 // setup callbacks
                 Button cmdEarlier = (Button) findViewById(R.id.cmdBasket);
                 cmdEarlier.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 		AppContext bb  = (AppContext)getApplicationContext();
                 		Basket bs = bb.basket;
                 		if (bb.selRetail != null){
	                 		RetailItem tt = bb.selRetail;
	                 		bs.addRetailItem(tt, tt.Price);
                 		}
                 		Toast.makeText(RetailMain.this, "Basket  items: " + bs.basketProducts.size(), Toast.LENGTH_SHORT).show();  
  
	                  	Intent returnIntent = new Intent();            	
	                    returnIntent.putExtra("nextAction","");	
	                 	setResult(RESULT_OK,returnIntent);         			  
	                 	finish();
                 	} 
                 });
                 

                 Button cmdLater = (Button) findViewById(R.id.cmdCard);
                 cmdLater.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 		AppContext bb  = (AppContext)getApplicationContext();
                 		Basket bs = bb.basket;
                 		if (bb.selRetail != null){
	                 		RetailItem tt = bb.selRetail;
	                 		bs.addRetailItem(tt, tt.Price);
                 		}
                 		Toast.makeText(RetailMain.this, "Card  Clicked - Basket  items: " + bs.basketProducts.size(), Toast.LENGTH_SHORT).show();  
	 
	                  	Intent returnIntent = new Intent();               	
	                    returnIntent.putExtra("nextAction","card");
	                 	setResult(RESULT_OK,returnIntent);         			  
	                 	finish();
                 	} 
                 });
                 
                 Button cmdCash = (Button) findViewById(R.id.cmdCash);
                 cmdCash.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  
                 		
                 		AppContext bb  = (AppContext)getApplicationContext();
                 		Basket bs = bb.basket;
                 		if (bb.selRetail != null){
	                 		RetailItem tt = bb.selRetail;
	                 		bs.addRetailItem(tt, tt.Price);
                 		}
                 		Toast.makeText(RetailMain.this, "Cash  Clicked - Basket  items: " + bs.basketProducts.size(), Toast.LENGTH_SHORT).show();  
	                            			  
	                  	Intent returnIntent = new Intent();
	                    returnIntent.putExtra("nextAction","cash");
	                 	setResult(RESULT_OK,returnIntent);	         			  
	                 	finish();                 	 
                 	}
                 });

           }  		
    		
    		// Setup the new
    		iCurrentMenu = iMenu;
    	}
    	
    }

    @Override
    public Intent getParentActivityIntent() {

    	Intent newIntent = null;
    	// ToDo 
    	newIntent = new Intent(getApplicationContext(), MenuTop.class); 
          
        return newIntent;
          
     }
    


}