package com.example.twolibs.SaleBL;

import java.util.ArrayList;
import java.util.Date;

import android.util.Log;

import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.SaleBL.BasketSupport.ItemType;
import com.example.twolibs.SessionBL.SDCIData;
import com.example.twolibs.SupportBL.DataConvert;

public class Basket {
	
	//
	// This class supports the basic basket functions
	//
	private String TAG = "Basket";
	
	public ArrayList<BasketSupport> basketContents = new ArrayList<BasketSupport>();
	public ArrayList<BasketSupport> basketProducts = new ArrayList<BasketSupport>();
	public ArrayList<BasketSupport> basketTenders = new ArrayList<BasketSupport>();

	public ArrayList<SDCIData> sdciRecords = new ArrayList<SDCIData>();
	public ArrayList<CCSTCoupon> ccstCoupons = new ArrayList<CCSTCoupon>();

	public int numberOfItems = 0;
	public int amountDue = 0;
	public int tendersPaid = 0;
	public int balanceDue = 0;
	
	public int buttonStatus = 1;
	public String buttonTitle = "Basket";
	
	public int checkStatus(){
		// Supports the status setting in the menu structure
		
        int items = basketProducts.size();
        if(items == 0){
        	buttonTitle = "Basket\n(empty)";
        	buttonStatus = 1; //OK
        	
        } else if(items == 1){
        	buttonTitle = "Basket\n(1 item)";
        	buttonStatus = 2; //Yellow
        	
        } else{
        	buttonTitle = "Basket\n(" + items + " items)";
        	buttonStatus = 2; //Yellow
       }
        
       return buttonStatus;
	}
	
	public void addTicket(TNFare item, double itemValue){
		BasketSupport bs = new BasketSupport();
		bs.itemType = ItemType.FARE;
		bs.itemValue = itemValue;
		bs.ticket = item;
		basketProducts.add(bs);
	}
	
	public void addRetailItem (RetailItem item, double itemValue){
		BasketSupport bs = new BasketSupport();
		bs.itemType = ItemType.RETAIL_ITEM;
		bs.itemValue = itemValue;
		bs.retail = item;
		basketProducts.add(bs);
	}
	
	public void addTender(Tender item, double itemValue){
		BasketSupport bs = new BasketSupport();
		bs.itemType = ItemType.TENDER;
		bs.itemValue = itemValue;
		bs.tender = item;
		basketTenders.add(bs);
	}

	public void addComment(BasketComment item, double itemValue){
		BasketSupport bs = new BasketSupport();
		bs.itemType = ItemType.COMMENT;
		bs.itemValue = itemValue;
		bs.comment = item;
		basketContents.add(bs);
		checkStatus();
	}

	
	public void refreshBasket(AppContext bb){
		basketContents = new ArrayList<BasketSupport>();
		amountDue = 0;
		tendersPaid = 0;
		
		// Total the contents
		for(BasketSupport bs: basketProducts){
			amountDue += bs.itemValue;
			// Copy the products to appear before the total
			basketContents.add(bs);

		}
		
		BasketComment subTotalLine = new BasketComment();
		subTotalLine.CommentText = "Total ";
		subTotalLine.CommentValue = amountDue;
		addComment(subTotalLine, amountDue);
		
		if (basketTenders.size() > 0 ){
			subTotalLine.CommentText = "Total ";
		} else {
			subTotalLine.CommentText = "Balance due ";
		}
		
		for(BasketSupport bs: basketTenders){
			tendersPaid += bs.itemValue;
			// Copy the tenders
			basketContents.add(bs);
		}

		balanceDue = amountDue - tendersPaid;
		
		if (basketTenders.size() > 0 ){
			BasketComment balanceDueLine = new BasketComment();
			balanceDueLine.CommentText = "Balance due ";
			balanceDueLine.CommentValue = balanceDue;
			addComment(balanceDueLine, amountDue);
		}
		
		// TODO check response
		FulfilmentManager.STDCreateCouponsResponse resp = FulfilmentManager.createFulfilmentCoupons(bb,this);
		sdciRecords = resp.sdciRecords;
		ccstCoupons = resp.ccstCoupons;
		
		checkStatus();
		
	}
}
