package com.example.twolibs.SaleGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.FulfilmentGUI.CCSTPrinting;
import com.example.twolibs.SaleBL.BasketSupport;

import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.Toast;

public class BasketList extends ListActivity  {

	// Support for menu switching
	int iCurrentMenu = -1;
	int iCurrentSelection = -1;

	public static final int REQUEST_CARD = 1;
	public static final int REQUEST_CASH = 2;
	public static final int REQUEST_PRINT = 3;

	ArrayList<BasketSupport> itemList = new ArrayList<BasketSupport>();
	BasketListAdaptor adapter;
		
	ListView listview;

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}


    /** Called when the activity is first created. */
	
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_basket);

		setTitle(" Basket");

        // here, we dynamically load the library at runtime
        // before calling the native method.
        //
        
        listview = (ListView) findViewById(android.R.id.list);
    	final AppContext bb  = (AppContext)getApplicationContext();
    	bb.basket.refreshBasket(bb);
    	itemList = bb.basket.basketContents;
    	

        adapter = new BasketListAdaptor(this,itemList,bb);
        setListAdapter(adapter);

 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
            	
                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	parent.getChildAt(j).setBackgroundColor(Color.TRANSPARENT);
                }

                if (position == iCurrentSelection){
                    setMenu(0);
                    
                    // Null the selected journey
                    bb.selFare =  null;
                    iCurrentSelection = -1;

            	} else {
            		
                    setMenu(1);
 
                    // Record the selected item
                    // TODO bb.selItem =  itemList.get(position);
                    iCurrentSelection = position;

	                // change the background color of the selected element
	                view.setBackgroundColor(JMgetColor(R.color.selection_background, getTheme()));
           		
                }
            }

          });
        

        setMenu(0);

        Intent intent = getIntent();
        if(intent != null){
        	// (if it was null then somebody hit cancel to get here so we don't need to look further)
	        String nextAction = intent.getStringExtra("nextAction");
	        if(nextAction != null){
		        if(nextAction.equals("cash")) {
		        	// Go straight to a cash payment
		           	Intent nextScreen = new Intent(getApplicationContext(), TenderCash.class);                   
		        	nextScreen.putExtra("nextAction", "");
		        	startActivityForResult(nextScreen, REQUEST_CARD); 
		        } else if(nextAction.equals("card")) {
		        	// Go straight to a cash payment
		 //          	Intent nextScreen = new Intent(getApplicationContext(), TenderCard.class);
		   //     	nextScreen.putExtra("nextAction", "");
		     //   	startActivityForResult(nextScreen, REQUEST_CASH);
		        }
	        }              			  
        }
        
    }
 
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync) {
			Toast.makeText(BasketList.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(BasketList.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
    }

    @Override
    public Intent getParentActivityIntent() {

    	Intent newIntent = new Intent(getApplicationContext(), FaresCriteria.class); 

         /* 
           Intent parentIntent= getIntent();
         //getting the parent class name
          String className = parentIntent.getStringExtra("ParentClassName");

          Intent newIntent=null;
          

          try {
               //you need to define the class with package name
               newIntent = new Intent(TopMenu.this,Class.forName("com.example.TwoLibs."+className));
               
               
         } catch (ClassNotFoundException e) {
               e.printStackTrace();
          }
          
          */
          return newIntent;
          
     }
    private void setMenu(int iMenu){
    	if (iMenu == iCurrentMenu){
    		// No change required
    	} else {
    		// Delete the current
            LinearLayout layFormMenu = (LinearLayout)findViewById(R.id.layFormMenu);  
            layFormMenu.removeAllViews();               
             // Create new LayoutInflater - this has to be done this way, as you can't directly inflate an XML without creating an inflater object first             

             LayoutInflater inflater = getLayoutInflater();   
             if (iMenu == 0) {
                 layFormMenu.addView(inflater.inflate(R.layout.basket_menu0, null));
 
                 // setup callbacks
                 Button cmdPay = (Button) findViewById(R.id.cmdPay);
                 cmdPay.setOnClickListener(new OnClickListener() {  

                  	public void onClick(View view) {  
                 		
                        Intent nextScreen = new Intent(getApplicationContext(), TenderTypes.class);                   
                    	nextScreen.putExtra("nextAction", "");
                    	startActivityForResult(nextScreen, 1);                            			  
                     	
                     	 
                     	}
                 });  
                 
                 Button cmdClear = (Button) findViewById(R.id.cmdClear);
                 cmdClear.setOnClickListener(new OnClickListener() {  

                  	public void onClick(View view) {  
                 		
                 		//TODO put in printing
                 		
                 		//Clear basket for demo only
                 		AppContext bb  = (AppContext)getApplicationContext();
                 		bb.basket.basketContents.clear();
                 		bb.basket.basketProducts.clear();
                 		bb.basket.basketTenders.clear();
                 		bb.basket.refreshBasket(bb);
                 		
	                  	Intent returnIntent = new Intent();
	                    returnIntent.putExtra("nextAction","");
	                 	setResult(RESULT_OK,returnIntent);	  
	                 	finish();                     	
                     	 
                     	}
                 });   
                 
                 Button cmdDone = (Button) findViewById(R.id.cmdDone);
                 cmdDone.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 		//TODO put in printing
                 		                 		
	                  	Intent returnIntent = new Intent();
	                    returnIntent.putExtra("nextAction","");
	                 	setResult(RESULT_OK,returnIntent);	  
	                 	finish();
                 	 
                 	}
                 });
                 
             } else {
                 layFormMenu.addView(inflater.inflate(R.layout.basket_menu1, null));

                 // setup callbacks
                 /*
                 Button cmdEarlier = (Button) findViewById(R.id.cmdBasket);
                 cmdEarlier.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 		BlackBoard bb  = (BlackBoard)getApplicationContext();
                 		Basket bs = bb.basket;
                 		if (bb.selFare != null){
	                 		TNFare tt = bb.selFare;
	                 		bs.addTicket(tt);
                 		}
                 		Toast.makeText(BasketList.this, "Basket  items: " + bs.basketContents.size(), Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                 

                 Button cmdLater = (Button) findViewById(R.id.cmdCard);
                 cmdLater.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 	Toast.makeText(BasketList.this, "Card  Clicked", Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                  */ 
                 /*
                 Button cmdCash = (Button) findViewById(R.id.cmdCash);
                 cmdCash.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  
                 		
                    Toast.makeText(BasketList.this, "Cash  Clicked b", Toast.LENGTH_SHORT).show();  
                   	Intent nextScreen = new Intent(getApplicationContext(), TenderCash.class);                   
                	//Sending data to another Activity                 
                	nextScreen.putExtra("name", "data");
                	//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
                	startActivityForResult(nextScreen, 1);                            			  
                 	
                 	 
                 	}
                 });
				 */
           }  		
    		
    		// Setup the new
    		iCurrentMenu = iMenu;
    	}
    	
    }
  
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		AppContext bb  = (AppContext)getApplicationContext();
	    if ((requestCode == REQUEST_CARD) || (requestCode == REQUEST_CASH)){
	        if(resultCode == RESULT_OK){

				
				//adapter.clear();
				
				itemList = bb.basket.basketContents;
				
				//adapter.addAll(itemList);
				
				//adapter.notifyDataSetChanged();
				
				// getListView().refreshDrawableState();
				
				if ((bb.basket.balanceDue == 0) && (bb.basket.basketContents.size() > 0)){
					
                    Intent nextScreen = new Intent(getApplicationContext(), CCSTPrinting.class);                   
                	nextScreen.putExtra("nextAction", "print");
                	startActivityForResult(nextScreen, REQUEST_PRINT);                            			  
					
				} else {
			         adapter = new BasketListAdaptor(this,itemList,bb);
			         setListAdapter(adapter);
				}

	        }
	    }
	    if (requestCode == REQUEST_PRINT){
	    	
	    	 // printed so finished??
	         
	         for(BasketSupport bs : bb.basket.basketProducts){
	        	 if(bs.itemType == BasketSupport.ItemType.FARE){
	    	         bb.fareManager.addHistoricFare(bs.ticket);
	        	 }
	         }
	         
      		bb.basket.basketContents.clear();
      		bb.basket.basketProducts.clear();
      		bb.basket.basketTenders.clear();
      		bb.basket.refreshBasket(bb);

	         adapter = new BasketListAdaptor(this,itemList,bb);
	         setListAdapter(adapter);	   

	    }
	    
	    //adapter.clear();


	}    


}
