package com.example.twolibs.SaleGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R.color;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.RetailBL.RetailItemSupport;
import com.example.twolibs.SaleBL.BasketComment;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SaleBL.BasketSupport.ItemType;
import com.example.twolibs.SaleBL.Tender.TenderType;
import com.example.twolibs.SupportBL.DataConvert;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;


public class BasketListAdaptor extends ArrayAdapter<BasketSupport> {
	  private final Activity context;
	  private final ArrayList<BasketSupport> faresList;
	  private final AppContext bb;



	  static class ViewHolder {
		public LinearLayout lay_entry;
	  }

	  public BasketListAdaptor(Activity context, ArrayList<BasketSupport> list, AppContext bb) {
	    super(context, R.layout.basket_entry, list);
	    this.context = context;
	    this.faresList = list;
	    this.bb = bb;
	  }

	  @Override
	  public View getView(int position, View convertView, ViewGroup parent) {
	    View rowView = convertView;
	    LayoutInflater inflater = context.getLayoutInflater();
	     
	    
	    // reuse views
	    if (rowView == null) {
	      rowView = inflater.inflate(R.layout.basket_entry, null);
	      // configure view holder
	      ViewHolder viewHolder = new ViewHolder();

	      viewHolder.lay_entry = (LinearLayout) rowView.findViewById(R.id.lay_entry);

	      rowView.setTag(viewHolder);
	    }

	    // fill data
	    ViewHolder holder = (ViewHolder) rowView.getTag();

	    // Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);
    		  
	    BasketSupport bs = faresList.get(position);
	    // TODO use bs.productType to format the entry
	    
	    if(bs.itemType == ItemType.FARE){	
	    	displayFare(holder,inflater,rowView,bs);
	    } else if (bs.itemType == ItemType.RETAIL_ITEM){
	    	displayRetailItem(holder,inflater,rowView,bs);
	    } else if (bs.itemType == ItemType.COMMENT){
	    	displayComment(holder,inflater,rowView,bs);
	    } else if (bs.itemType == ItemType.TENDER){
	    	displayTender(holder,inflater,rowView,bs);
	    }
	    

	    	
	    return rowView;
	  }

	  private void displayTender(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.tender_entry, null));
			
		TextView txtTender = (TextView) rowView.findViewById(R.id.txtTender);
		TextView txtAmount = (TextView) rowView.findViewById(R.id.txtAmount);

    
		Tender s = bs.tender;
		if(s.tenderType == TenderType.CASH){
			txtTender.setText("Cash tendered");
		} else if(s.tenderType == TenderType.CHANGE){
			txtTender.setText("Change given");
		} else if(s.tenderType == TenderType.CARD){
			txtTender.setText("Card tendered");
		}
		
		double intCost = s.tenderValue / 100;
		txtAmount.setText(String.format("£%.2f", intCost));
		
	  }

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (context.getResources().getColor(Color, TH));
		}else{
			return (context.getResources().getColor(Color));
		}
	}

	  private void displayRetailItem(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport rs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.retailitem_entry, null));

		TextView txtDomain = (TextView) rowView.findViewById(R.id.txtDomain);
		TextView txtComment = (TextView) rowView.findViewById(R.id.txtComment);
		TextView txtDirection = (TextView) rowView.findViewById(R.id.txtDirection);
		TextView txtTime = (TextView) rowView.findViewById(R.id.txtTime);
		

		txtDomain.setPadding(0, 0, 0, 0);
		txtDomain.setText(rs.retail.Description);
		txtComment.setPadding(80, 0, 0, 0);
		txtComment.setText(rs.retail.PLU);
		txtDirection.setText("");
		txtTime.setText("£" + DataConvert.doubleToDisplayFormat(rs.retail.Price));
  	
	  }
	  
	  private void displayComment(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.basket_comment_entry, null));
			
		TextView txtComment = (TextView) rowView.findViewById(R.id.txtComment);
		TextView txtAmount = (TextView) rowView.findViewById(R.id.txtAmount);
     
		BasketComment s = bs.comment;

		txtComment.setText(s.CommentText);
		
		double intCost = s.CommentValue / 100;
		txtAmount.setText(String.format("£%.2f", intCost));
		
	  }

	  private void displayFare(ViewHolder holder, LayoutInflater inflater, View rowView, BasketSupport bs){
		  
		holder.lay_entry.addView(inflater.inflate(R.layout.ticket_entry, null));
			
		TextView txtClass = (TextView) rowView.findViewById(R.id.txtClass);
		TextView txtTicketCode = (TextView) rowView.findViewById(R.id.txtTicketCode);
		TextView txtTicketDesc  = (TextView) rowView.findViewById(R.id.txtTicketDesc);
		TextView txtCost = (TextView) rowView.findViewById(R.id.txtCost);
		TextView txtOrigin = (TextView) rowView.findViewById(R.id.txtOrigin);
		TextView txtDestination = (TextView) rowView.findViewById(R.id.txtDestination);
		TextView txtFlowOwner = (TextView) rowView.findViewById(R.id.txtFlowOwner);
		TextView txtRoute = (TextView) rowView.findViewById(R.id.txtRoute);
		TextView txtRestrictionCode  = (TextView) rowView.findViewById(R.id.txtRestrictionCode);
		LinearLayout layReasons = (LinearLayout) rowView.findViewById(R.id.layReasons);
     
		TNFare s = bs.ticket;
	    if (s.getFa_FareClass() == 1) {
	    	txtClass.setText("1st");
	    	txtClass.setTextColor(JMgetColor(R.color.fj_blue_3, context.getTheme()));
	    } else {
	    	txtClass.setText("STD");
	    	txtClass.setTextColor(JMgetColor(R.color.fj_black_0, context.getTheme()));
	    }
		txtTicketCode.setText(s.getFa_TicketTypeCode());

		TicketDetails tkt;
		String txtTicketCodeDesc = s.getFa_TicketTypeCode();
		if (FareManager.ticketCodes.containsKey(txtTicketCodeDesc)){
			tkt = FareManager.ticketCodes.getValue(txtTicketCodeDesc);
		    txtTicketDesc.setText(tkt.getTd_TicketTypeDesc());
		} else {
		    txtTicketDesc.setText(txtTicketCode + "????");
		}

 		double intCost =((double)s.getFa_TotalFareS()) / 100;
		txtCost.setText(String.format("£%.2f", intCost));
		
		Location loc;
		String txtNLCCode, txtLoc;

		txtNLCCode = s.getFa_FareOriginLocation();
		loc = Location.getLocationByNLC(txtNLCCode);
		if (loc != null){
			txtLoc = loc.getDescription().trim();
		} else {
			txtLoc = "";
		}
		if(txtLoc.length()>0) {
		   txtOrigin.setText(txtLoc);
		} else {
		   txtOrigin.setText(txtNLCCode);
		}

		txtNLCCode = s.getFa_FareDestinationLocation();
		loc = Location.getLocationByNLC(txtNLCCode);
		if (loc != null){
			txtLoc = loc.getDescription().trim();
		} else {
			txtLoc = "";
		}

		if(txtLoc.length()>0) {
 		    txtDestination.setText(txtLoc);
 		} else {
 		    txtDestination.setText(txtNLCCode );
 		}
		
	    txtFlowOwner.setText(s.getFa_FlowOwner());	
	    txtRoute.setText(s.getFa_RouteDescription());
	    txtRestrictionCode.setText(s.getFa_RestrictionCode());
 		
	    // 
	    String txtNoSaleReason = s.getFa_NoSaleReason();
	    if (txtNoSaleReason.length() == 0){
	    	layReasons.removeAllViews();               
	    } else {
	    	layReasons.removeAllViews();               
	    	layReasons.addView(inflater.inflate(R.layout.ticket_summary_reason, null));
	    	TextView txtNotes = (TextView) rowView.findViewById(R.id.txtNotes);
	    	txtNotes.setText(s.getFa_NoSaleReason());
	    }
	  }

	} 
