package com.example.twolibs.SaleGUI;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DevicesBL.IngenicoCommon;
import com.example.twolibs.DevicesBL.IngenicoCommon.PclServiceConnection;
import com.example.twolibs.R.color;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.R.menu;
import com.example.twolibs.R.string;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SaleBL.Tender.TenderType;
import com.example.twolibs.SupportBL.DataConvert;
import com.ingenico.pclservice.IPclService;
import com.ingenico.pclservice.IPclServiceCallback;
import com.ingenico.pclservice.TransactionIn;
import com.ingenico.pclservice.TransactionOut;

import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.os.Build;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;
import android.widget.Toast;
import android.view.MotionEvent;


public class TenderCard extends IngenicoCommon  {

    private Context activityContext;

	static class PclObject {
		PclServiceConnection serviceConnection;
		IPclService service;
//		NetworkTask nwTask;
	}    
    
    private int amountDue = 0;
    private int amountTendered = 0;
    private boolean canRetry = false;
    private boolean payInProgress = false;
   
    //TODO timeout of ingenico
    //TODO ped switch off during tx
    
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tendercard ); 
        final Context context = this;

    	final AppContext bb  = (AppContext)getApplicationContext();
    	bb.basket.refreshBasket(bb);
    	amountDue = bb.basket.balanceDue;
     	
 	    setTitle(" Tender Card");
 
	    // INGENICO code
	    activityContext = this;
	    
        mReleaseService = 1;
        final PclObject data = (PclObject) getLastNonConfigurationInstance();
		if (data == null || data.service == null || data.serviceConnection == null) {
			Log.d(TAG, "onCreate: Init service" );
			initService();
		}
		else
		{
			Log.d(TAG, "onCreate: Service already initialized" );
			mServiceConnection = data.serviceConnection;
			mPclService = data.service;
			mBound = true;
		}

		
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		txtPED.setText("Checking PED");

	    
	    LinearLayout layAmountDue = (LinearLayout)findViewById(R.id.layAmountDue);
	    layAmountDue.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				// get prompts.xml view
				LayoutInflater layoutInflater = LayoutInflater.from(context);

				View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);

				AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);

				// set prompts.xml to be the layout file of the alertdialog builder
				alertDialogBuilder.setView(promptView);

				final EditText input = (EditText) promptView.findViewById(R.id.userInput);

				// setup a dialog window
				alertDialogBuilder
						.setCancelable(false)
						.setPositiveButton("OK", new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog, int id) {
										// get user input and set it to result
										String txtAmount = String.valueOf(input.getText());
										amountDue = currencyStringInt(txtAmount);
										refreshData();
										makePayment(amountDue);
										
									}
								})
						.setNegativeButton("Cancel",
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,	int id) {
										dialog.cancel();
									}
								});

				// create an alert dialog
				AlertDialog alertD = alertDialogBuilder.create();

				alertD.show(); 
				
				// These lines ensure that the keyboard is ready for input
				alertD.getWindow().clearFlags( WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE |WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM); 
				alertD.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE); 

			}
		});

	    

	    
	    refreshData();
    


 
	    Button cmdDone = (Button) findViewById(R.id.cmdDone);
	    cmdDone.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		Tender card = new Tender();
        		card.tenderValue = amountTendered;
        		card.tenderType = TenderType.CARD;
        		bb.basket.addTender(card, amountTendered);
        		
        		bb.basket.refreshBasket(bb);
        		
             	Intent returnIntent = new Intent();
               	returnIntent.putExtra("result","Done");
               	setResult(RESULT_OK,returnIntent);
               	finish();           	
         	 
        	}
        });

	    Button cmdRetry = (Button) findViewById(R.id.cmdRetry);
	    cmdRetry.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		makePayment(amountDue);
         	 
        	}
        });
	    
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync ) {
			Toast.makeText(TenderCard.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}else if  (item.getItemId() == R.id.cmdHelp ) {
			Toast.makeText(TenderCard.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
	}
    

    
    private void refreshData(){
        TextView txtAmountDue;
        TextView txtAmountTendered;
        
	    txtAmountDue = (TextView) findViewById(R.id.txtAmountDue);
	    txtAmountTendered = (TextView) findViewById(R.id.txtAmountTendered);

        
 		double intCost =((double)amountDue) / 100;
 		txtAmountDue.setText(String.format("£%.2f", intCost));

 		
 		if(amountTendered != 0){
	 		intCost =((double)amountTendered) / 100;
	 		txtAmountTendered.setText(String.format("£%.2f", intCost));

 		} else {
 			txtAmountTendered.setText("");
  		}
 		
        Button cmdDone = (Button) findViewById(R.id.cmdDone);

    	if(amountTendered > 0){
    		cmdDone.setEnabled(true);
    		cmdDone.setBackgroundColor(getResources().getColor(R.color.button_background));
    	} else {
    		cmdDone.setEnabled(false);
    		cmdDone.setBackgroundColor(getResources().getColor(R.color.button_background_disabled));
  		
    	}
 
        Button cmdRetry = (Button) findViewById(R.id.cmdRetry);

    	if(canRetry || payInProgress){
    		cmdRetry.setEnabled(true);
    		cmdRetry.setBackgroundColor(getResources().getColor(R.color.button_background));
    	} else {
    		cmdRetry.setEnabled(false);
    		cmdRetry.setBackgroundColor(getResources().getColor(R.color.button_background_disabled));
  		
    	}
    	
    }
    
    private int currencyStringInt(String txtIn){
    	//TODO Error handling
    	double amount;
    	String txtStriped = (txtIn.replace("�", "")).trim();
    	if(txtStriped.length()==0){
    		return 0;
    	}
    	amount = Double.valueOf(txtStriped);
    	int adjustedAmount;
    	adjustedAmount = (int)(amount * 100);
    	return adjustedAmount;
    }
    
	// INGENICO CODE 
	
	class GetTermInfoTask extends AsyncTask<Void, Void, Boolean> {
		protected Boolean doInBackground(Void... tmp) {
			Boolean bRet = getTermInfo();
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "PED not connected";
			TextView txtPED = (TextView)findViewById(R.id.txtPED);
			txtPED.setText(Boolean.toString(result));
			if (result == true)
			{
				strResult = String.format("SN: %08x PN:%08x", SN, PN);
				txtPED.setBackgroundColor(Color.GREEN);
				txtPED.setTextColor(Color.BLACK);		
			} else {
				txtPED.setBackgroundColor(Color.RED);
				txtPED.setTextColor(Color.BLACK);		
			}
			txtPED.setText(strResult);
		}
	}

	class OpenBarcodeTask extends AsyncTask<Void, Void, Boolean> {
		private byte[] mResult;
		OpenBarcodeTask(byte[] result) {
			mResult = result;
		}
		protected Boolean doInBackground(Void... dummy) {
			Boolean bRet = false;
			bRet = openBarcode(mResult);
			Log.d(TAG, String.format("openBarcode bRet=%s mResult=%d", Boolean.toString(bRet), mResult[0]));
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "";
			TextView txtCCSTPrinter = (TextView)findViewById(R.id.txtCCSTPrinter);	
			txtCCSTPrinter.setText(Boolean.toString(result));
			if (result == true)
			{
				switch (mResult[0]) {
				case 0:
					strResult = "Barcode scanner ready";
					break;
				default:
					strResult = "Failed (" + mResult[0] + ")";
					break;
				}
			} else {
				strResult = "Barcode scanner on";
			}
			// TODO Setup the MAC code with :
			txtCCSTPrinter.setText(strResult);
		}
	}
	
	class CloseBarcodeTask extends AsyncTask<Void, Void, Boolean> {
		private byte[] mResult;
		CloseBarcodeTask(byte[] result) {
			mResult = result;
		}
		protected Boolean doInBackground(Void... dummy) {
			Boolean bRet = false;
			bRet = closeBarcode(mResult);
			Log.d(TAG, String.format("closeBarcode bRet=%s mResult=%d", Boolean.toString(bRet), mResult[0]));
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "N/A";
			TextView txtPED = (TextView)findViewById(R.id.txtPED);
			txtPED.setText(Boolean.toString(result));
			if (result == true)
			{
				switch (mResult[0]) {
				case 0:
					strResult = "OK";
					txtPED.setText(strResult);
					break;
				default:
					strResult = "Failed (" + mResult[0] + ")";
					txtPED.setText(strResult);
					break;
				}
			} else {
				txtPED.setText("Failed ");

			}
		}
	}
	
	class DoTransactionTask extends AsyncTask<Void, Void, Boolean> {
 		private TransactionIn transIn;
		private TransactionOut transOut;
    	public DoTransactionTask(TransactionIn transIn, TransactionOut transOut) {
    		Log.d(TAG, String.format("DoTransactionTask CONSTRUCT"));
    		this.transIn = transIn;
    		this.transOut = transOut;
    	}
    	
        protected Boolean doInBackground(Void... tmp) {
        	Boolean bRet = doTransaction(transIn, transOut);
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
        	Log.d(TAG, String.format("DoTransactionTask onPostExecute"));
    		payInProgress = false;

        	TextView txtPED = (TextView)findViewById(R.id.txtPED);
    		txtPED.setText("PED response " + transOut.getC3Error());
        	
	        if (transOut.getC3Error().equals("0000"))
	        {	
	        	// Success
	        	String receipt ="";
	        	amountTendered = DataConvert.stringToInt(transOut.getAmount());
	        	
	        	//transOut.getC3Error();
	        	//transOut.getUserData();
	        			
	        	txtPED.setText("Success " + amountTendered);
				canRetry = false;
	        	refreshData();
	        	
	        }
	        else
	        {
	        	txtPED.setText("Failed " +  transOut.getC3Error());
	        	Toast.makeText(getBaseContext(),getString(R.string.str_failed), Toast.LENGTH_LONG).show();	
				canRetry = true;
	        	refreshData();

	        }

			// Somewhere in your application you need to unregister the callback
			// functions when you don�t need them
			//try {
			//	mPclService.unregisterCallback(mCallback);
			//	} catch (RemoteException e) {
			//}
        }
    }
	
	@Override
	public void onStateChanged(String state) {
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		if (state.equals("CONNECTED"))
		{
			txtPED.setText("Connected");
			txtPED.setBackgroundColor(Color.GREEN);
			txtPED.setTextColor(Color.BLACK);
			
			if (amountDue != 0){
				makePayment(amountDue);
			}
		}
		else
		{
			txtPED.setText("Not connected");
			txtPED.setBackgroundColor(Color.RED);
			txtPED.setTextColor(Color.BLACK);
		}
	}
	
	@Override
	public void onPclServiceConnected() {
		Log.d(TAG, "onPclServiceConnected");
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		
		if (isCompanionConnected())
        {
			txtPED.setText("Connected companion");
			txtPED.setBackgroundColor(Color.GREEN);
			txtPED.setTextColor(Color.BLACK);
			
			if (amountDue != 0){
				makePayment(amountDue);
			}
        }
        else
        {
			txtPED.setText("Ped not connected");
			txtPED.setBackgroundColor(Color.RED);
			txtPED.setTextColor(Color.BLACK);
        }
	}
	
	@Override
	public void onBarCodeReceived(String barCodeValue)
	{
		TextView txtCCSTPrinter = (TextView)findViewById(R.id.txtCCSTPrinter);	
		txtCCSTPrinter.setText(barCodeValue);

		Log.d(TAG, "Ignored barcode" );

	}
	
	private boolean openBarcode(byte[] result) {
		boolean ret = false;
		if( mPclService != null ) {
			try {
				ret = mPclService.openBarcode(result);
			} catch( RemoteException ex ) {
				ex.printStackTrace();
			}
		}
		else {
			Log.d(TAG, "openBarcode: mPclService is null");
		}
		return ret;
	}

	private boolean closeBarcode(byte[] result) {
		boolean ret = false;
		if( mPclService != null ) {
			try {
				ret = mPclService.closeBarcode(result);
			} catch( RemoteException ex ) {
				ex.printStackTrace();
			}
		}
		return ret;
	}
	
	private IPclServiceCallback mCallback = new IPclServiceCallback.Stub() {
		public void shouldFeedPaper(int lines) {
			Log.e(TAG, "shouldFeedPaper " + lines);
			//mHandler.sendMessage(mHandler.obtainMessage(MSG_FEED_PAPER, lines, 0));
		}
		//Implement all other callbacks

		@Override
		public void shouldCutPaper() throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldCutPaper ");
			
		}

		@Override
		public void shouldPrintText(String text, byte font, byte justification,
				byte xfactor, byte yfactor, byte underline, byte bold)
				throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldPrintText " + text);
			
		}

		@Override
		public void shouldPrintImage(Bitmap image, byte justification)
				throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldPrintImage ");
			
		}

		@Override
		public void shouldDoSignatureCapture(int pos_x, int pos_y, int width,
				int height, int timeout) throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldDoSignatureCapture ");
			
		}

		@Override
		public void signatureTimeoutExceeded() throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "signatureTimeoutExceeded ");
			
		}

		@Override
		public void shouldAddSignature() throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldAddSignature ");
			
		}

		@Override
		public int shouldStartReceipt(byte type) throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldStartReceipt ");
			return 0;
		}

		@Override
		public int shouldEndReceipt() throws RemoteException {
			// TODO Auto-generated method stub
			Log.e(TAG, "shouldEndReceipt ");
			return 0;
		}
	};

		
		
	private void makePayment(int requestAmountPence){
		
		payInProgress = true;
		
		TransactionIn transIn = new TransactionIn();
		TransactionOut transOut = new TransactionOut();
		
		// Somewhere in your application you need to register the callback
		// functions to be able to use them
		try {
			mPclService.registerCallback(mCallback, false);
			Log.d(TAG, "registerCallback" );
		//Add-on PCL for Android 19/29
		} catch (RemoteException e) {
			Log.e(TAG,"Register failed" );
			
		}
		
		String amount = Integer.toString(requestAmountPence);
		
		//TODO all the parameters
    	transIn.setAmount(amount);
    	transIn.setCurrencyCode("978");
    	transIn.setOperation("C");
    	transIn.setTermNum("58");

    	TextView txtPED = (TextView)findViewById(R.id.txtPED);	
    	txtPED.setText("Hand payment terminal to customer \nTransaction in progress");
        new DoTransactionTask(transIn, transOut).execute();
        
	}
	
}




