package com.example.twolibs.SaleGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SaleBL.Tender.TenderType;


public class TenderCash extends Activity  {

    
    // TODO paramerise
    private int coinage [] = {1,2,5,10,20,50,100,200,500,1000,2000,5000};
    
    private int amountDue = 0;
    private int amountTendered = 0;
    private int changeDue = 0;
    
    private TextView txtValues[] = new TextView[9];
    private LinearLayout cmdValues[] = new LinearLayout[9];
    
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tendercash ); 
        final Context context = this;

    	final AppContext bb  = (AppContext)getApplicationContext();
    	bb.basket.refreshBasket(bb);
    	amountDue = bb.basket.balanceDue;
    	amountTendered = 0;
    	changeDue = 0;
    	
    	
        txtValues[0] = (TextView) findViewById(R.id.txtValue0);
        txtValues[1] = (TextView) findViewById(R.id.txtValue1);
        txtValues[2] = (TextView) findViewById(R.id.txtValue2);
        txtValues[3] = (TextView) findViewById(R.id.txtValue3);
        txtValues[4] = (TextView) findViewById(R.id.txtValue4);
        txtValues[5] = (TextView) findViewById(R.id.txtValue5);
        txtValues[6] = (TextView) findViewById(R.id.txtValue6);
        txtValues[7] = (TextView) findViewById(R.id.txtValue7);
        txtValues[8] = (TextView) findViewById(R.id.txtValue8);

        cmdValues[0] = (LinearLayout) findViewById(R.id.cmdValue0);
        cmdValues[1] = (LinearLayout) findViewById(R.id.cmdValue1);
        cmdValues[2] = (LinearLayout) findViewById(R.id.cmdValue2);
        cmdValues[3] = (LinearLayout) findViewById(R.id.cmdValue3);
        cmdValues[4] = (LinearLayout) findViewById(R.id.cmdValue4);
        cmdValues[5] = (LinearLayout) findViewById(R.id.cmdValue5);
        cmdValues[6] = (LinearLayout) findViewById(R.id.cmdValue6);
        cmdValues[7] = (LinearLayout) findViewById(R.id.cmdValue7);
        cmdValues[8] = (LinearLayout) findViewById(R.id.cmdValue8);


        //ActionBar actionBar = getActionBar(); 
        //actionBar.hide();
	    setTitle(" Tender Cash");


    	cmdValues[0].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[0].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
				
				// Exact cash so no change to prompt
        		doTender(bb);
        		
             	Intent returnIntent = new Intent();
               	returnIntent.putExtra("result","Done");
               	setResult(RESULT_OK,returnIntent);
               	finish();  
               	}
		}); 

    	cmdValues[1].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[1].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		}); 
    	cmdValues[2].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[2].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});     	
    	cmdValues[3].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[3].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});    
    	cmdValues[4].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[4].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		}); 
    	cmdValues[5].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[5].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});    	
    	cmdValues[6].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[6].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});    	
    	cmdValues[7].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[7].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});    	
    	cmdValues[8].setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				String txtAmount = String.valueOf(txtValues[8].getText());
				amountTendered = currencyStringInt(txtAmount);
				refreshData();
			}
		});    	
    	
	    LinearLayout layAmountDue = (LinearLayout)findViewById(R.id.layAmountDue);
	    layAmountDue.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				// get prompts.xml view
				LayoutInflater layoutInflater = LayoutInflater.from(context);

				View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);

				AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);

				// set prompts.xml to be the layout file of the alertdialog builder
				alertDialogBuilder.setView(promptView);

				final EditText input = (EditText) promptView.findViewById(R.id.userInput);

				// setup a dialog window
				alertDialogBuilder
						.setCancelable(false)
						.setPositiveButton("OK", new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog, int id) {
										// get user input and set it to result
										String txtAmount = String.valueOf(input.getText());
										amountDue = currencyStringInt(txtAmount);
										refreshData();
										
									}
								})
						.setNegativeButton("Cancel",
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,	int id) {
										dialog.cancel();
									}
								});

				// create an alert dialog
				AlertDialog alertD = alertDialogBuilder.create();

				alertD.show(); 
				
				// These lines ensure that the keyboard is ready for input
				alertD.getWindow().clearFlags( WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE |WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM); 
				alertD.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE); 

			}
		});

	    
	    LinearLayout layTendered = (LinearLayout)findViewById(R.id.layTendered);
	    layTendered.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View view) {

				// get prompts.xml view
				LayoutInflater layoutInflater = LayoutInflater.from(context);

				View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);

				AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);

				// set prompts.xml to be the layout file of the alertdialog builder
				alertDialogBuilder.setView(promptView);

				final EditText input = (EditText) promptView.findViewById(R.id.userInput);

				// setup a dialog window
				alertDialogBuilder
						.setCancelable(false)
						.setPositiveButton("OK", new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog, int id) {
										// get user input and set it to result
										String txtAmount = String.valueOf(input.getText());
										amountTendered = currencyStringInt(txtAmount);
										refreshData();
										
									}
								})
						.setNegativeButton("Cancel",
								new DialogInterface.OnClickListener() {
									public void onClick(DialogInterface dialog,	int id) {
										dialog.cancel();
									}
								});

				// create an alert dialog
				AlertDialog alertD = alertDialogBuilder.create();

				alertD.show(); 
				
				// These lines ensure that the keyboard is ready for input
				alertD.getWindow().clearFlags( WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE |WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM); 
				alertD.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE); 

			}
		});
	    
	    refreshData();
    


 
	    Button cmdDone = (Button) findViewById(R.id.cmdDone);
	    cmdDone.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  
        		
        		doTender(bb);
        		
             	Intent returnIntent = new Intent();
               	returnIntent.putExtra("result","Done");
               	setResult(RESULT_OK,returnIntent);
               	finish();           	
         	 
        	}
        });

	    
    }
    
    private void doTender(AppContext bb){
		Tender cash = new Tender();
		cash.tenderValue = amountTendered;
		cash.tenderType = TenderType.CASH;
		bb.basket.addTender(cash, amountTendered);

		if(changeDue != 0){
       		Tender change = new Tender();
       		change.tenderValue = changeDue;
       		change.tenderType = TenderType.CHANGE;
    		bb.basket.addTender(change, changeDue);
		}
		
		bb.basket.refreshBasket(bb);	
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync) {
			Toast.makeText(TenderCash.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(TenderCash.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
	}


	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}

    
    private void refreshData(){
        TextView txtAmountDue;
        TextView txtAmountTendered;
        TextView txtChangeDue;
        
	    txtAmountDue = (TextView) findViewById(R.id.txtAmountDue);
	    txtAmountTendered = (TextView) findViewById(R.id.txtAmountTendered);
	    txtChangeDue = (TextView) findViewById(R.id.txtChangeDue);

        
 		double intCost =((double)amountDue) / 100;
 		txtAmountDue.setText(String.format("£%.2f", intCost));

 		int i;
 		int suggestions[] = new int[coinage.length];
 		int value =0;
 		// 1st suggestion is always exact
 		suggestions[value] = amountDue;
 		
 		
 		for(i=0; i < coinage.length; i++){
 			int denomination = coinage[i];
 			if((amountDue % denomination) != 0){
 				int suggestion = ((amountDue / denomination) + 1) * denomination;
 				// Append the value if the suggestion is different
 				if(suggestion != suggestions[value]){
 					value++;
 					suggestions[value] = suggestion;
 				}
 			}
 			
 		}
 		
 		for(i=0; i <9; i++){
 			if(i > value){
 				// hide
 				cmdValues[i].setVisibility(View.INVISIBLE);

 			} else {
 				cmdValues[i].setVisibility(View.VISIBLE);
 				
 		 		intCost =((double)suggestions[i]) / 100;
 		 		txtValues[i].setText(String.format("�%.2f", intCost));
 			}
 		}
 		
 		if(amountTendered != 0){
	 		intCost =((double)amountTendered) / 100;
	 		txtAmountTendered.setText(String.format("�%.2f", intCost));
	 		if(amountTendered >= amountDue){
	 			changeDue = amountDue - amountTendered;
		 		intCost =((double)changeDue) / 100;
		 		txtChangeDue.setText(String.format("�%.2f", intCost));
	 		} else {
	 			txtChangeDue.setText("");
	 		}
 		} else {
 			txtAmountTendered.setText("");
 			txtChangeDue.setText("");
 		}
 		
        Button cmdDone = (Button) findViewById(R.id.cmdDone);

    	if(amountTendered > 0){
    		cmdDone.setEnabled(true);
    		cmdDone.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
    	} else {
    		cmdDone.setEnabled(false);
    		cmdDone.setBackgroundColor(JMgetColor(R.color.button_background_disabled, getTheme()));
    	}
    	
    }
    
    private int currencyStringInt(String txtIn){
    	//TODO Error handling
     	String txtStriped = (txtIn.replace("�", "")).trim();
    	if(txtStriped.length()==0){
    		return 0;
    	}
    	Float floatAmount=Float.parseFloat(txtStriped);
    	
    	int adjustedAmount;
    	adjustedAmount = (int)(floatAmount * 100);
    	return adjustedAmount;
    }
}




