package com.example.twolibs.SessionGUI;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DevicesGUI.DeviceSupport;
import com.example.twolibs.DutyGUI.DutyMain;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.MenuGUI.MenuTop;
import android.os.Bundle;
import android.os.Environment;
import android.app.Activity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.content.Intent;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import android.os.Build;

public class Logon extends Activity  {

	public static final int REQUEST_DEVICES = 1;
	public static final int REQUEST_DUTY = 2;
	public static final int REQUEST_ACCOUNTS = 3;

	
	String userName = "";
	String userPassword = "";
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_logon ); 
 
        
	    setTitle(" Logon");
	    
     	final AppContext bb  = (AppContext)getApplicationContext();
     	
     	bb.initialise();
    	FareManager.STDResponse resp;
        String fibFile;
        //fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FIBb5_0s2v1g449.FIB";
        fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FARES.FIB";
    	resp =  bb.fareManager.doLoad(fibFile);


	    doCheckComplete();
	    
	    EditText txtUserName = (EditText)findViewById(R.id.txtUserName);
	    txtUserName.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
	            userName = s.toString();
	            doCheckComplete();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
	    
	    EditText txtPassword = (EditText)findViewById(R.id.txtPassword);
	    txtPassword.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
	            userPassword = s.toString();
	            doCheckComplete();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
	    

        Button cmdLogon = (Button) findViewById(R.id.cmdLogon);
        cmdLogon.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

            // TODO logon check
           
        	//redundant	testCodes();
        		
        		
        	// Success
	        Intent nextScreen = new Intent(getApplicationContext(), DeviceSupport.class);                   
	        startActivityForResult(nextScreen, REQUEST_DEVICES);
        	}  

        }); 
        
	    
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText(Logon.this, "sync data", Toast.LENGTH_SHORT).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(Logon.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
        }
        return super.onOptionsItemSelected(item);
    }

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}


    void doCheckComplete(){
        Button cmdOptionF1 = (Button) findViewById(R.id.cmdLogon);

    	if((userName.length() > 0) && (userPassword.length() > 0)){
            cmdOptionF1.setEnabled(true);
            cmdOptionF1.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
    	} else {
            cmdOptionF1.setEnabled(false);
            cmdOptionF1.setBackgroundColor(JMgetColor(R.color.button_background_disabled, getTheme()));
  		
    	}
    	
    }
    @Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		// This code controls the follow on activity after a selected activity
    	Intent nextScreen;
		switch(requestCode) {

			
        	case REQUEST_DEVICES:
        		//After devices picked up we can start an RSP shift
             	nextScreen = new Intent(getApplicationContext(), Accounts.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_ACCOUNTS);

        		break;
        		
           	case REQUEST_ACCOUNTS:
        		//Shift started - pick duty
	           	nextScreen = new Intent(getApplicationContext(), DutyMain.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivityForResult(nextScreen, REQUEST_DUTY);
            	break;
           	
           	case REQUEST_DUTY:
           		// All done go to top menu
             	nextScreen = new Intent(getApplicationContext(), MenuTop.class);                   
            	nextScreen.putExtra("nextAction", "");
	        	startActivity(nextScreen);
      		    
 		}

	}
    
    void testCodes(){
    	// TODO remove rest of class once bar code scanner in place
    	
    	String base = "PYRZDXPLBSVIPHZTRURPPXLQZDSFMTSSWSQHQHCUFUKXIRNEYLTIJYPLPZSYVNXGDJSDLIKVIOXTAFKNHQLLTIEHPCKZTYERMHWEATNNYOSTWMIOBQUYKICCOMCELORCKHTSPLDUTHZGOKOUPSHPAFOTPYFHNDXKDVQBZAGXFPOJZJFJCIKPBCGZCTFNXUOWIFANWUNMWHPBWFOJVFUPKBSNWJ";
    	byte encoded[];
    	
    	encoded = decodeBase26(base);
    	
    	int i = 0;
    	i= i+1;
    	
    	
    }
	 /** symbols used for the encoding,
	 * you can replace these with any 26 chars that your transport layer copes well with*/ final String base26characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	 /** The encoding ratio for base256 -> base26 is tends to be
	 * 1: 1.7019684284269052288495022732257 'characters'.
	 * 852/500 is a slight over estimation (at 1.702)
	 */
	 final int base26Nom = 851;
	 final int base26Denom = 500;
	 /**
	 * convert from an 8Bit byte array into a base26 character String
	 * the output string will only use upper case letters, no spaces or other characters
	 *
	 * @param in - unsigned byte array
	 * @return a string, representing the input array in base26 uppercase letters
	 */ 
	 String encodeBase26 (byte[] in)
	 {
		 // this size is going to be larger than required
		 // This is fairly close to the 1.17519... ratio (actual value below is 1.1752)
		 int overEstSize = ((in.length * base26Nom) + base26Denom - 1) / base26Denom;
		 //create a new temporary array to hold the base26 values (from 0 to 25) that
		 //are calculated for the output message
		 byte[] base26byteArray = new byte[overEstSize];
		 //the actual base conversion
		 for (int x = 0; x < overEstSize; x++)
		 {
			 int accumulator = 0;
			 for (int i = in.length - 1; i >= 0; i--)
			 {
				 int v = (accumulator * 256) + maskBottomByteFromInt (in[i]);
				 in[i] = (byte)(v / 26);
				 accumulator = v - (maskBottomByteFromInt (in[i]) * 26);
			 }
			 base26byteArray[x] = (byte)accumulator;
		 }
		 // convert from a base26 array into a base26 character String
		 char[] encChars = new char[overEstSize];
		 for (int x = 0; x < overEstSize; x++)
		 {
			 //simply pick out the symbol that represents this value from 0 to 25
			 //from the source characters and put them into the output char array
			 encChars[x] = base26characters.charAt (base26byteArray[x]);
		 }
		 //wrap the char array in a string for easy handling 
		 return new String (encChars);
	 
	 }
	 /**
	 * convert from a base26 String to a base26 array
	 * @param encodedString - should only contain uppercase letters
	 * @return an 8Bit unsigned byte array of the original binary data
	 */ 
	 byte[] decodeBase26 (String encodedString)
	 {
		 //temporary array to hold the input values
		 byte[] inputCharValues = new byte[encodedString.length ()];
		 //fill the temporary array with the input char values
		 for (int i = 0; i < inputCharValues.length; i++)
		 {
			 inputCharValues[i] = (byte)base26characters.indexOf
					 (encodedString.charAt (i));
		 }
		 // estimate the result array (might be oversized by 1 byte)

		 int outSize = (inputCharValues.length * base26Denom + base26Nom - 1) /
				 base26Nom;
		 byte[] outputByteArray = new byte[outSize];
		 // out might have an extra character '\u0000' at the end !
		 for (int p = 0; p < outSize; p++)
		 {
			 //reset accumulator to zero
			 int accumulator = 0;
			 for (int i = inputCharValues.length - 1; i >= 0; i--)
			 {
				 int v = accumulator * 26 + maskBottomByteFromInt
						 (inputCharValues[i]);
				 inputCharValues[i] = (byte)(v / 256);
				 accumulator = maskBottomByteFromInt (v);
			 }
			 outputByteArray[p] = (byte)accumulator;
		 }
		 return outputByteArray;
	 }
	 /**
	 * convenience method to retrieve the bottom 8Bits (unsigned byte) from an integer
	 * normally, in code we'd simply do "int&0xFF" to mask off the bottom 8Bits of an int
	 * but bitwise operators confuse many modern OO programmers, and code translators
	 * so this is clearer as a modulo 256 operation so that the output value
	 * is between 0 and 255
	 *
	 * @param input 32Bit integer
	 * @return 8Bit unsigned byte, made from the bottom 8Bits worth of the input value
	 */
	 int maskBottomByteFromInt (int input)
	 {
		 int outputByte;
		 //modulo 256 so that only the final 8Bits of the input are considered
		 outputByte = (256+(input % 256)) % 256;
		 // modulo arithmetic is a poor substitution for bitwise 'and'
		 // as modulo arithmetic is inclusively bound between -(n-1) and +(n-1) for % n
		 // so n + (x % n) is bound between inclusively 1 and 2n-1
		 // hence (n+(x%n))%n is bound inclusively between 0 and n-1
		 return outputByte;
	 }
	 
}




