package com.example.twolibs.SupportBL;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import com.example.twolibs.DutyBL.DutyTaskType;

public class DataConvert {
	public static Date DATENULL = null;
	
	public static String displayTextDate(Date p_date){
		  String displayFormat ="";
		  try{
			  SimpleDateFormat sdt = new SimpleDateFormat("dd ccc MMM yyyy", Locale.UK); 
			  displayFormat = sdt.format(p_date);
		  } catch (Exception e) {
				e.printStackTrace();
		  }
		  return(displayFormat);
	}
	public static String displayTextDateSep(Date p_date){
		  String displayFormat ="";
		  try{
			  SimpleDateFormat sdt = new SimpleDateFormat("dd/MMM/yyyy", Locale.UK); 
			  displayFormat = sdt.format(p_date);
		  } catch (Exception e) {
				e.printStackTrace();
		  }
		  return(displayFormat);
	}
	public static String displayTextTime(Date p_date){
		  String displayFormat ="";
		  try{
			  SimpleDateFormat sdt = new SimpleDateFormat("HH:mm", Locale.UK); 
			  displayFormat = sdt.format(p_date);
		  } catch (Exception e) {
				e.printStackTrace();
		  }
		  return(displayFormat);
	}
	
	public static String displayyyyyMMddHHmm(Date p_date){
		  String displayFormat ="";
		  try{
			  SimpleDateFormat sdt = new SimpleDateFormat("yyyyMMddHHmm", Locale.UK); 
			  displayFormat = sdt.format(p_date);
		  } catch (Exception e) {
				e.printStackTrace();
		  }
		  return(displayFormat);
	}
	public static Date parseYYYYMMDD(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("yyyyMMdd", Locale.UK); 
		  Date date;
		  try {
			date = sdt.parse(p_string);
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  return(date);
	}
	public static Date parseYYYYMMddHHmm(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("yyyyMMddHHmm", Locale.UK); 
		  Date date;
		  try {
			date = sdt.parse(p_string);
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  return(date);
	}

	public static Date parseXMLddmmyyyyhhmmss(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.UK); 
		  Date date;
		  try {
			date = sdt.parse(p_string);
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  return(date);
	}

	public static Date parseISOyyyymmddhhmmss(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.UK); 
		  Date date;
		  try {
			String temp = p_string.replace("T", " ");
			temp = temp.replace("Z", "");
			date = sdt.parse(temp);
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  return(date);
	}

	public static Date parseDDMMYYYY(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("ddMMyyyy", Locale.UK); 
		  Date date;
		  try {
			date = sdt.parse(p_string);
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  return(date);
	}
	public static Date parseHHmmss(String p_string){
		  SimpleDateFormat sdt = new SimpleDateFormat("HH:mm:ss", Locale.UK); 
		  Date date;
		  try {
			date = sdt.parse(p_string);
			
			  // default date to today leaving the parsed time unchanged
			Calendar cal = Calendar.getInstance();
			date = setDate(date,cal.get(Calendar.YEAR),cal.get(Calendar.MONTH),cal.get(Calendar.DAY_OF_MONTH));
			
			} catch (ParseException e) {
				e.printStackTrace();
				date = null;
			}
		  
		  
		  
		  return(date);
	}
	
	public static Date getNow(){
		Calendar c = Calendar.getInstance();
		return( c.getTime());
	}

	public static Date setTime(Date date, int hour, int minute, int second){
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
	    cal.set(Calendar.HOUR_OF_DAY, hour);
	    cal.set(Calendar.MINUTE, minute);
	    cal.set(Calendar.SECOND, second);

	    return(cal.getTime());
	}
	
	public static Date setDate(Date date, int year, int month, int day){
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
	    cal.set(Calendar.YEAR, year);
	    cal.set(Calendar.MONTH, month);
	    cal.set(Calendar.DAY_OF_MONTH, day);

	    return(cal.getTime());
	}
	
	public static Date setTimeInMillis(long milliSecs){
		Calendar cal = Calendar.getInstance();
		
	    cal.setTimeInMillis(milliSecs);

	    return(cal.getTime());
	}
	
	
	
	public static int getYear(Date date){
	
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.YEAR));
	}
	public static int getMonth(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.MONTH));
	}
	public static int getDayOfMonth(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.DAY_OF_MONTH));
	}
	public static int getHourOfDay(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.HOUR_OF_DAY));
	}
	public static int getMinute(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.MINUTE));
	}
	public static int getSecond(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.get(Calendar.SECOND));
	}
	public static long getTimeInMillis(Date date){
		
		Calendar cal = Calendar.getInstance();
		if(date != DataConvert.DATENULL){
			cal.setTime(date);
		}	
		
		return(cal.getTimeInMillis());
	}	

	public static int stringToInt(String pString){
		// Method will throw an exception if it can't convert
		return Integer.valueOf(pString);
	}
	public static String toUpperCase(String pString){
		// Method will throw an exception if it can't convert
		return pString.toUpperCase(Locale.UK);
	}
	public  enum DecimalFormats {
		TWODIGITS,					
		FOURDIGITS,
		FIVEDIGITS
	}
	public static String doubleToDisplayFormat(Double pValue){
		String sValue = "";
		DecimalFormat numberFormat = new DecimalFormat(".00");

		sValue =  numberFormat.format(  pValue/100); 
		
		return sValue;
	}
	public static String intToDisplayFormat(int pValue, DecimalFormats pFormat){
		String sValue = "";
		DecimalFormat numberFormat;

		switch (pFormat){
		case TWODIGITS:
			numberFormat = new DecimalFormat("00");
			sValue =  numberFormat.format(  pValue/100); 
			break;
		case FOURDIGITS:
			numberFormat = new DecimalFormat("0000");
			sValue =  numberFormat.format( pValue); 
			break;
		case FIVEDIGITS:
			numberFormat = new DecimalFormat("00000");
			sValue =  numberFormat.format( pValue); 
			break;
		}
		
		return sValue;
	}

}
