package com.example.twolibs.SupportBL;

import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;


public class GenericManager {
	private static String CLASS_NAME = "GenericManager";  // Used for tracing
	
	// 
	// Standard response for a call
	//
	public static class STDResponse  {
		public Response result = Response.OK;		// The basic response
		public String extra = "";	// A textual description of the result
		public String trace = "";   // Trace data for the call
	}
	public enum Response {
		OK,
		Error
	}

	// 
	// DomainState represents the status of a business domain
	// This will be reflected in the menu buttons
	// 
	public enum MenuState {
		UNKOWN,		// Domain status has not been checked
		NORMAL,		// Domain is in a normal state
		NOTIFY, 	// The Domain needs some action to be performed
		WARNING, 	// The Domain needs urgent action
		ERROR, 		// The Domain is broken
	}
	
	
	public static class DomainStatusResponse extends STDResponse {
		public MenuState status = MenuState.NORMAL;
		public String shortDescrition = "";
	}

	// 
	// This is a generic Manager class
	// The methods on this class should be overridden by any manager
	//
	public static DomainStatusResponse checkStatus(){
		final String FUNC_NAME = "checkStatus"; 	   	
    	// 
    	// This method should set the status of the manager and a brief
		// label for reporting
		// 
		
		TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
				Category.ERROREXIT, "BASE METHOD NOT OVERRIDDEN", 0);
		
		DomainStatusResponse resp = new DomainStatusResponse();

		resp.status = MenuState.ERROR;
		resp.shortDescrition = "Undefined";
   
       return resp;
	}

	public static void handleEvent(String pSource, String pEventType, String pData){
		final String FUNC_NAME = "handleEvent"; 	  
		//
		// Overrides GenericMaanger
    	// 
    	// This method should set register that a refresh is required of the 
		// DataGroup 
		// 
		
		TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
				Category.ERROREXIT, "BASE METHOD NOT OVERRIDDEN", 0);
		
  
       return ;
	}
	
}
