package com.example.twolibs.SupportBL;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DataTransferBL.DataTransferManager.FileType;
import com.example.twolibs.DutyBL.DutyTaskType;

import android.util.Log;

public class TraceHandler {
	private static String CLASS_NAME = "TraceHandler";  // Used for tracing
	
	// The TraceHander provides a mechanism for managing logging of trace information
	// to files that can then be uploaded for diagnostics
	//
	// Dummy awaiting STAR trace port
	//
    private static OutputStreamWriter  file = null; // Trace file
     

	public enum Category {
	    ERROREXIT,  ENTRY, EXIT, GUI 
	}

	public enum  TraceLevel {
	    ERROR,  WARNING, DEBUG 
	}
	
	public static void startTrace(){
		final String FUNC_NAME = "startTrace"; 
   	
	// 
	// Open the trace file
	// 
	// 
		Log.e(CLASS_NAME  , FUNC_NAME + " ENTRY");	

		String traceFile = DataTransferManager.getFileName(FileType.TRACELOG);
		try {
			file =  new OutputStreamWriter (new FileOutputStream(traceFile));
			file.write("TRACE STARTED");
			file.flush();
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			Log.e(CLASS_NAME  , e.getMessage());
		}

		
	}
		
	public static void Trace(TraceLevel pTraceLevel , 
            String pClassName , 
            String pFuncName ,
            Category pCategory, 
            String pDetails, 
            int pTruncateToChars){
		
		StringBuilder msg = new StringBuilder(1024);
		msg.append(pFuncName);
		msg.append(":");
		if(pCategory == Category.GUI){
			msg.append(">>>");
		}
		
		msg.append(pCategory);
		if(pTruncateToChars > 0){
			msg.append(pDetails.substring(1, Math.min(pTruncateToChars, pDetails.length())));
		} else {
			msg.append(pDetails);
		}
		switch(pTraceLevel) {
   		case ERROR:  
   			Log.e(pClassName  , msg.toString());
   			if(file != null){
   				try {
					file.write(msg.toString());
					file.flush();
				} catch (IOException e) {
					// ignore
				}
   			}
   			return ;
   		case WARNING:  
   			Log.w(pClassName  , msg.toString());
   			if(file != null){
   				try {
					file.write(msg.toString());
					file.flush();
				} catch (IOException e) {
					// ignore
				}
   			}
   			return ;
  		case DEBUG:  
   			Log.d(pClassName  , msg.toString());
   			if(file != null){
   				try {
					file.write(msg.toString());
					file.flush();
				} catch (IOException e) {
					// ignore
				}
   			}
  			return ;

		}
		return ;
 
	}
}
