package com.example.twolibs.SupportGUI;

import java.util.Date;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.TimeTableGUI.TimeTableCriteria;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;


public class ClockPicker extends Activity {
		
		Activity activity;
		int dayhours = 0;
		int lastHours = 0;
		
		 public void onCreate(Bundle savedInstanceState)
		   {
		      super.onCreate(savedInstanceState);
			  setContentView(R.layout.activity_time);

			  setTitle(" Time");
			
				
	       	  final AppContext bb  = (AppContext)getApplicationContext();
		      activity = this.getParent();
	       	 
		      if(bb.getSearchDirection() == 0){
		    	  RadioButton cmdDepart = (RadioButton) findViewById(R.id.cmdDepart);
		    	  cmdDepart.setChecked(true);
		      } else {
		    	  RadioButton cmdArrive = (RadioButton) findViewById(R.id.cmdArrive);
		    	  cmdArrive.setChecked(true);
		    	  
		      };
		      
		      
		      
		      // Set time
				TextView txtTime = (TextView) findViewById(R.id.txtTime);
	
				Date searchDate = bb.getSearchDate();
        	    int hours = DataConvert.getHourOfDay(searchDate);
				int minutes =DataConvert.getMinute(searchDate);
				
				if (hours > 12){
					dayhours = 12;
				} else {
					 dayhours = 0;
				}
				
		        ImageView imh = (ImageView) findViewById(R.id.clockhour);
		        lastHours = hours;
		        imh.setImageLevel(hours);

		        ImageView imm = (ImageView) findViewById(R.id.clockminute);
		        imm.setImageLevel(minutes / 5);

    			txtTime.setText(DataConvert.displayTextTime(searchDate));

		        Button cmdSet = (Button)findViewById(R.id.cmdSet);
		        cmdSet.setOnClickListener(new OnClickListener() {  
					
					public void onClick(View view) {  
				
						dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN,	KeyEvent.KEYCODE_BACK));
						dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
					}  
					
				
				}); 
		        
		        FrameLayout mFrameHour = (FrameLayout) findViewById(R.id.clockframehour);
		        mFrameHour.setOnTouchListener(new OnTouchListener() {

		            @Override
		            public boolean onTouch(View v, MotionEvent event) {
		                
		                ImageView img = (ImageView)findViewById(R.id.clockhour);

		                int[] viewCoordsV = new int[2];
		                v.getLocationOnScreen(viewCoordsV);
		                //Log.e("vvv", "(" + viewCoordsV[0] + "," + viewCoordsV[1] + ")" );
		                
		                // Get the touch location
		                double ex = event.getX() - 120; //TODO how to calculate this properly
		                double ey = event.getY() - 0;
		                //Log.e("eee", "(" + ex + "," + ey + ")" );
		                
		                // Clip the location by the image size
		                if( ex > img.getWidth()) {
		                	ex = img.getWidth();
		                } else if (ex < 0) {
		                	ex = 0;
		                }
		                
		                if( ey > img.getHeight()) {
		                	ey = img.getHeight();
		                } else if (ex < 0) {
		                	ey = 0;
		                }
		                
		                // Calculate the co-ordinates and normalise to 0-1
		                double x =0.5 -  ex / img.getWidth();
		                double y = 0.5 - ey / img.getWidth();
		                
		                
		                // Convert to polar
		                double theta = Math.atan2(y,x);   // Compute the angle
		                double radius = Math.hypot(x,y);      // Compute the distance
		               
		                
		                // Calculate the hour from the angle
		                int iHour = 0;       
		                
		                iHour = iHour + (int)((((theta +1.6 * Math.PI) / (Math.PI * 2))) * 12 );
		                if(iHour > 12){
		                	iHour = iHour -12;
		                }
		                
		                boolean bSetTime = false;
		                if (radius > 0.55){
		                	if(iHour== 7 || iHour ==8 ){
		                		dayhours = 0;
		                	}
		                	if(iHour== 4 || iHour ==5 ){
		                		dayhours = 12;
		                	}
		                } else {
		                	bSetTime = true;
		                } 
		                
		                if (bSetTime==false){
		                	iHour = lastHours; 
		                	if(iHour > 12){
		                		iHour = iHour - 12;
		                	}
		                }
		                iHour = iHour + dayhours;
		                
		                // Adjust for inner or outer ring
		                //if(radius < 0.35) {
		                //	iHour = iHour + 12;
		                //}
		                
		                // set the display
		                img.setImageLevel(iHour);            	
				        lastHours = iHour;

		                //TextView tv =  (TextView) findViewById(R.id.notes);	                
		                //tv.setText("e(" +  (int)event.getX() + " " + (int)event.getY() + ")" + "   r(" + theta + "," + radius + ")" + "  h" + iHour + "p(" + x + "," + y + ")" +"size(" + img.getWidth() + "," + img.getHeight() + ")");
	
		        		Date searchDate = bb.getSearchDate();
		        		int minute = DataConvert.getMinute(searchDate);
		        		 				   
		        		bb.setSearchDate(DataConvert.setTime(searchDate, iHour, minute, 0));
		        		
		    			TextView txtTime = (TextView) findViewById(R.id.txtTime);
		    			txtTime.setText(DataConvert.displayTextTime(bb.getSearchDate()));
		    			
		                return true;

		            }
		        });
		 

		        
		        FrameLayout mFrameMin = (FrameLayout) findViewById(R.id.clockframeminute);
		        mFrameMin.setOnTouchListener(new OnTouchListener() {

		            @Override
		            public boolean onTouch(View v, MotionEvent event) {
		                
		                ImageView imm = (ImageView)findViewById(R.id.clockminute);
		                
		                int[] viewCoordsV = new int[2];
		                v.getLocationOnScreen(viewCoordsV);
		                //Log.e("vvv", "(" + viewCoordsV[0] + "," + viewCoordsV[1] + ")" );
		                
		                // Get the touch location
		                double ex = event.getX() - 120; //TODO how to calculate this properly
		                double ey = event.getY() - 0;
		                
		                // Clip the location by the image size
		                if( ex > imm.getWidth()) {
		                	ex = imm.getWidth();
		                } else if (ex < 0) {
		                	ex = 0;
		                }
		                
		                if( ey > imm.getHeight()) {
		                	ey = imm.getHeight();
		                } else if (ex < 0) {
		                	ey = 0;
		                }
		                
		                // Calculate the co-ordinates and normalise to 0-1
		                double x =0.5 -  ex / imm.getWidth();
		                double y = 0.5 - ey / imm.getHeight();
		                
		                
		                // Convert to polar
		                double theta = Math.atan2(y,x);   // Compute the angle
		                double radius = Math.hypot(x,y);      // Compute the distance
		                		  
		                
		                // Calculate the hour from the angle
		                int iMinute = 0;                
		                iMinute = iMinute + (int)((((theta +1.6 * Math.PI) / (Math.PI * 2))) * 12 );
		                if(iMinute > 12){
		                	iMinute = iMinute -12;
		                }
		                if (iMinute == 12){
		                	iMinute = 0;
		                }
		                
		                // set the display
		                imm.setImageLevel(iMinute);            	

		        		Date searchDate = bb.getSearchDate();
		        		int hour = DataConvert.getHourOfDay(searchDate);
		        		 				   
		        		bb.setSearchDate(DataConvert.setTime(searchDate, hour,  iMinute * 5, 0));
		        		
		    			TextView txtTime = (TextView) findViewById(R.id.txtTime);
		    			txtTime.setText(DataConvert.displayTextTime(bb.getSearchDate()));
		    			
		                //TextView tv =  (TextView) findViewById(R.id.notes);		                
		                //tv.setText("e(" +  (int)event.getX() + " " + (int)event.getY() + ")" + "   r(" + theta + "," + radius + ")" + "  m" + iMinute + "p(" + x + "," + y + ")" +"size(" + imm.getWidth() + "," + imm.getHeight() + ")");
		   
		                return true;

		            }
		        });  
		   }
		    @Override
		    public Intent getParentActivityIntent() {

		    	Intent newIntent = null;

		    	
		    	String strDirection = getIntent().getStringExtra("search");
		    	if (strDirection.equals("fares")){
			    	newIntent = new Intent(getApplicationContext(), FaresCriteria.class); 
		    	} else {
			    	newIntent = new Intent(getApplicationContext(), TimeTableCriteria.class); 
		    	}
		          
		        return newIntent;
		          
		     }

		    public void onArriveDepartClicked(View view) {
				AppContext bb = (AppContext) getApplicationContext();

				// Is the button now checked?
				boolean checked = ((RadioButton) view).isChecked();
				// Check which radio button was clicked
				if (view.getId() == R.id.cmdDepart) {
					if (checked) {
						bb.setSearchDirection(0);
					}
				} else {
					if (view.getId() == R.id.cmdArrive) {
						if (checked) {
							bb.setSearchDirection(1);
						}
					}
				}
			}
}
