package com.example.twolibs.TimeTableBL;

import java.io.Serializable;
import java.util.ArrayList;

import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class TTJourney implements Serializable {
	private static String CLASS_NAME = "TTJourney";  // Used for tracing
	
	private int		jy_numlegs;
	private ArrayList<TTLeg>	jy_legs = new  ArrayList<TTLeg>();					/* an array of leg pointers */
	private int		jy_overtakentrainlevel;		/* 1,2...	*/	

		
	//	#define JO_TARGET 1						/* bit values for journeystatus */
	//	#define JO_EQUITRAIN 2
	//	#define JO_OVERTAKEN 4
	//	#define JO_DOZYTRAIN 8
	//	#define JO_UNACCEPTABLE_DELAY 16		
	//	#define JO_INCLUDES_STP_LEG 32
	

	private int jy_journeystatus;			/* bit significant */
	private int jy_jst;
	private String jy_NRSbreak_leg = "";

	private int		jy_restartsequence;			/* for restart on specific journey 
											 * only set by successful 
											 * SC_SEARCHTYPE_RJAP 
											 */

	/* following fields not used by RJIS */
	//	#define MAP_ALLOC_INC 100
	//	#define MAP_CHANGE 0x30
	//	#define MAP_JOIN 0x20
	//	#define MAP_SPLIT 0x10
	//	#define MAP_VIA 0x40
	//	#define MAP_STOPAT 0x80

	private String	jy_mapstring = "";	/* 3bytes CRS 1byte status */
	private int		jy_mapstringsize;

	private int		jy_resultsequence;
	private int		jy_firstpassstacksize;
	private int		jy_finalpassstacksize;
	
	public int getJy_numlegs() {
		return jy_numlegs;
	}
	public void setJy_numlegs(int jy_numlegs) {
		this.jy_numlegs = jy_numlegs;
	}
	public ArrayList<TTLeg> getJy_legs() {
		return jy_legs;
	}
	public void setJy_legs(ArrayList<TTLeg> jy_legs) {
		this.jy_legs = jy_legs;
	}
	public int getJy_overtakentrainlevel() {
		return jy_overtakentrainlevel;
	}
	public void setJy_overtakentrainlevel(int jy_overtakentrainlevel) {
		this.jy_overtakentrainlevel = jy_overtakentrainlevel;
	}
	public int getJy_journeystatus() {
		return jy_journeystatus;
	}
	public void setJy_journeystatus(int jy_journeystatus) {
		this.jy_journeystatus = jy_journeystatus;
	}
	public int getJy_jst() {
		return jy_jst;
	}
	public void setJy_jst(int jy_jst) {
		this.jy_jst = jy_jst;
	}
	public String getJy_NRSbreak_leg() {
		return jy_NRSbreak_leg;
	}
	public void setJy_NRSbreak_leg(String jy_NRSbreak_leg) {
		this.jy_NRSbreak_leg = jy_NRSbreak_leg;
	}
	public int getJy_restartsequence() {
		return jy_restartsequence;
	}
	public void setJy_restartsequence(int jy_restartsequence) {
		this.jy_restartsequence = jy_restartsequence;
	}
	public String getJy_mapstring() {
		return jy_mapstring;
	}
	public void setJy_mapstring(String jy_mapstring) {
		this.jy_mapstring = jy_mapstring;
	}
	public int getJy_mapstringsize() {
		return jy_mapstringsize;
	}
	public void setJy_mapstringsize(int jy_mapstringsize) {
		this.jy_mapstringsize = jy_mapstringsize;
	}
	public int getJy_resultsequence() {
		return jy_resultsequence;
	}
	public void setJy_resultsequence(int jy_resultsequence) {
		this.jy_resultsequence = jy_resultsequence;
	}
	public int getJy_firstpassstacksize() {
		return jy_firstpassstacksize;
	}
	public void setJy_firstpassstacksize(int jy_firstpassstacksize) {
		this.jy_firstpassstacksize = jy_firstpassstacksize;
	}
	public int getJy_finalpassstacksize() {
		return jy_finalpassstacksize;
	}
	public void setJy_finalpassstacksize(int jy_finalpassstacksize) {
		this.jy_finalpassstacksize = jy_finalpassstacksize;
	}
	public int setJy_add_leg(TTLeg objLeg) {
		jy_legs.add(objLeg);
		return jy_legs.size();
		
	}
	public void setJy_NRSbreak_leg(char jy_NRSbreak_leg){
		// convert char to string
		this.jy_NRSbreak_leg = String.valueOf(jy_NRSbreak_leg);
	}
	public ArrayList<String>  getStopsNLC(TTJourney pJny){
		// 
		// Retrieve a list of NLCs for the stopping pattern
		//
		final String FUNC_NAME = "getStopsNLC"; 	   	
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);

     	ArrayList<String> stops = new ArrayList<String>();
    	String CRSCode;

    	Location loc;
    	for(TTLeg objLeg : pJny.getJy_legs()){

    		CRSCode = objLeg.getLeg_origin();
    		loc = Location.getLocationByCRS(CRSCode);
    		
     		if(loc != null){
     			stops.add(loc.getNLC());
     		}
     		
         	for(TTStop objStop : objLeg.getPassstops()){
         		CRSCode = objStop.getPse_station();
        		loc = Location.getLocationByCRS(CRSCode);

         		if(loc != null){
         			stops.add(loc.getNLC());
         		}
         	}
         	
    		CRSCode = objLeg.getLeg_destination();
    		loc = Location.getLocationByCRS(CRSCode);
    		
     		if(loc != null){
     			stops.add(loc.getNLC());
     		}
     	} 
   	    	
    	return stops;
	}
}
