package com.example.twolibs.TimeTableBL;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.example.twolibs.SupportBL.DataConvert;


public class TTLeg implements Serializable {
	
	private int		leg_type;						/* 0 = timetabled, 1 = fixed */
	private int		leg_mode;						/* 0 = train, 1 = ... (SVCMODE_...) */
	private String	leg_origin="";					    /* null terminated CRS code */
	private String	leg_destination="";				/* null terminated CRS code */
	private int		leg_duration;					/* minutes */
	private int		leg_changetimeorigin;			/* minutes */
	private int		leg_changetimedestination;		/* minutes */	
	/* following fields for timetable legs only */
	private Date	leg_departs;				    /* ccyymmddhhmm null terminated*/
	private Date	leg_arrives;				    /* ccyymmddhhmm null terminated*/
	private String	leg_trainorigin="";				/* null terminated CRS code */
	private String	leg_traindeparts="";				/* hhmm null terminated*/
	private String	leg_traindestination="";			/* null terminated CRS code */
	private String	leg_trainarrives="";				/* hhmm null terminated*/
	private int		leg_bhx;						/* 0 = runs on Bank Holiday, 1 otherwise */
	private String	leg_daysrunning="";				/* 1 = runs, order = MTWTFSS */
	private String	leg_primarytoc="";					/* null terminated TOC code */
	private String	leg_secondarytoc="";				/* null terminated TOC code */
	private int		leg_reservable;					/* RESERVE_... */
	/* Reservable 
	 LG_RESERVE_MANDATORY		1
	 LG_RESERVE_ADVISED			2
	 LG_RESERVE_POSSIBLE			3
	 LG_RESERVE_NOT_POSSIBLE		4
	 LG_RESERVE_CYCLE_MAND		5 */
	
	private String	leg_catering="";					/* up to 4 catering codes, null terminated */
	private int		leg_seats;						/* SEATS_... */
	private int		leg_sleepers;					/* SLPR_... */
	private Date	leg_schedulestartdate;			/* ccyymmdd */
	private Date	leg_scheduleenddate;			/* ccyymmdd */
	private String	leg_stocktype="";					/* 3 character stock code */
	private String	leg_sector="";						/* single character sector code */
	private String	leg_servicebrand="";				/* single character brand code */
	private String	leg_trainuid="";					/* up to 7 characters, Train UID */
	
	private List<String> leg_signature =  new ArrayList<String>();					/* [MAX_TRAINS_PER_LEG][10]  for retrieval of the stopping pattern later */
	private int		leg_trainid;						/* not used by RJIS */
	private int		leg_trainsplits;				/* 0 = it doesnt, 1 = it splits */
	private int		leg_numpassstops;				/* number of pass/stop events */

	private List<TTStop> passstops =  new ArrayList<TTStop>();			/* an array of pass stop even pointers */

	/* the first 3 fields are derived from the 'retail trainID' supplied by CIF 
	 * and together constitute the 8 character 'retail trainID' */
	private String	leg_retailTOC="";				/* char TOC[2]; */
	private String	leg_retailtrain="";				/* char train[4]; */
	private String	leg_retailportion="";				/* char portion[2]; */
	/* this field is generated by Jett and if not null 
	 * will contains a CRS code of the station where the reservation 
	 * request to NRS should be split */
	private String	leg_retailsplitfornrsat="";			/* char splitfornrsat[4]; */
	/* the first 3 fields are derived from the 'retail trainID' supplied by CIF 
	 * and together constitute the 8 character 'retail trainID' */
	private String	leg_spare_retailTOC="";				/* char TOC[2]; */
	private String	leg_spare_retailtrain="";				/* char train[4]; */
	private String	leg_spare_retailportion="";				/* char portion[2]; */	/* this field is generated by Jett and if not null 
	 * will contains a CRS code of the station where the reservation 
	 * request to NRS should be split */
	
	private String	leg_spare_retailsplitfornrsat;			/* char splitfornrsat[4]; */
	
	
	public int getLeg_type() {
		return leg_type;
	}
	public void setLeg_type(int leg_type) {
		this.leg_type = leg_type;
	}
	public int getLeg_mode() {
		return leg_mode;
	}
	public void setLeg_mode(int leg_mode) {
		this.leg_mode = leg_mode;
	}
	public String getLeg_origin() {
		return leg_origin;
	}
	public void setLeg_origin(String leg_origin) {
		this.leg_origin = leg_origin;
	}
	public String getLeg_destination() {
		return leg_destination;
	}
	public void setLeg_destination(String leg_destination) {
		this.leg_destination = leg_destination;
	}
	
	public int getLeg_duration() {
		return leg_duration;
	}
	public void setLeg_duration(int leg_duration) {
		this.leg_duration = leg_duration;
	}
	public int getLeg_changetimeorigin() {
		return leg_changetimeorigin;
	}
	public void setLeg_changetimeorigin(int leg_changetimeorigin) {
		this.leg_changetimeorigin = leg_changetimeorigin;
	}
	public int getLeg_changetimedestination() {
		return leg_changetimedestination;
	}
	public void setLeg_changetimedestination(int leg_changetimedestination) {
		this.leg_changetimedestination = leg_changetimedestination;
	}
	public Date getLeg_departs() {
		return leg_departs;
	}
	public String getLeg_departsTime() {
		return dateToTime(leg_departs);
	}	
	public void setLeg_departs(Date leg_departs) {
		this.leg_departs = leg_departs;
	}
	public Date getLeg_arrives() {
		return leg_arrives;
	}
	public String getLeg_arrivesTime() {
		return dateToTime(leg_arrives);
	}
	public void setLeg_arrives(Date leg_arrives) {
		this.leg_arrives = leg_arrives;
	}
	public String getLeg_trainorigin() {
		return leg_trainorigin;
	}
	public void setLeg_trainorigin(String leg_trainorigin) {
		this.leg_trainorigin = leg_trainorigin;
	}
	public String getLeg_traindeparts() {
		return leg_traindeparts;
	}
	public void setLeg_traindeparts(String leg_traindeparts) {
		this.leg_traindeparts = leg_traindeparts;
	}
	public String getLeg_traindestination() {
		return leg_traindestination;
	}
	public void setLeg_traindestination(String leg_traindestination) {
		this.leg_traindestination = leg_traindestination;
	}
	public String getLeg_trainarrives() {
		return leg_trainarrives;
	}
	public void setLeg_trainarrives(String leg_trainarrives) {
		this.leg_trainarrives = leg_trainarrives;
	}
	public int getLeg_bhx() {
		return leg_bhx;
	}
	public void setLeg_bhx(int leg_bhx) {
		this.leg_bhx = leg_bhx;
	}
	public String getLeg_daysrunning() {
		return leg_daysrunning;
	}
	public void setLeg_daysrunning(String leg_daysrunning) {
		this.leg_daysrunning = leg_daysrunning;
	}
	public String getLeg_primarytoc() {
		return leg_primarytoc;
	}
	public void setLeg_primarytoc(String leg_primarytoc) {
		this.leg_primarytoc = leg_primarytoc;
	}
	public String getLeg_secondarytoc() {
		return leg_secondarytoc;
	}
	public void setLeg_secondarytoc(String leg_secondarytoc) {
		this.leg_secondarytoc = leg_secondarytoc;
	}
	public int getLeg_reservable() {
		return leg_reservable;
	}
	public void setLeg_reservable(int leg_reservable) {
		this.leg_reservable = leg_reservable;
	}
	public String getLeg_catering() {
		return leg_catering;
	}
	public void setLeg_catering(String leg_catering) {
		this.leg_catering = leg_catering;
	}
	public int getLeg_seats() {
		return leg_seats;
	}
	public void setLeg_seats(int leg_seats) {
		this.leg_seats = leg_seats;
	}
	public int getLeg_sleepers() {
		return leg_sleepers;
	}
	public void setLeg_sleepers(int leg_sleepers) {
		this.leg_sleepers = leg_sleepers;
	}
	public Date getLeg_schedulestartdate() {
		return leg_schedulestartdate;
	}
	public void setLeg_schedulestartdate(Date leg_schedulestartdate) {
		this.leg_schedulestartdate = leg_schedulestartdate;
	}
	public Date getLeg_scheduleenddate() {
		return leg_scheduleenddate;
	}
	public void setLeg_scheduleenddate(Date leg_scheduleenddate) {
		this.leg_scheduleenddate = leg_scheduleenddate;
	}
	public String getLeg_stocktype() {
		return leg_stocktype;
	}
	public void setLeg_stocktype(String leg_stocktype) {
		this.leg_stocktype = leg_stocktype;
	}
	public String getLeg_sector() {
		return leg_sector;
	}
	public void setLeg_sector(String leg_sector) {
		this.leg_sector = leg_sector;
	}
	public String getLeg_servicebrand() {
		return leg_servicebrand;
	}
	public void setLeg_servicebrand(String leg_servicebrand) {
		this.leg_servicebrand = leg_servicebrand;
	}
	public String getLeg_trainuid() {
		return leg_trainuid;
	}
	public void setLeg_trainuid(String leg_trainuid) {
		this.leg_trainuid = leg_trainuid;
	}
	
	
	public int getLeg_trainid() {
		return leg_trainid;
	}
	public void setLeg_trainid(int leg_trainid) {
		this.leg_trainid = leg_trainid;
	}
	public int getLeg_trainsplits() {
		return leg_trainsplits;
	}
	public void setLeg_trainsplits(int leg_trainsplits) {
		this.leg_trainsplits = leg_trainsplits;
	}
	public int getLeg_numpassstops() {
		return leg_numpassstops;
	}
	public void setLeg_numpassstops(int leg_numpassstops) {
		this.leg_numpassstops = leg_numpassstops;
	}
	public List<TTStop> getPassstops() {
		return passstops;
	}
	public void setPassstops(List<TTStop> passstops) {
		this.passstops = passstops;
	}
	public String getLeg_retailtrainid() {
		return leg_retailTOC + leg_retailtrain + leg_retailportion;
	}

	public String getLeg_retailsplitfornrsat() {
		return leg_retailsplitfornrsat;
	}
	public void setLeg_retailsplitfornrsat(String leg_retailsplitfornrsat) {
		this.leg_retailsplitfornrsat = leg_retailsplitfornrsat;
	}
	public String getLeg_spare_retailtrainid() {
		return leg_spare_retailTOC + leg_spare_retailtrain + leg_spare_retailportion;
	}
	
	public int setLeg_add_passstop(TTStop objStop) {
		passstops.add(objStop);
		return passstops.size();
		
	}
	public void setLeg_departs(String leg_departs){
		// convert string date to date
		this.leg_departs = stringToDate(leg_departs);
	}
	public void setLeg_arrives(String leg_arrives){
		// convert string date to date
		this.leg_arrives = stringToDate(leg_arrives);
	}
	public void setLeg_schedulestartdate(String leg_schedulestartdate){
		// convert string date to date
		this.leg_schedulestartdate = stringToDate(leg_schedulestartdate);
	}
	public void setLeg_scheduleenddate(String leg_scheduleenddate){
		// convert string date to date
		this.leg_scheduleenddate = stringToDate(leg_scheduleenddate);
	}
	public void setLeg_sector(char leg_sector){
		// convert char to string
		this.leg_sector = String.valueOf(leg_sector);
	}
	public void setLeg_servicebrand(char leg_servicebrand){
		// convert char to string
		this.leg_servicebrand = String.valueOf(leg_servicebrand);
	}
	public String getLeg_retailTOC() {
		return leg_retailTOC;
	}
	public void setLeg_retailTOC(String leg_retailTOC) {
		this.leg_retailTOC = leg_retailTOC;
	}
	public String getLeg_retailtrain() {
		return leg_retailtrain;
	}
	public void setLeg_retailtrain(String leg_retailtrain) {
		this.leg_retailtrain = leg_retailtrain;
	}
	public String getLeg_retailportion() {
		return leg_retailportion;
	}
	public void setLeg_retailportion(String leg_retailportion) {
		this.leg_retailportion = leg_retailportion;
	}
	public String getLeg_spare_retailTOC() {
		return leg_spare_retailTOC;
	}
	public void setLeg_spare_retailTOC(String leg_spare_retailTOC) {
		this.leg_spare_retailTOC = leg_spare_retailTOC;
	}
	public String getLeg_spare_retailtrain() {
		return leg_spare_retailtrain;
	}
	public void setLeg_spare_retailtrain(String leg_spare_retailtrain) {
		this.leg_spare_retailtrain = leg_spare_retailtrain;
	}
	public String getLeg_spare_retailportion() {
		return leg_spare_retailportion;
	}
	public void setLeg_spare_retailportion(String leg_spare_retailportion) {
		this.leg_spare_retailportion = leg_spare_retailportion;
	}
	public List<String> getLeg_signature() {
		return leg_signature;
	}
	public void setLeg_signature(List<String> leg_signature) {
		this.leg_signature = leg_signature;
	}
	public int setLeg_add_signature(String sSignature) {
		leg_signature.add(sSignature);
		return leg_signature.size();
		
	}
	
	public Date stringToDate(String strDate){
		int year = 0;
		int month = 0;
		int dayOfMonth = 0;
		int hour = 0;
		int minute = 0;
		
		// Input format is CCYYMMDDhhmm
		Date dateRepresentation;
		if (strDate.length() <= 8){
			dateRepresentation = DataConvert.parseYYYYMMDD(strDate);
		} else {
			dateRepresentation = DataConvert.parseYYYYMMddHHmm(strDate);
		}
	    
	    return dateRepresentation;
	}
	public String getLeg_spare_retailsplitfornrsat() {
		return leg_spare_retailsplitfornrsat;
	}
	public void setLeg_spare_retailsplitfornrsat(String leg_spare_retailsplitfornrsat) {
		this.leg_spare_retailsplitfornrsat = leg_spare_retailsplitfornrsat;
	}
	
	public String dateToTime(Date dteDate){
			
		return(DataConvert.displayTextTime(dteDate));
	
	}
	
}
