package com.example.twolibs.TimeTableBL;


import java.util.ArrayList;
import java.util.Date;
import com.example.twolibs.LocationBL.Location;



public class TTSearch {

	// This class handles the timetable search interface to Jett
	private static String TAG = "TTSearch";

	public STDResponse initialise(String locfile) {

		STDResponse resp = new STDResponse();
		resp.result = -1;
		resp.trace = "Begin";

		//System.loadLibrary("twolib-second");

		String sSWVersion;
		String sDataVersion;

		byte[] bSWVersion;
		int iSWVersionSize = 3000;
		bSWVersion = StringToCBuff(iSWVersionSize, "");

		byte[] bDataVersion;
		int iDataVersionSize = 3000;
		bDataVersion = StringToCBuff(iDataVersionSize, "");

		String traceFile = "/storage/emulated/0/com.example.TwoLibs/DefaultTimetableTrace.txt";
		resp.result = ttInit2(locfile, traceFile, bSWVersion, bDataVersion);
		resp.trace = locfile + " " + resp.result + " ";

		sSWVersion = CBuffToString(iSWVersionSize, bSWVersion);
		sDataVersion = CBuffToString(iDataVersionSize, bDataVersion);

		resp.extra = sSWVersion + "!" + sDataVersion;

		return resp;
	}

	public TTSearchCriteria setupDefaults(Location objOrigin,
			Location objDestination, Date searchDate, int searchDirection,
			int changes) {
		TTSearchCriteria TTCrit = new TTSearchCriteria();
		TTCrit.getOriginCRS().add(objOrigin.getCRS());
		TTCrit.getDestinationCRS().add(objDestination.getCRS());

		TTCrit.setSc_searchtype(searchDirection); // depart

		TTCrit.setSc_targetdatetime(searchDate);
		TTCrit.setSc_earlierdatetimelimit(addMinutesToDate(-240,
				TTCrit.getSc_targetdatetime()));
		TTCrit.setSc_laterdatetimelimit(addMinutesToDate(240,
				TTCrit.getSc_targetdatetime()));
		if (TTCrit.getSc_searchtype() == 0) {
			TTCrit.setSc_cutdatetimelimit(addMinutesToDate(960,
					TTCrit.getSc_laterdatetimelimit()));
		} else {
			TTCrit.setSc_cutdatetimelimit(addMinutesToDate(-960,
					TTCrit.getSc_earlierdatetimelimit()));
		}

		TTCrit.setSc_restartinfodata(new byte[4]);
		TTCrit.setSc_originsignature(new byte[4]);
		TTCrit.setSc_destinationsignature(new byte[4]);

		TTCrit.setSc_minchangetime(-1);
		TTCrit.setSc_maxchanges(changes);
		TTCrit.setSc_numovertaken(4);
		TTCrit.setSc_changetradeoffmins(20);

		// TTCrit.ExcludeTOCs.add("SW");
		// TTCrit.ExcludeTrains.add("01234567");
		// TTCrit.sc_accomodationpreference = 3;
		// TTCrit.getStopAtsCRS().add("TWY");
		
		TTCrit.setSc_nonoptjourneyratio((float) 2.7);
		TTCrit.setSc_earlierjourneys(1);
		TTCrit.setSc_laterjourneys(2);

		return TTCrit;
	}

	public SearchResponse doSearch(TTSearchCriteria TTCrit) {

		SearchResponse resp = new SearchResponse();

		byte[] TTcritParam = TTCrit.StringToCBuff();

		byte[] bReply;
		int iReplySize = 3000;
		bReply = StringToCBuff(iReplySize, "");

		resp.trace = "Call ttsearch";

		// String fileName = Environment.getExternalStorageDirectory() +
		// "/com.example.twolibs/TT-" + TTCrit.getOriginCRS().get(0) + "-" +
		// TTCrit.getDestinationCRS().get(0) + ".txt";
		// File file = new File(fileName);

		// JETTHelper jh = ttSearch(TTcritParam, bReply);

		resp.objTTsearchResults = ttSearchOld(TTcritParam, bReply);

		resp.trace = "Search done";

		resp.trace = "Result " + resp.objTTsearchResults.getSr_Result() + " ";

		for (String sMsg : resp.objTTsearchResults.getSr_errorquals()) {
			resp.trace = resp.trace + sMsg;
		}

		resp.trace = resp.trace + resp.objTTsearchResults.getSr_numjourneys();
		resp.extra = "Found " + resp.objTTsearchResults.getSr_numjourneys();

		return resp;
	}

	private Date addMinutesToDate(int minutes, Date beforeTime) {
		final long ONE_MINUTE_IN_MILLIS = 60000;// millisecs

		long curTimeInMs = beforeTime.getTime();
		Date afterAddingMins = new Date(curTimeInMs
				+ (minutes * ONE_MINUTE_IN_MILLIS));
		return afterAddingMins;
	}

	private byte[] StringToCBuff(int iSize, String sInput) {
		byte[] bNewBuffer;

		bNewBuffer = new byte[iSize];
		int l = sInput.length();
		if (l > iSize) {
			l = iSize;
		}

		if (l > 0) {
			// Copy the string into the buffer
			int i;
			for (i = 0; i < l; i++) {
				bNewBuffer[i] = (byte) sInput.charAt(i);

			}
			// Add a null to terminate for C
			if (i >= l) {
				bNewBuffer[l - 1] = 0;
			} else {
				bNewBuffer[i] = 0;
			}

		}

		return bNewBuffer;
	}

	private String CBuffToString(int iSize, byte[] bInput) {
		StringBuilder sNew = new StringBuilder(iSize);

		char ch;
		for (int i = 0; i < iSize; i = i + 1) {
			if (bInput[i] == 0) {
				break;
			}
			ch = (char) bInput[i];
			sNew.append(ch);
		}

		return sNew.toString();
	}

	/*
	 * private Location GetLocationByCRS(BlackBoard bb,String sSearchCRS) {
	 * 
	 * 
	 * ArrayList<Location> resultList; Location objLocation;
	 * 
	 * 
	 * byte[] bResults; int iResultsSize=5000;
	 * 
	 * byte[] bTrace; int iTraceSize=10000;
	 * 
	 * String sFindTrace; String sOutput; String sProgress;
	 * 
	 * bResults = StringToCBuff(iResultsSize,""); bTrace =
	 * StringToCBuff(iTraceSize,"");
	 * 
	 * int iLocs=0; int iSearchType=1;
	 * 
	 * iLocs = bb.locSearch.findLocations(iSearchType, "", false,
	 * sSearchCRS.toUpperCase(), 1, bResults, bTrace);
	 * 
	 * sProgress = sSearchCRS + "Res " + iLocs + " ";
	 * 
	 * sFindTrace = CBuffToString(iTraceSize,bTrace);
	 * 
	 * if(iLocs <= 0){ objLocation = new Location();
	 * 
	 * } else { resultList = CBuffToLocations(iResultsSize,bResults);
	 * objLocation = resultList.get(0); sOutput =
	 * CBuffToString(iResultsSize,bResults);
	 * 
	 * 
	 * } Log.e("LOC ", sSearchCRS + sFindTrace); return objLocation; }
	 */

	private ArrayList<Location> CBuffToLocations(int iSize, byte[] bInput) {

		StringBuilder sNew = new StringBuilder(200);
		ArrayList<String> myList = new ArrayList<String>();

		ArrayList<Location> locList = new ArrayList<Location>();
		StringBuilder sField = new StringBuilder(200);

		Location loc = new Location();

		char ch;

		int iFieldNo = 0;

		for (int i = 0; i < iSize; i = i + 1) {

			if (bInput[i] == 0) {
				break;
			}
			ch = (char) bInput[i];
			switch (ch) {
			case '|':
				switch (iFieldNo) {
				case 0:
					loc.setNLC(sField.toString());
					break;
				case 1:
					loc.setCRS(sField.toString());
					break;
				case 2:
					loc.setSize(sField.toString());
					break;
				case 3:
					loc.setDescription(sField.toString());
					break;
				}
				sField = new StringBuilder(200);

				iFieldNo++;

				sNew.append(ch);
				break;

			case '\r':

				myList.add(sNew.toString());
				// myList.add(loc.strDescription);

				sNew = new StringBuilder(200);

				iFieldNo = 0;

				locList.add(loc);

				loc = new Location();

				break;
			case '\n':
				//
				break;
			default:
				//
				sNew.append(ch);

				sField.append(ch);

			}

		}

		return locList;
	}

	public native int ttInit(String filename, byte[] SWVersion,
			byte[] DataVersion);

	public native int ttInit2(String filename, String traceFile,
			byte[] SWVersion, byte[] DataVersion);

	public native TTSearchResults ttSearchOld(byte[] p_TTSearchCriteria,
			byte[] p_Reply);
	// public native JETTHelper ttSearch(byte[] p_TTSearchCriteria, byte[]
	// p_Reply);

}
