package com.example.twolibs.TimeTableBL;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.example.twolibs.SupportBL.DataConvert;

import android.R.integer;
import android.util.Log;



public class TTSearchCriteria {
	
	// Class holds search criteria and manages the translation to a buffer for Jett
	/* limits with respect to search criteria structure entries */
	public int SC_BufferSize	=	20000;

	
	public int SC_MAXORIGINS	=	50;
	public int SC_MAXDESTS		=	50;
	public int SC_MAXVIAS		=	50;
	public int SC_MAXEXCLUDES	=	50;
	public int SC_MAXSTNMCTS	=	5;
	public int SC_MAXSTOPATS	=	50;
	public int SC_MAXEXCMODES	=	10;
	public int SC_MAXPREFTOCS1	=	30;
	public int SC_MAXPREFTOCS2	=	30;
	public int SC_MAXEXCTOCS	=	30;
	public int SC_MAXEXCTRAINS	=	30;	


	private List<String> OriginCRS = new ArrayList<String>();
	private List<String> DestinationCRS = new ArrayList<String>();
	private List<String> ViasCRS = new ArrayList<String>();
	private List<String> ExcludesCRS = new ArrayList<String>();
	private int		sc_minchangetime = -1;				/* global minimum change time, -1 = not set
	otherwise >= 0 and <= 120 */
	private List<String> MinTimesCRS = new ArrayList<String>();
	private List<String> StopAtsCRS = new ArrayList<String>();
	private List<String> ExcludeMode = new ArrayList<String>();
	/*
	** preftocs1 = a list of TOC codes, for a journey to satisfy
	** this criteria all timetabled legs must be provided by one of
	** the TOCs in the list
	*/
	private List<String> PrefTOC1 = new ArrayList<String>();
	/*
	** preftocs2 = a list of TOC codes, for a journey to satisfy
	** this criteria at least one of the timetabled legs must be
	** provided by one of the TOCs in the list
	*/
	private List<String> PrefTOC2 = new ArrayList<String>();
	private List<String> ExcludeTOCs = new ArrayList<String>();
	private List<String> ExcludeTrains = new ArrayList<String>();
	
	private int		sc_maxchanges;					/* max changes -1 = default;0 = direct; 1 to 6 */

	private int		sc_searchtype;					/* depart (0) / arrive (1) */
	private Date	sc_targetdatetime;			    /* [13] ccyymmddhhmm null terminated*/
	private Date	sc_earlierdatetimelimit;	    /* [13] ccyymmddhhmm null terminated*/
	private Date	sc_laterdatetimelimit;		    /* [13] ccyymmddhhmm null terminated*/

	private int		sc_earlierjourneys;				/* number of journeys required within earlierdatetimelimit to targetdatetime */
	private int		sc_laterjourneys;				/* number of journeys required within	targetdatetime to laterdatetimelimit */

	private int		sc_numovertaken;				/* NOT RJAP number of overtaken trains to be returned 
	** within the total number of journeys 
	*/
	/* RJAP number of overtaken levels to be scanned 
	** Jett Default (5) if < 0 
	*/
	private Date	sc_cutdatetimelimit;		    /* [13] ccyymmddhhmm null terminated
	**
	** for SC_SEARCHTYPE_DEPART this defines 
	**		latest permitted arrival
	**
	** for SC_SEARCHTYPE_ARRIVE this defines
	**		earlist permitted departure
	*/

	private float	sc_nonoptjourneyratio;			/* cutoff for the time of an overtaken journey
	** as a ratio to the time for an optimum journey
	** Use Jett Default ((float)1.7) <= 0
	** Use n = (float)n > 0		
	*/
	private int		sc_nonoptjourneyslack;			/* minutes 
	** Use Jett Default (30) <= 0
	** Use n = n > 0 
	*/
	
	/* An overtaken train will not be considered 
	** if its 'total journey time' is greater than
	** 'optimum journey time' * sc _nonoptjourneyratio + sc_nonoptjourneyslack
	*/
	
	/* RJAP additions */
	/* the following only used if (sc_searchtype &= SC_SEARCHTYPE_RJAP) */
	private int		sc_restartsequence;
	private int		sc_restartinfosize;
	private byte[]	sc_restartinfodata;			/* malloced/freed by caller */
	private int		sc_progressinterval;			/* Use Jett Default (20%) < 1
	 * Use n == (1<=n<=100) */	
	
	private int		sc_changetradeoffmins;			/* Tradeoff minutes , < 0 for JETT default */	
	
	/* CATENATED SEARCH parameters; 
	* must be set to zero for normal queries
	* set as pointer to leg_signature[MAX_TRAINS_PER_LEG][10] from TTLEG for CATENATED SEARCH
	*/
	private byte[] sc_originsignature;				/* leg_signature from last leg of earlier Itinerary
	 * pointer to data returned by TTLEG.leg_signature
	 * or to copy malloced/freed by RJIS */
	private byte[] sc_destinationsignature;			/* leg_signature from first leg of later Itinerary
	 * pointer to data returned by TTLEG.leg_signature
	 * or to copy malloced/freed by RJIS */
	
	/* parameter added to steer jett for NRS */
	private int		sc_accomodationpreference;		/*	0	Search as in previous versions of Jett
	 *	1	Sleeper preferred
	 *	2	Seated preferred
	 *  4	...
	 */


	
	public byte[] StringToCBuff()
	{
		byte[] bNewBuffer = new byte[SC_BufferSize]; 
	    
	    int i;
	    int ptr=0;
	    
	    // Setup origins and time offsets
	    ptr = CopyIntToBuff(OriginCRS.size(), bNewBuffer,ptr);
	    Log.e("XXX", "Size " + OriginCRS.size());

	    if (OriginCRS.size()>0)
	    {
	    	Log.e("XXX", "CRS " + OriginCRS.get(0));
	    }

	    for(i=0; i<SC_MAXORIGINS; i++)
	    {
	    	if (i<OriginCRS.size())
	    	{
	    		ptr = CopyStringToBuff(OriginCRS.get(i),4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}	    	
	    }
	    
	    // Setup destinations and time offsets
	    ptr = CopyIntToBuff(DestinationCRS.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXDESTS; i++)
	    {
	    	if (i<DestinationCRS.size())
	    	{
	    		ptr = CopyStringToBuff(DestinationCRS.get(i),4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}	    	
	    }	
	    
	    // Setup vias
	    ptr = CopyIntToBuff(ViasCRS.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXVIAS; i++)
	    {
	    	if (i<ViasCRS.size())
	    	{
	    		ptr = CopyStringToBuff(ViasCRS.get(i),4,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    	}	    	
	    }
	    
	    // Setup excludes
	    ptr = CopyIntToBuff(ExcludesCRS.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXEXCLUDES; i++)
	    {
	    	if (i<ExcludesCRS.size())
	    	{
	    		ptr = CopyStringToBuff(ExcludesCRS.get(i),4,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    	}	    	
	    }
	    
	    ptr = CopyIntToBuff(sc_minchangetime, bNewBuffer,ptr);
	    
	    // Setup minimum interchange CRS with times
	    ptr = CopyIntToBuff(MinTimesCRS.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXSTNMCTS; i++)
	    {
	    	if (i<MinTimesCRS.size())
	    	{
	    		ptr = CopyStringToBuff(MinTimesCRS.get(i),4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}	    	
	    }

	    // Setup intermediate stops with durations
	    ptr = CopyIntToBuff(StopAtsCRS.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXSTOPATS; i++)
	    {
	    	if (i<StopAtsCRS.size())
	    	{
	    		ptr = CopyStringToBuff(StopAtsCRS.get(i),4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",4,bNewBuffer,ptr);
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}	    	
	    }
	    
	    // Setup exclude mode
	    // translate mode
	    ptr = CopyIntToBuff(ExcludeMode.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXEXCMODES; i++)
	    {
	    	if (i<ExcludeMode.size())
	    	{
	    		//ptr = CopyStringToBuff(ExcludeMode.get(i),4,bNewBuffer,ptr);
	    		int excludeMode = Integer.parseInt(ExcludeMode.get(i));
	    		ptr = CopyIntToBuff(excludeMode, bNewBuffer,ptr); //set time offsets to 0
	    	}
	    	else
	    	{
	    		ptr = CopyIntToBuff(0, bNewBuffer,ptr); //set time offsets to 0
	    	}	    	
	    }
	    
	    ptr = CopyIntToBuff(PrefTOC1.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXPREFTOCS1; i++)
	    {
	    	if (i<PrefTOC1.size())
	    	{
	    		ptr = CopyStringToBuff(PrefTOC1.get(i),3,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("   ",3,bNewBuffer,ptr);
	    	}	    	
	    }
	    
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2
	    
	    ptr = CopyIntToBuff(PrefTOC2.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXPREFTOCS2; i++)
	    {
	    	if (i<PrefTOC2.size())
	    	{
	    		ptr = CopyStringToBuff(PrefTOC2.get(i),3,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",3,bNewBuffer,ptr);
	    	}	    	
	    }

	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2

	    Log.e("XXX","Ex TOC size" + ExcludeTOCs.size() + " ptr" + ptr);
	    
	    ptr = CopyIntToBuff(ExcludeTOCs.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXEXCTOCS; i++)
	    {
	    	if (i<ExcludeTOCs.size())
	    	{
	    		ptr = CopyStringToBuff(ExcludeTOCs.get(i),3,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("    ",3,bNewBuffer,ptr);
	    	}	    	
	    }

	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 30 * 3 = 90 mod 4 = 2

	    Log.e("XXX","Ex train size" + ExcludeTrains.size() + " ptr" + ptr);
	    ptr = CopyIntToBuff(ExcludeTrains.size(), bNewBuffer,ptr);
	    for(i=0; i<SC_MAXEXCTRAINS; i++)
	    {
	    	if (i<ExcludeTrains.size())
	    	{
	    		ptr = CopyStringToBuff(ExcludeTrains.get(i),8,bNewBuffer,ptr);
	    	}
	    	else
	    	{
	    		ptr = CopyStringToBuff("        ",8,bNewBuffer,ptr);
	    	}	    	
	    }
	    
	    ptr = CopyIntToBuff(sc_maxchanges, bNewBuffer,ptr);
	    
	    ptr = CopyIntToBuff(sc_searchtype, bNewBuffer,ptr);
	    
		ptr = CopyDateToBuff(sc_targetdatetime,bNewBuffer,ptr);
		ptr = CopyDateToBuff(sc_earlierdatetimelimit,bNewBuffer,ptr);
		ptr = CopyDateToBuff(sc_laterdatetimelimit,bNewBuffer,ptr);
		
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 13 * 3 = 39 mod 4 = 1

	    ptr = CopyIntToBuff(sc_earlierjourneys, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_laterjourneys, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_numovertaken, bNewBuffer,ptr);
		ptr = CopyDateToBuff(sc_cutdatetimelimit,bNewBuffer,ptr);
		
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 13 * 1 = 13 mod 4 = 3
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 13 * 1 = 13 mod 4 = 3
	    bNewBuffer[ptr++] = 0; //Byte alignment filler 13 * 1 = 13 mod 4 = 3
		
		ptr = CopyFloatToBuff(sc_nonoptjourneyratio,bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_nonoptjourneyslack, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_restartsequence, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_restartinfosize, bNewBuffer,ptr);
	    ptr = CopyPtrToBuff(sc_restartinfodata, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_progressinterval, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_changetradeoffmins, bNewBuffer,ptr);
	    ptr = CopyPtrToBuff(sc_originsignature, bNewBuffer,ptr);
	    ptr = CopyPtrToBuff(sc_destinationsignature, bNewBuffer,ptr);
	    ptr = CopyIntToBuff(sc_accomodationpreference, bNewBuffer,ptr);

	    return bNewBuffer;
	}

	private int CopyIntToBuff(int iValue, byte[] buffer, int ptr)
	{
		ByteBuffer b = ByteBuffer.allocate(4);
		//b.order(ByteOrder.BIG_ENDIAN); // optional, the initial order of a byte buffer is always BIG_ENDIAN.
		b.putInt(iValue);

		byte[] result = b.array();
		
		buffer[ptr++]= result[3];
		buffer[ptr++]= result[2];
		buffer[ptr++]= result[1];
		buffer[ptr++]= result[0];
				
	    return ptr;
	}
	
	private int CopyFloatToBuff(float fValue, byte[] buffer, int ptr)
	{
		ByteBuffer b = ByteBuffer.allocate(4);
		//b.order(ByteOrder.BIG_ENDIAN); // optional, the initial order of a byte buffer is always BIG_ENDIAN.
		b.putFloat(fValue);

		byte[] result = b.array();
		
		buffer[ptr++]= result[3];
		buffer[ptr++]= result[2];
		buffer[ptr++]= result[1];
		buffer[ptr++]= result[0];
				
	    return ptr;
	}

	private int CopyStringToBuff(String sValue, int iSize, byte[] buffer, int ptr)
	{
		for (int i=0; i<iSize-1; i++)
		{
			buffer[ptr++]= (byte) sValue.charAt(i);
		}
		
		buffer[ptr++] = 0;
	    return ptr;
	}
	
	private int CopyPtrToBuff(byte[] bValue, byte[] buffer, int ptr)
	{
		for (int i=0; i<4; i++)
		{
			buffer[ptr++]= bValue[i];
		}
		
	    return ptr;
	}
	
	public int CopyDateToBuff(Date dValue, byte[] buffer, int ptr)
	{
		String sDate = DataConvert.displayyyyyMMddHHmm(dValue);
		
		for (int i=0; i<12; i++)
		{
			buffer[ptr++]= (byte) sDate.charAt(i);
		}
		
		buffer[ptr++] = 0;
	    return ptr;
	}

	public List<String> getOriginCRS() {
		return OriginCRS;
	}
	public void setOriginCRS(List<String> originCRS) {
		OriginCRS = originCRS;
	}

	public List<String> getDestinationCRS() {
		return DestinationCRS;
	}
	public void setDestinationCRS(List<String> destinationCRS) {
		DestinationCRS = destinationCRS;
	}

	public List<String> getViasCRS() {
		return ViasCRS;
	}
	public void setViasCRS(List<String> viasCRS) {
		ViasCRS = viasCRS;
	}

	public List<String> getExcludesCRS() {
		return ExcludesCRS;
	}
	public void setExcludesCRS(List<String> excludesCRS) {
		ExcludesCRS = excludesCRS;
	}

	public int getSc_minchangetime() {
		return sc_minchangetime;
	}
	public void setSc_minchangetime(int sc_minchangetime) {
		this.sc_minchangetime = sc_minchangetime;
	}

	public List<String> getMinTimesCRS() {
		return MinTimesCRS;
	}
	public void setMinTimesCRS(List<String> minTimesCRS) {
		MinTimesCRS = minTimesCRS;
	}

	public List<String> getStopAtsCRS() {
		return StopAtsCRS;
	}
	public void setStopAtsCRS(List<String> stopAtsCRS) {
		StopAtsCRS = stopAtsCRS;
	}

	public List<String> getExcludeMode() {
		return ExcludeMode;
	}
	public void setExcludeMode(List<String> excludeMode) {
		ExcludeMode = excludeMode;
	}

	public List<String> getPrefTOC1() {
		return PrefTOC1;
	}
	public void setPrefTOC1(List<String> prefTOC1) {
		PrefTOC1 = prefTOC1;
	}

	public List<String> getPrefTOC2() {
		return PrefTOC2;
	}
	public void setPrefTOC2(List<String> prefTOC2) {
		PrefTOC2 = prefTOC2;
	}

	public List<String> getExcludeTOCs() {
		return ExcludeTOCs;
	}
	public void setExcludeTOCs(List<String> excludeTOCs) {
		ExcludeTOCs = excludeTOCs;
	}

	public List<String> getExcludeTrains() {
		return ExcludeTrains;
	}
	public void setExcludeTrains(List<String> excludeTrains) {
		ExcludeTrains = excludeTrains;
	}

	public int getSc_maxchanges() {
		return sc_maxchanges;
	}
	public void setSc_maxchanges(int sc_maxchanges) {
		this.sc_maxchanges = sc_maxchanges;
	}

	public int getSc_searchtype() {
		return sc_searchtype;
	}
	public void setSc_searchtype(int sc_searchtype) {
		this.sc_searchtype = sc_searchtype;
	}

	public Date getSc_targetdatetime() {
		return sc_targetdatetime;
	}
	public void setSc_targetdatetime(Date sc_targetdatetime) {
		this.sc_targetdatetime = sc_targetdatetime;
	}

	public Date getSc_earlierdatetimelimit() {
		return sc_earlierdatetimelimit;
	}
	public void setSc_earlierdatetimelimit(Date sc_earlierdatetimelimit) {
		this.sc_earlierdatetimelimit = sc_earlierdatetimelimit;
	}

	public Date getSc_laterdatetimelimit() {
		return sc_laterdatetimelimit;
	}
	public void setSc_laterdatetimelimit(Date sc_laterdatetimelimit) {
		this.sc_laterdatetimelimit = sc_laterdatetimelimit;
	}

	public int getSc_earlierjourneys() {
		return sc_earlierjourneys;
	}
	public void setSc_earlierjourneys(int sc_earlierjourneys) {
		this.sc_earlierjourneys = sc_earlierjourneys;
	}

	public int getSc_laterjourneys() {
		return sc_laterjourneys;
	}
	public void setSc_laterjourneys(int sc_laterjourneys) {
		this.sc_laterjourneys = sc_laterjourneys;
	}

	public int getSc_numovertaken() {
		return sc_numovertaken;
	}
	public void setSc_numovertaken(int sc_numovertaken) {
		this.sc_numovertaken = sc_numovertaken;
	}

	public Date getSc_cutdatetimelimit() {
		return sc_cutdatetimelimit;
	}
	public void setSc_cutdatetimelimit(Date sc_cutdatetimelimit) {
		this.sc_cutdatetimelimit = sc_cutdatetimelimit;
	}

	public float getSc_nonoptjourneyratio() {
		return sc_nonoptjourneyratio;
	}
	public void setSc_nonoptjourneyratio(float sc_nonoptjourneyratio) {
		this.sc_nonoptjourneyratio = sc_nonoptjourneyratio;
	}

	public int getSc_nonoptjourneyslack() {
		return sc_nonoptjourneyslack;
	}
	public void setSc_nonoptjourneyslack(int sc_nonoptjourneyslack) {
		this.sc_nonoptjourneyslack = sc_nonoptjourneyslack;
	}

	public int getSc_restartsequence() {
		return sc_restartsequence;
	}
	public void setSc_restartsequence(int sc_restartsequence) {
		this.sc_restartsequence = sc_restartsequence;
	}

	public int getSc_restartinfosize() {
		return sc_restartinfosize;
	}
	public void setSc_restartinfosize(int sc_restartinfosize) {
		this.sc_restartinfosize = sc_restartinfosize;
	}

	public byte[] getSc_restartinfodata() {
		return sc_restartinfodata;
	}
	public void setSc_restartinfodata(byte[] sc_restartinfodata) {
		this.sc_restartinfodata = sc_restartinfodata;
	}

	public int getSc_progressinterval() {
		return sc_progressinterval;
	}
	public void setSc_progressinterval(int sc_progressinterval) {
		this.sc_progressinterval = sc_progressinterval;
	}

	public int getSc_changetradeoffmins() {
		return sc_changetradeoffmins;
	}
	public void setSc_changetradeoffmins(int sc_changetradeoffmins) {
		this.sc_changetradeoffmins = sc_changetradeoffmins;
	}

	public byte[] getSc_originsignature() {
		return sc_originsignature;
	}
	public void setSc_originsignature(byte[] sc_originsignature) {
		this.sc_originsignature = sc_originsignature;
	}

	public byte[] getSc_destinationsignature() {
		return sc_destinationsignature;
	}
	public void setSc_destinationsignature(byte[] sc_destinationsignature) {
		this.sc_destinationsignature = sc_destinationsignature;
	}

	public int getSc_accomodationpreference() {
		return sc_accomodationpreference;
	}
	public void setSc_accomodationpreference(int sc_accomodationpreference) {
		this.sc_accomodationpreference = sc_accomodationpreference;
	}

	
	
}
