/*
 * clsBulletinIdent.java
 *
 * Created on 22 November 2006, 15:35
 *
 * @author cromwellm
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 * 22.11.2006       MAC             Added equals method for comparison purposes.
 * 12.06.2007       abjm            IR12177: Signature on equals method changed
 *                                  to accept Object type parameter so that it
 *                                  truely overrides the sub class method used
 *                                  by the Vector.contains method.
 * 03.08.2007       MAC             Make class serializable.
 * 10.09.2007       Dave Oakley     Added bulletinType to attribute and toString()
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.Bulletins.BusinessClasses;

/**
 * This class identifies a specific bulletin.
 *
 */
public class clsBulletinIdent implements java.io.Serializable {
    
    private static final long serialVersionUID = -9111776715328544599L;

    /** Bulletin identifier */
    public int bulletinId;
    
    /** Bulletin title */ 
    public String bulletinTitle;
    
    /** Bulletin type */
    public String bulletinType;
    
    /** Creates a new instance of clsBulletinIdent */
    public clsBulletinIdent() {
    }
    
    /**
     * Checks if the bulletinIdent to be compared is the same as this one.
     *  
     * @param bulletinIdentObj  BulletinIdent to be compared. 
     * @return boolean          True if the bulletinIds match, else false.               
     */
     public boolean equals(Object bulletinIdentObj) {

        if  (bulletinIdentObj instanceof clsBulletinIdent) {
            clsBulletinIdent bulletinIdent = (clsBulletinIdent) bulletinIdentObj; 
            if (bulletinIdent.bulletinId == this.bulletinId) {
                return true;
            }
        }

        return false;
        
     }
     
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer("\n:clsBulletinIdent:");
        final String PREFIX = "\n        ";
        sData.append(PREFIX + "bulletinId="    + this.bulletinId +
                     PREFIX + "bulletinTitle=" + this.bulletinTitle +
                     PREFIX + "bulletinType="  + this.bulletinType);
        return sData.toString();
        
    }
    
}

