/*
 * Copyright (c) 2014 Fujitsu Services Ltd.
 */
package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import java.io.Serializable;
import java.util.List;

/**
 * This class is used to hold details of a CO2 calculation for a journey
 *
 * @author LambertonR
 *
 */
public class clsCO2CalculationResult implements Serializable {

    /**
     * Generated by Eclipse
     */
    private static final long serialVersionUID = -1982565937078717819L;

    /**
     * Indicates whether the CO2 value could be calculated for the journey
     */
    public boolean co2Calculated;

    /**
     * CO2 in kilograms per passenger kilometre for the journey
     * (if calculated successfully)
     */
    public float totalCo2Value;

    /**
     * Total journey distance in km (exc walk legs)
     */
    public float totalDistance;

    /**
     * Details of CO2 calculation for each individual leg
     */
    public List<clsCO2LegDetails> legDetails;

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("clsCO2CalculationResult [co2Calculated=");
        builder.append(co2Calculated);
        builder.append(", totalCo2Value=");
        builder.append(totalCo2Value);
        builder.append(", totalDistance=");
        builder.append(totalDistance);
        builder.append(", legDetails=");
        builder.append(legDetails);
        builder.append("]");
        return builder.toString();
    }


}
