/*
 * Copyright (c) 2014 Fujitsu Services Ltd.
 */
package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import java.io.Serializable;

/**
 * This class is used to hold details of a CO2 calculation for a journey leg
 *
 * @author LambertonR
 *
 */
public class clsCO2LegDetails implements Serializable {

    /**
     * Generated by Eclipse
     */
    private static final long serialVersionUID = -7106010354219702658L;

    /**
     * Leg reference
     */
    public int legRef;

    /**
     * Indicates whether the CO2 value could be calculated for the journey leg
     */
    public boolean co2Calculated;

    /**
     * Leg transport mode
     */
    public String serviceType;

    /**
     * Leg distance in km
     */
    public float legDistance;

    /**
     * CO2 in kilograms per passenger kilometre
     */
    public float co2Value;

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("clsCO2LegDetails [legRef=");
        builder.append(legRef);
        builder.append(", co2Calculated=");
        builder.append(co2Calculated);
        builder.append(", serviceType=");
        builder.append(serviceType);
        builder.append(", legDistance=");
        builder.append(legDistance);
        builder.append(", co2Value=");
        builder.append(co2Value);
        builder.append("]");
        return builder.toString();
    }

}
