/* Generated from Forte class clsCateringCodes in plan RJIJQEBus
   on 10/06/05 09:58:52

   Author: R.Lamberton, CRE02
   (c) Fujitsu Services 2005 
 *
 * Change history
 * When             Who             What
 * 11.10.2007       Carol Oakden    New method getTHOCodes
 * 24.10.2007       Carol Oakden    New method getCateringFacilitiesString, and updated
 *                                  the list of catering codes
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

//JP_EDIT import JourneyPlanner.Utilities.clsUtilities;



/** Holds the details of catering provided by a timetable leg.
 * This class is a direct copy of the Forte class, except that the
 * Forte methods GiveSingleCode, GiveCodeCount, GiveCodes are not used,
 * and so can be removed. */
 public class clsCateringCodes implements java.io.Serializable {

    private static final long serialVersionUID = 798881879356042320L;
    
    // Constants
    private static final String     CATERCODE_COLDBUFFET = "C";
    private static final String     CATERCODE_HOTBUFFET = "H";
    private static final String     CATERCODE_WHEELCHAIR = "P";
    private static final String     CATERCODE_RESTAURANT = "R";
    private static final String     CATERCODE_RESTR1STONLY = "F";
    private static final String     CATERCODE_SILVERSTD = "S";      // This is an old catering code, retained
                                                                    // for compatibility with supplements processing
    private static final String     CATERCODE_TROLLEY = "T";
    private static final String     CATERCODE_MEALINFIRST = "M";

    /** A list of all the catering codes associated with the journey leg. */
    private String     cateringCodes;


    // Default constructor
    public clsCateringCodes() {
        // Initialisation code goes here
        cateringCodes = "";
    }


    /** Returns TRUE if CateringCodes includes CATERCODE_ COLDBUFFET 
     *  or CATERCODE_ HOTBUFFET.
     *  Also returns a Boolean value Hot set to TRUE if CateringCodes
     * includes CATERCODE_ HOTBUFFET */
    public  clsCateringCodesHasBuffet hasBuffet() {
        clsCateringCodesHasBuffet ret = new clsCateringCodesHasBuffet();

        if (cateringCodes.indexOf(CATERCODE_HOTBUFFET) > -1) {
            ret.hasBuffet = true;
            ret.isHotBuffet = true;
        } else {
            ret.isHotBuffet = false;
            if (cateringCodes.indexOf(CATERCODE_COLDBUFFET) > -1) {
                ret.hasBuffet = true;
            } else {
                ret.hasBuffet = false;
            }
        }

        return ret;
    };

    /** Returns TRUE if CateringCodes includes CATERCODE_ PULLMAN */
    public  boolean containsCateringCode(String caterCode) {
        if (cateringCodes.indexOf(caterCode) > -1) {
            return true;
        } else {
            return false;
        }
    };
    
    
    /** Returns TRUE if CateringCodes includes CATERCODE_RESTAURANT
     *  or CATERCODE_RESTR1STONLY.
     *  Also returns a Boolean value FirstOnly set to TRUE if
     *  CateringCodes includes CATERCODE_RESTR1STONLY */
    public  clsCateringCodesHasRestaurant hasRestaurant() {
        clsCateringCodesHasRestaurant ret = new clsCateringCodesHasRestaurant();

        if (cateringCodes.indexOf(CATERCODE_RESTR1STONLY) > -1) {
            ret.hasRestaurant = true;
            ret.isFirstClassRestaurant = true;
        } else {
            ret.isFirstClassRestaurant = false;
            if (cateringCodes.indexOf(CATERCODE_RESTAURANT) > -1) {
                ret.hasRestaurant = true;
            } else {
                ret.hasRestaurant = false;
            }
        }

        return ret;
    };

    /** Returns TRUE if CateringCodes includes CATERCODE_SILVERSTD */
    public  boolean hasSilverStd() {
        if (cateringCodes.indexOf(CATERCODE_SILVERSTD) > -1) {
            return true;
        } else {
            return false;
        }
    };

    /** Returns TRUE if CateringCodes includes CATERCODE_TROLLEY */
    public  boolean hasTrolley() {
        if (cateringCodes.indexOf(CATERCODE_TROLLEY) > -1) {
            return true;
        } else {
            return false;
        }
    };
    
    /** Returns TRUE if CateringCodes includes CATERCODE_TROLLEY */
    public  boolean hasWheelchairCaterCode() {
        if (cateringCodes.indexOf(CATERCODE_WHEELCHAIR) > -1) {
            return true;
        } else {
            return false;
        }
    };

    /** Sets CateringCodes to supplied value, removing leading and trailing spaces */
    public  void setBaseCodes(String p_sCodes) {
        if (p_sCodes==null) {
            cateringCodes = "";
        } else {
            cateringCodes = p_sCodes.trim();
        }
    };


    /** Returns a string containing up to 4 catering codes */
    public  String getTHOCodes() {
        
        if (cateringCodes.length() == 0) {
            return null;
        }
        String THOCodes = (String) clsUtilities.deepClone(cateringCodes);
        if (THOCodes.length() > 4) {
            THOCodes = THOCodes.substring(0,5);
        }
        return THOCodes;
        
        
    }
    
    /** Returns TRUE if CateringCodes includes CATERCODE_ PULLMAN */
    public  String getCateringFacilitiesString() {
        String cateringFacilitiesString = "";
        boolean hadPrevious = false;
        
        if (cateringCodes != null) {
            clsCateringCodesHasRestaurant hasRestaurant = this.hasRestaurant();
            clsCateringCodesHasBuffet hasBuffet = this.hasBuffet();
            
            if (hasRestaurant.isFirstClassRestaurant) {
                cateringFacilitiesString += "Restaurant First Class Only";
                hadPrevious = true;
            } else if (hasRestaurant.hasRestaurant) {
                cateringFacilitiesString += "Restaurant";
                hadPrevious = true;
            }
            
            if (cateringCodes.indexOf(CATERCODE_MEALINFIRST) > -1)  {
                if (hadPrevious) {
                    cateringFacilitiesString += ", ";
                }
                else {
                    hadPrevious = true;
                }
                cateringFacilitiesString += "Meal included for 1st class passengers";
            }
   
            
            if (hasBuffet.hasBuffet) {
                if (hadPrevious) {
                    cateringFacilitiesString += ", ";
                }    
                else {
                    hadPrevious = true;
                }
                if (hasBuffet.isHotBuffet) {
                    cateringFacilitiesString += "Hot Buffet";
                }    
                else {
                    cateringFacilitiesString += "Cold Buffet";
                }    
            }
            
            
            if (cateringCodes.indexOf(CATERCODE_TROLLEY) > -1) {
                if (hadPrevious) {
                    cateringFacilitiesString += ", ";
                }
                cateringFacilitiesString += "Trolley";
            }
        }
        return cateringFacilitiesString;
    };
    
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        return "" + cateringCodes;
    }


}
 
