/*
 * ClsENRGPassStopEvent.java
 *
 * Created on 06 October 2005, 14:00
 *
 * @author CromwellM
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 * 20.06.2006       MAC             Fixed bugs following review QR0010.
 * 24.08.2006       Carol Oakden    Class made serializable so it can be cloned.
 * 15.06.2007       abjm            IR12184: equals() method signature changed
 *                                  from overload to override.
 */

// JP_EDIT package JourneyPlanner.RouteingGuide.BusinessClasses;
package com.example.twolibs.TimeTableBL;

/**
 * This object holds a location and the time at which the pass/stop at the location occurs.
 *
 */
public class clsENRGPassStopEvent implements java.io.Serializable {

    private static final long serialVersionUID = -2201829491525756550L;

    /** CRS code of event location. */
    public String eventLocation;
    
    /** Time of event. */
    public String eventTime;
    
    
    /** Creates a new instance of ClsENRGPassStopEvent */
    public clsENRGPassStopEvent() {
    }
    
    
    /**
     * Returns TRUE if the supplied PassStopEvent matches this one.
     * 
     * @param ENRGPassStopEventObj  Another ENRGPassStopEvent to be compared with this one. 
     * @return                      TRUE if match found.     
     */
    public  boolean equals(Object ENRGPassStopEventObj) {
    
        if  (ENRGPassStopEventObj instanceof clsENRGPassStopEvent) {
            clsENRGPassStopEvent ENRGPassStopEvent =
                                    (clsENRGPassStopEvent) ENRGPassStopEventObj;
            if (ENRGPassStopEvent == null) {
                return false;
            }
        
            if (this.eventLocation == null) {
                if (ENRGPassStopEvent.eventLocation != null) {
                    return false;
                }
            } else if (this.eventLocation.equals(ENRGPassStopEvent.eventLocation) == false) {
                return false;
            }
        
            if (this.eventTime == null) {
                if (ENRGPassStopEvent.eventTime != null) {
                    return false;
                }
            } else if (this.eventTime.equals(ENRGPassStopEvent.eventTime) == false) {
                return false;
            }

            return true;
        }
        return false;
    }
    
    
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n    ";
        sData.append(PREFIX + "eventTime=" + this.eventTime +
                     PREFIX + "eventLocation=" + this.eventLocation);
        return sData.toString();
    }
}
