/*
 * clsIJQAccomLegInfo.java
 *
 * Created on 30 March 2006, 15:37
 *
 * @author CromwellM
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 * 15.05.2006       MAC             Make class Serializable.
 * 16.05.2006       MAC             Added method getDateString. 
 * 16.05.2006       MAC             Modified method getDateString.
 * 22.05.2006       MAC             Change method name isEqual() to equals().
 * 05.10.2006       RL              Fixed NIL object exception in getNRSServiceId().
 * 14.06.2007       abjm            IR12184: equals() method signature changed
 *                                  from overload to override.
 * 16.10.2007       Rob Swain       Added fullCompare method for use in the
 *                                  clsIJQJourney equals method
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.Reservations.BusinessClasses;

import java.util.Date;
import java.util.Locale;

/**
 * Details of a leg for which accommodation is to be checked for availability.
 * An equals method is required so that objects of this type can be compared
 * (compare on LegOrigin, LegDestination, RetailTrainId).
 *
 */
public class clsIJQAccomLegInfo implements java.io.Serializable {

    private static final long serialVersionUID = -2601585580353138130L;

    /** CRS code of leg origin */
    public String legOrigin;
    
    /** CRS code of leg destination */
    public String legDestination;
    
    /** Leg departure date/time */
    public Date departureDateTime;
    
    /** Leg arrival date/time */
    public Date arrivalDateTime;
    
    /** Retail train Id */
    public String retailTrainId;

    
    /** Creates a new instance of clsIJQAccomLegInfo */
    public clsIJQAccomLegInfo() {
    }
    
    /**
     * This method allows objects of this type to be compared
     * (compare on LegOrigin, LegDestination, RetailTrainId).
     * @param IJQAccomLegInfoObj        object to be compared
     * @return boolean                  result of comparing object 
     */
    public boolean equals(Object IJQAccomLegInfoObj) {

        if  (IJQAccomLegInfoObj instanceof clsIJQAccomLegInfo) {
            clsIJQAccomLegInfo IJQAccomLegInfo = (clsIJQAccomLegInfo) IJQAccomLegInfoObj;
            if (IJQAccomLegInfo==null) {
                return false;
            }
        
            if ( this.legOrigin.equals(IJQAccomLegInfo.legOrigin) 
                    && this.legDestination.equals(IJQAccomLegInfo.legDestination)
                    && this.retailTrainId.equals(IJQAccomLegInfo.retailTrainId) ) {
                return true;
            }
        }
        return false;
    }
    
    /**
     * This method allows objects of this type to be compared.
     * It compares on LegOrigin,
     *                LegDestination,
     *                DepartureDateTime,
     *                ArrivalDateTime,
     *                RetailTrainId (allowing for null retail train ID)
     * @param IJQAccomLegInfoObj        object to be compared
     * @return boolean                  result of comparing object 
     */
    public boolean fullCompare(clsIJQAccomLegInfo IJQAccomLegInfo) {

        if ((this.legOrigin.equals(IJQAccomLegInfo.legOrigin) == false) ||
            (this.legDestination.equals(IJQAccomLegInfo.legDestination) == false) ||
            (this.departureDateTime.equals(IJQAccomLegInfo.departureDateTime) == false) ||
            (this.arrivalDateTime.equals(IJQAccomLegInfo.arrivalDateTime) == false)) {
            return false;
        }

        if (this.retailTrainId == null) {
            if (IJQAccomLegInfo.retailTrainId == null) {
                return true;
            } else {
                return false;
            }
        } else {
            if (IJQAccomLegInfo.retailTrainId == null) {
                return false;
            } else {
                return this.retailTrainId.equals(IJQAccomLegInfo.retailTrainId);
            }
        }

    }
    
    /**
     * This method returns the leg date (date portion only) as a string in the format ddmmyyyy.
     * @return LegDate              Leg departure date
     */
    public String getDateString() {
        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("ddMMyyyy", Locale.UK);
        
        String legDate =  sdf.format(departureDateTime); //(string format 'ddMMyyyy');
        return legDate;
        
    }
    
    /**
     * This method returns TRUE if all the attributes of this object are non-NIL
     *
     * @return boolean              Indicates whether all attributes are non-NIL
     */
    public boolean isComplete() {
        if ((legOrigin!=null) &&
                (legDestination!=null) &&
                (departureDateTime!=null) &&
                (arrivalDateTime!=null) &&
                (retailTrainId!=null)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * This method returns the NRS service id, truncated to 6 characters, if required
     *
     * @return              NRS retail service id
     */
    public String getNRSServiceId() {
        if ((this.retailTrainId!=null) && (this.retailTrainId.length()>6)) {
            return this.retailTrainId.substring(0,6);
        } else {
            return this.retailTrainId;
        }
    }
    
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n        ................";
        sData.append("clsIJQAccomLegInfo: ");
        sData.append(PREFIX + "legOrigin=" + this.legOrigin +
                PREFIX + "legDestination=" + this.legDestination +
                PREFIX + "departureDateTime=" + this.departureDateTime +
                PREFIX + "arrivalDateTime=" + this.arrivalDateTime +
                PREFIX + "retailTrainId=" + this.retailTrainId);
        
        return sData.toString();
    }
    
}

