/* Generated from Forte class clsIJQJourney in plan RJIJQEBus
   on 10/06/05 09:58:52

   Author: R.Lamberton, CRE02
   (c) Fujitsu Services 2005
 *
 * Change history
 * When         Who                 What
 * 08/06/2006   RS                  Added getSortKey copied from clsLocation for use on
 *                                  JQI RJAP call.
 * 27.07.2006   Dave Oakley         Correct the getSortKey() method to order departure before
 *                                  arrival.
 * 01.09.2006   MAC                 Uncommented hasEasements.
 * 22/09/2006   MAC                 Change any comments or code for time to be in 24hr format (HHmm).
 * 23.11.2006   MAC                 Made changes for bulletinIDs to use clsBulletinIdent to return bulletin titles.
 * 30/11/2006   MAC                 Amended to produce javadoc.
 * 28/02/2007   MAC                 Amended to add isSleeperLeg() method.
 * 01/03/2007   MAC                 Add hasReservableLeg() method.
 * 06/06/2007   MAC                 Add getAccomLegInfo() method.
 * 06/06/2007   MAC                 Amend RetailtRainId to be type String in getAccomLegInfo() method.
 * 02.08.2007   Rob Swain           Add canBeSplitOrRetimed() method.
 * 16.10.2007   Rob Swain           Added override of Object's equals() method.
 * 16.01.2008   Carol Oakden        Added new method giveReservableLegs
 * 04.03.2008   Mark Cromwell       IR12337 - Added new method onlyCycleLegsReservable().
 * 10.03.2008   Mark Cromwell       IR12344 - In method getAccomLegInfo() add leg origin and leg destination to identify a leg.
 * 12.04.2010   Dave Oakley         RAIL-220 New method hasFirstClassAccommodation()
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_CYCLESONLY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_NOT_POSSIBLE;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SLPR_NONE;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SVCMODE_FERRY;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

//JP_EDIT import JourneyPlanner.Bulletins.BusinessClasses.clsBulletinIdent;
//JP_EDIT import JourneyPlanner.Reservations.BusinessClasses.clsIJQAccomLegInfo;


/** Journey in enquiry interface format.
 *  This is based on the Forte class ClsIJQJourney, but does not currently
 * include attributes to contain bulletins and easements.
 *
 * Note that attributes OriginLocationCode and DestinationLocationCode which
 * used to be ClsLocationCode objects are now string attributes containing
 * the CRS code. */
public class clsIJQJourney implements java.io.Serializable {

    private static final long serialVersionUID = 4948669368890618217L;

    /** The legs of the journey, which may include both fixed and timetabled legs */
    public  Vector<clsIJQLeg>     journeyLegs;

    /** Indicates whether the journey includes a change that exceeds the permitted maximum */
    public  boolean    aChangeTakesTooLong;

    /** Indicates whether the journey has been subject to ENRG validation */
    public  boolean    ENRGCalled;

    /** Indicates whether this journey includes overtaken trains */
    public  boolean    overtaken;

    /** The arrival date/time of the journey */
    public  Date       arrival;

    /** The departure date/time of the journey */
    public  Date       departure;

    /** Journey reference */
    public  int        journeyRef;

    /** Restart sequence for subsequent searches */
    public  int        restartSequence;

    /** Elapsed time of the journey (in minutes) */
    public  int        elapsedTime;

    /** CRS code of journey origin */
    public  String     originLocationCode;

    /** CRS code of journey destination */
    public  String     destinationLocationCode;

    /** List of bulletin IDs */
    public  Vector<clsBulletinIdent>  bulletinIDs;

    /** List of Easement IDs */
    public  Vector<Integer>  easementNumbers;

    /** TRUE if the journey has manual easements */
    public  boolean          hasEasements;

    /** TRUE if the journey can be split to find alternative fares */
    public  boolean          journeyCanBeSplit;

    /** The result of calculating CO2 usage for the journey */
    public clsCO2CalculationResult co2CalculationResult;

    /** Indicates whether the journey is PEAK, OFF_PEAK or SUPER_OFF_PEAK */
    public int               peakValidityMarker;

    // Default constructor
    public clsIJQJourney() {
        // Initialisation code goes here
    }

    /** Returns a key to be used when sorting journeys into date/time order
     *
     * Format of key is yyyymmddHHmmssyyyymmddHHmmss where the first date/time
     * in the key is Departure and the second date/time in the key is Arrival */

    public String getSortKey() {
        String sortKey;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sortKey =  sdf.format(this.departure) + sdf.format(this.arrival);
        return sortKey;
    }


    /**
     * Returns an IJQAccomLegInfo object for the journey leg identified by its retail train id.
     * @param retailTrainId     Retail train id.
     * @param legOrigin         Leg origin.
     * @param legDestination    Leg destination.
     * @return accomLegInfo     Identifies the message subsystem.
     */
    public clsIJQAccomLegInfo getAccomLegInfo(
            String retailTrainId,
            String legOrigin,
            String legDestination) {

        clsIJQAccomLegInfo accomLegInfo;
        for (clsIJQLeg IJQLeg : journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg = (clsIJQTimetableLeg)IJQLeg;
                String RTID = IJQTimetableLeg.getNRSTrainId();
                if ((RTID != null)
                && (RTID.equals(retailTrainId))) {
                    // Check leg origin and destination
                    if ((IJQTimetableLeg.originLocationCode.equals(legOrigin))
                    && (IJQTimetableLeg.destinationLocationCode.equals(legDestination))) {
                        accomLegInfo = IJQTimetableLeg.getAccomLegInfo();
                        return accomLegInfo;
                    }
                }
            }
        }

        return accomLegInfo = null;

    }


    /**
     * Returns a boolean value to indicate whether the journey includes a sleeper leg.
     *
     * @return isSleeper    Indicates whether the journey is a sleeper journey.
     */
    public boolean includesSleeperLeg() {
        for (clsIJQLeg IJQLeg : journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg = (clsIJQTimetableLeg)IJQLeg;
                if (IJQTimetableLeg.sleeper != CONSTANTS_IJQE.SLPR_NONE) { //JP_EDIT
                        return true;
                }
            }
        }

        return false;

    }


    /**
     * Returns a boolean value to indicate whether the journey includes a reservable leg.
     *
     * @return reservable   Indicates whether the journey includes a reservable leg.
     */
    public boolean hasReservableLeg() {
        for (clsIJQLeg IJQLeg : journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg = (clsIJQTimetableLeg)IJQLeg;
                if (IJQTimetableLeg.canReserveAccom()) {
                    return true;
                }
            }
        }

        return false;

    }

    /**
     * Returns all the reservable legs in the journey
     *
     * @return reservableLegs   All the reservable timetable legs included in the journey.
     */
    public Vector <clsIJQTimetableLeg> giveReservableLegs() {

        Vector <clsIJQTimetableLeg> reservableLegs = new Vector <clsIJQTimetableLeg>();

        for (clsIJQLeg IJQLeg : journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg = (clsIJQTimetableLeg)IJQLeg;
                if (IJQTimetableLeg.canReserveAccom()) {
                    reservableLegs.add(IJQTimetableLeg);
                }
            }
        }

        return reservableLegs;
    }


    /**
     *  Returns a boolean value to indicate whether the journey can be split or
     *  retimed.  This is possible if the journey has >1 timetable leg.
     *  @return             Indicates whether the journey can be split or retimed
     */
    public boolean canBeSplitOrRetimed(){
        int numTTLegs = 0;
        for (clsIJQLeg IJQLeg : this.journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                numTTLegs++;
            }
        }
        if (numTTLegs > 1) {
            return true;
        } else {
            return false;
        }
    }

    /**
     *  Override of Object's equals method.
     *  @param  object      Object to be compared
     *  @return             True if equal, else false
     */
    @Override
    public boolean equals(Object object) {

        if ((object instanceof clsIJQJourney) == false) {
            return false;
        }

        // Cast the object to a clsIJQJourney
        clsIJQJourney compareJny = (clsIJQJourney) object;

        if (compareJny.journeyLegs.size() != this.journeyLegs.size()) {
            return false;
        }

        for (int i = 0; i < this.journeyLegs.size(); i++) {
            clsIJQLeg thisLeg    = this.journeyLegs.elementAt(i);
            clsIJQLeg compareLeg = compareJny.journeyLegs.elementAt(i);

            if (thisLeg instanceof clsIJQTimetableLeg) {
                if (compareLeg instanceof clsIJQFixedLeg) {
                    return false;
                }

                // Two legs are both timetable legs so check for equality
                clsIJQTimetableLeg thisTTLeg    = (clsIJQTimetableLeg) thisLeg;
                clsIJQTimetableLeg compareTTLeg = (clsIJQTimetableLeg) compareLeg;
                clsIJQAccomLegInfo thisAccomLegInfo    = thisTTLeg.getAccomLegInfo();
                clsIJQAccomLegInfo compareAccomLegInfo = compareTTLeg.getAccomLegInfo();

                if (thisAccomLegInfo.fullCompare(compareAccomLegInfo) == false) {
                    return false;
                }

            } else if (thisLeg instanceof clsIJQFixedLeg) {
                if (compareLeg instanceof clsIJQTimetableLeg) {
                    return false;
                }

                // Two legs are both fixed legs so check for equality
                clsIJQFixedLeg thisFixedLeg    = (clsIJQFixedLeg) thisLeg;
                clsIJQFixedLeg compareFixedLeg = (clsIJQFixedLeg) compareLeg;

                if ((thisFixedLeg.originLocationCode.equals(compareFixedLeg.originLocationCode) == false) ||
                    (thisFixedLeg.destinationLocationCode.equals(compareFixedLeg.destinationLocationCode) == false)) {
                    return false;
                }

            } else {
                // Shouldn't happen
                return false;
            }

        }  // End of 'for (int i = 0; i < this.journeyLegs.size(); i++)'

        // Compared all legs and they match.
        return true;
    }

    /**
     * Returns Returns true if the reservable legs in the journey allow cycle
     * reservation only.
     * @return cyclesOnly   Indicates whether the reservable legs are cycle reservation only.
     */
    public boolean onlyCycleLegsReservable() {
        int accomCount = 0;
        int cycleCount = 0;

        for (clsIJQLeg IJQLeg: journeyLegs) {
            if (IJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg = (clsIJQTimetableLeg)IJQLeg;
                if ((IJQTimetableLeg.retailTrainID != null)
                && (IJQTimetableLeg.retailTrainID.length() >0)) {
                    if (IJQTimetableLeg.reservable != CONSTANTS_IJQE.RESERVE_NOT_POSSIBLE) { // JP_EDIT
                        if (IJQTimetableLeg.reservable == CONSTANTS_IJQE.RESERVE_CYCLESONLY) { // JP_EDIT
                            cycleCount = cycleCount + 1;
                        } else {
                            accomCount = accomCount + 1;
                        }
                    }
                }
            }
        }

        if ((cycleCount > 0)
        && (accomCount == 0)) {
                return true;
        } else {
                return false;
        }
    }

    /**
     * Returns true if any of the journey legs includes first class seat or
     * sleeper accommodation.
     * @return  Indicates whether the journey has first class accommodation on
     *          one or more legs
     */
    public boolean hasFirstClassAccommodation() {
        for (clsIJQLeg eachIJQLeg : this.journeyLegs) {
            if (eachIJQLeg instanceof clsIJQTimetableLeg) {
                clsIJQTimetableLeg IJQTimetableLeg =
                        (clsIJQTimetableLeg)eachIJQLeg;
                if (IJQTimetableLeg.firstClassAvailable == true) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Used to renumber the legs in a journey after journeys have been split.
     */
    public void renumberLegs() {
        int legNo = 1;

        if ((this.journeyLegs != null) && !(this.journeyLegs.isEmpty())) {
            for (clsIJQLeg IJQLeg : this.journeyLegs) {
                IJQLeg.legRef = legNo;
                legNo ++;
            }
        }
    }

    /**
     * Returns a boolean value to indicate whether the journey includes a ferry leg.
     *
     * @return  Indicates whether the journey contains a ferry leg
     */
    public boolean includesFerryLeg() {
        if ((this.journeyLegs != null) && !(this.journeyLegs.isEmpty())) {
            for (clsIJQLeg ijqLeg : journeyLegs) {
                if (ijqLeg.serviceType == CONSTANTS_IJQE.SVCMODE_FERRY) { // JP_EDIT
                    return true;
                }
            }
        }

        return false;
    }

    /** Returns a string representation of this object, for logging purposes */
    @Override
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n    ....";
        sData.append("\n    ..JOURNEY:");
        sData.append(PREFIX + "departure=" + this.departure +
                     "\tarrival=" + this.arrival +
                     PREFIX + "journeyRef=" + this.journeyRef +
                     "\telapsedTime=" + this.elapsedTime +
                     "\trestartSequence=" + this.restartSequence +
                     PREFIX + "originLocationCode=" + this.originLocationCode +
                     "\tdestinationLocationCode=" + this.destinationLocationCode +
                     "\tbulletinIDs=" + this.bulletinIDs +
                     PREFIX + "hasEasements=" + this.hasEasements +
                     PREFIX + "easementNumbers=" + this.easementNumbers +
                     PREFIX + "aChangeTakesTooLong=" + this.aChangeTakesTooLong +
                     "\tENRGCalled=" + this.ENRGCalled +
                     "\tovertaken=" + this.overtaken +
                     PREFIX + "journeyLegs=" + this.journeyLegs +
                     PREFIX + "journeyCanBeSplit=" + this.journeyCanBeSplit +
                     PREFIX + "co2CalculationResult=" + this.co2CalculationResult +
                     PREFIX + "peakValidityMarker=" + this.peakValidityMarker);

        return sData.toString();
    }


}
