/* Generated from Forte class clsIJQTimetableLeg in plan RJIJQEBus
 * on 10/06/05 09:58:53
 *
 * Author: R.Lamberton, CRE02
 * (c) Fujitsu Services 2005
 *
 * Change history
 * When             Who             What
 * 01.03.2007       MAC             Add method canReserveAccom().
 * 25.05.2007       MAC             Add methods getNRSTrainId() and getAccomLegInfo().
 *
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_CYCLESONLY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_NOT_POSSIBLE;

import java.util.ArrayList;
import java.util.Date;

//JP_EDIT import JourneyPlanner.Reservations.BusinessClasses.clsIJQAccomLegInfo;

/** Timetable leg in enquiry interface format.
 *  This equates to the Forte class of the same name, except that attributes
 *  TrainOrigin and TrainDestination which were ClsLocationCode objects are
 *  now strings containing the CRS code. */
public class clsIJQTimetableLeg extends clsIJQLeg implements java.io.Serializable {

    private static final long serialVersionUID = 4991120762664216796L;

    /** Indicates whether the service runs on a bank holiday */
    public  boolean    BHX;

    /** Indicates whether first class accommodation is available */
    public  boolean    firstClassAvailable;

    /** Indicates whether the leg is provided by an intercity service */
    public  boolean    interCity;

    /** Leg signature */
    public  byte[]     legSignature;

    /** Indicates whether the service operates Saturdays only */
    public  boolean    SO;

    /** Indicates whether the service operates except Saturdays */
    public  boolean    SX;

    /** Indicates whether standard class accommodation is available */
    public  boolean    stdClassAvailable;

    /** Indicates whether the service splits */
    public  boolean    trainSplits;

    /** Date/time of leg arrival */
    public  Date       arrival;

    /** Date/time of leg departure */
    public  Date       departure;

    /** End date of train service */
    public  Date       CATETrainEnd;

    /** Start date of train service */
    public  Date       CATETrainStart;

    /** Indicates the type of reservations possible on the service */
    public  int        reservable;

    /** Indicates the type of seats available on the service */
    public  int        seats;

    /** Indicates whether sleeper accommodation is available on the service*/
    public  int        sleeper;

    /** Catering available on the service */
    public  clsCateringCodes     cateringCodes;

    /** The location from which the train originates - CRS code */
    public  String     trainOriginLocationCode;

    /** The final location of the train - CRS code */
    public  String     trainDestLocationCode;

    /** Markers to denote on which days the service operates */
    public  String     daysRunning;

    /** The TOC code of the TOC providing the service*/
    public  String     primaryTOC;

    /** Retail service id of service */
    public  String     retailTrainID;

    /** The TOC code of the secondary TOC */
    public  String     secondaryTOC;

    /** The sector code */
    public  String     sectorCode;

    /** Brand of train providing the service */
    public  String     serviceBrand;

    /** Stock type of train providing the service*/
    public  String     stockType;

    /** Arrival date/time of the train */
    public  String     trainArrival;

    /** Departure date/time of the train */
    public  String     trainDeparture;

    /** Train UID */
    public  String     trainUID;

    /**
     * Where a leg splits or joins, this is a list of the split/join locations
     */
    public ArrayList<clsIJQSplitJoin> splitJoinLocations;

    // Default constructor
    public clsIJQTimetableLeg() {
        // Initialisation code goes here
    }

    /**
     * Returns an indication of whether the leg is a reservable leg.
     *
     * @return reservable   Indicates whether accommodation can be reserved on the leg.
     */
    public boolean canReserveAccom() {
        if ((this.retailTrainID == null)
        || (this.retailTrainID.length() == 0)) {
            return false;
        } else if ((reservable == CONSTANTS_IJQE.RESERVE_NOT_POSSIBLE) //JP_EDIT 
        || (reservable == CONSTANTS_IJQE.RESERVE_CYCLESONLY)) { //JP_EDIT 
            return false;
        } else {
            return true;
        }

    }

    /**
     * Returns the retail train id of the journey leg, up to the first 6 chars of the id.
     * @return TrainId      Retail train id, truncated if necessary.
     */
    public String getNRSTrainId() {

        if ((retailTrainID == null)
        || (retailTrainID.length() == 0)) {
            return null;
        } else if (retailTrainID.length() <= 6) {
            return retailTrainID;
        } else {
            return retailTrainID.substring(0,6);
        }
    }

    /**
     * Returns the IJQAccomLegInfo object containing details required for
     * reservations/availability.
     * @return accomLegInfo     Accom leg info.
     */
    public clsIJQAccomLegInfo getAccomLegInfo() {

        clsIJQAccomLegInfo accomLegInfo = new clsIJQAccomLegInfo();
        accomLegInfo.legOrigin = originLocationCode;
        accomLegInfo.legDestination = destinationLocationCode;
        accomLegInfo.departureDateTime = departure;
        accomLegInfo.arrivalDateTime = arrival;
        accomLegInfo.retailTrainId = getNRSTrainId();
        return accomLegInfo;
    }

    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n    ........";
        sData.append("\n    ......TIMETABLE LEG:");
        sData.append(super.toString());
        sData.append(PREFIX + "departure=" + this.departure +
                "\tarrival=" + this.arrival +
                PREFIX + "BHX=" + this.BHX +
                "\tSO=" + this.SO +
                "\tSX=" + this.SX +
                PREFIX + "reservable=" + this.reservable +
                "\tseats=" + this.seats +
                "\tsleeper=" + this.sleeper +
                PREFIX + "firstClassAvailable=" + this.firstClassAvailable +
                "\tstdClassAvailable=" + this.stdClassAvailable +
                PREFIX + "cateringCodes=" + this.cateringCodes +
                "\tdaysRunning=" + this.daysRunning +
                "\tprimaryTOC=" + this.primaryTOC +
                "\tsecondaryTOC=" + this.secondaryTOC +
                PREFIX + "retailTrainID=" + this.retailTrainID +
                "\tintercity=" + this.interCity +
                "\tsectorCode=" + this.sectorCode +
                "\tserviceBrand=" + this.serviceBrand +
                "\tstockType=" + this.stockType +
                PREFIX + "trainSplits=" + this.trainSplits +
                "\tlegSignature=" + (this.legSignature==null ? "null" : new String(this.legSignature)) +
                PREFIX + "CATETrainStart=" + this.CATETrainStart +
                "\tCATETrainEnd=" + this.CATETrainEnd +
                PREFIX + "trainOriginLocationCode=" + this.trainOriginLocationCode +
                "\ttrainDestLocationCode=" + this.trainDestLocationCode +
                PREFIX + "trainDeparture=" + this.trainDeparture +
                "\ttrainArrival=" + this.trainArrival +
                "\ttrainUID=" + this.trainUID +
                PREFIX + "splitJoinLocations=" + this.splitJoinLocations);
        return sData.toString();
    }


}
