/**
 * Copyright (c) 2012 Fujitsu Services Ltd.
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import java.util.*;

/** Represents an Underground Leg for the external interface. */
public class clsIJQUndergroundLeg extends clsIJQFixedLeg implements java.io.Serializable {

    private static final long serialVersionUID = 3703917615233387030L;

    /** Detail entries, one for each line travelled on the underground. */
    public  ArrayList<clsUndergroundDetail>     details;

    /** List of zones travelled across all lines in the leg. */
    public  String     zones;

    /** Constructor */
    public clsIJQUndergroundLeg() {
    }

    /**
     * Retrieves the text string to display the zones travelled, in the format:
     *      "Zone x"
     *   or "Zones x-y"
     * @return      Text to display
     */
    public String getZonesText() {
        if ((zones == null) || (zones.length() < 1)) {
            return "";
        } else if (zones.length() == 1) {
            return "Zone "+zones;
        } else {
            // Locate the lowest zone & the highest zone
            int first=0, last=0, x=0;
            try {
                first = Integer.parseInt(zones.substring(0,1));
                last = Integer.parseInt(zones.substring(0,1));
            } catch (NumberFormatException nfe) {
            }

            for (int i=0; i<zones.length(); i++) {
                try {
                    x = Integer.parseInt(zones.substring(i,i+1));
                } catch (NumberFormatException nfe) {
                }
                first = Math.min(x, first);
                last = Math.max(x, last);
            }
            return "Zones "+first+"-"+last;
        }
    }

    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuilder sData = new StringBuilder();
        final String PREFIX = "\n    ";
        sData.append(PREFIX + "clsIJQUndergroundLeg:");
        sData.append(super.toString());
        sData.append(PREFIX + "details = ")        .append(this.details);
        sData.append(PREFIX + "zones = ")          .append(this.zones);

        return sData.toString();
    }


}
