/*
 * clsLegAccom.java
 *
 * Created on 30 March 2006, 14:02
 *
 * @author CromwellM
 *
 * Copyright (c) Fujitsu Services 2005.
 *
 * Change history
 * When             Who             What
 * 22.05.2006       MAC             Convert Integer attributes to int. 
 *
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.Reservations.BusinessClasses;

import java.util.Vector;

/**
 * This class holds a list of Tickets/routes to be queried on for a particular journey leg,
 * and the relevant passenger details.  This class is only used when constructing a 
 * non-together request, so it contains a single passenger set.
 *
 */
public class clsLegAccom {
    
    /** The passenger set information to be used when making the availability request */
    public clsPassengerSet paxSet;
    
    /** The accom code to be used when making the availability request */
    public String accomCode;
    
    /** The leg reference of the particular journey leg */
    public int legRef;
    
    /** Each element in this vector contains a list of tickets to be queried on for 
     * the journey leg, and the route code of the tickets. */
    public Vector <clsLegAccomTickets> legAccomTickets;

    
    /** Creates a new instance of clsLegAccom */
    public clsLegAccom() {
         legAccomTickets = new Vector <clsLegAccomTickets>();
    }
    
    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n        ........";
        sData.append("clsLegAccom: ");
        sData.append(PREFIX + "paxSet=" + this.paxSet +
                    PREFIX + "accomCode=" + this.accomCode +
                    PREFIX + "legRef=" + this.legRef +
                    PREFIX + "legAccomTickets=" + this.legAccomTickets);
                     
        return sData.toString();
    }
    
}

