/* Generated from Forte class clsLegCollection in plan RJIJQIBus
   on 10/06/05 10:00:18

   Author: R.Lamberton, CRE02
   (c) Fujitsu Services 2005
 * History:
 * When         Who     What
 * 01/09/2006   MAC     Removed comment about checking if legs should be instantiated in constructor.
 * 06.02.2013   RS      RAIL-250: Added hasUndergroundLeg() method.
 */


package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

//JP_EDIT import JourneyPlanner.IJQ.BusinessClasses.clsLegCollectionCheckResult;
import java.util.*;


/** Holds a collection of legs that form a journey.
 *  This class equates to the Forte class of the same name.  */
public class clsLegCollection implements java.io.Serializable {

    /**
     * Generated by Eclipse
     */
    private static final long serialVersionUID = 3531000867205080321L;

    /** The journey legs in the leg collection */
    public  Vector<clsLeg>     legs;

    /** Indicates whether any change between the journey legs exceeds a permitted maximum */
    public  boolean    changeTakesTooLong;

    /** Indicates whether any of the legs is provided by an overtaken train*/
    public  boolean    overtaken;

    /** Restart sequence required for making subsequent searches */
    public  int        restartSequence;


    // Default constructor
    public clsLegCollection() {
        // Initialisation code goes here
        legs = new Vector<clsLeg>();
        changeTakesTooLong = false;
        overtaken = false;
    }


    /**
     * Determines whether all the timetable legs in the leg collection
     *  are provided by one of the given TOCs.
     *
     * @param TOCCodes  A list of TOC codes against which the journey legs
     *                  in the collection are to be checked
     * @return          The results of the search.  The LegRef attribute
     *                  contains the leg reference of the first leg that is
     *                  NOT provided by one of the supplied TOCs.
     *                  The Found attribute indicates whether all the legs
     *                  are provided by the supplied TOCs
     */
    public clsLegCollectionCheckResult allLegsTOC(Vector<String> TOCCodes) {
        boolean found = false;
        clsLegCollectionCheckResult LCCR = new clsLegCollectionCheckResult();
        LCCR.found = true;
        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {
                if (leg instanceof clsTimetableLeg) {
                    clsTimetableLeg TTleg = (clsTimetableLeg) leg;
                    found = false;
                    if (TOCCodes.contains(TTleg.primaryTOC)) {
                        found = true;
                    }

                    if (found==false) {
                        LCCR.legRef = leg.legRef;
                        LCCR.found = false;
                        break;
                    }
                }
            }
        }

        return LCCR;
    }

    /**
     * Determines whether any of the timetable legs in the leg collection is
     *  provided by the given TOC.
     *
     * @param TOCCode   A TOC code against which the journey legs in the collection are to be checked
     * @return          The results of the search.  The LegRef attribute contains the leg reference
     *                  of the first leg that is provided by the supplied TOC.
     *                  The Found attribute indicates whether any leg is provided by the supplied TOC
     */
    public clsLegCollectionCheckResult hasLegTOC(String TOCCode) {
        clsLegCollectionCheckResult LCCR = new clsLegCollectionCheckResult();
        LCCR.found = false;
        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {
                if (leg instanceof clsTimetableLeg) {
                    clsTimetableLeg TTleg = (clsTimetableLeg) leg;
                    if (TTleg.primaryTOC.equals(TOCCode)) {
                        LCCR.found = true;
                        LCCR.legRef = leg.legRef;
                        return LCCR;
                    }
                }
            }
        }

        return LCCR;
    }

    /**
     * Determines whether the leg collection includes at least one timetable leg
     *
     * @return      Indicates whether the leg collection includes a timetable leg
     */
    public boolean hasTimetableLeg() {
        boolean TTLegFound = false;

        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {
                if (leg instanceof clsTimetableLeg) {
                    TTLegFound = true;
                    break;
                }
            }
        }

        return TTLegFound;
    }

    /**
     * Determines whether the leg collection includes an underground leg
     *
     * @return      Indicates whether the leg collection includes an underground leg
     */
    public boolean hasUndergroundLeg() {
        boolean UGLegFound = false;

        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {
                if (leg instanceof clsUndergroundLeg) {
                    UGLegFound = true;
                    break;
                }
            }
        }

        return UGLegFound;
    }

    /**
     * Returns the leg reference of the first leg that has the required mode
     *
     * @param serviceType   The required service type
     * @return              The results of the search.  The LegRef attribute
     *                      contains the leg reference of the first leg that
     *                      has the specified service type.
     *                      The Found attribute indicates whether at least one
     *                      of the legs has the specified service type
     */
    public clsLegCollectionCheckResult hasLegMode(int serviceType) {
        clsLegCollectionCheckResult LCCR = new clsLegCollectionCheckResult();
        LCCR.found = false;
        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {

                if (leg.serviceType==serviceType) {
                    LCCR.found = true;
                    LCCR.legRef = leg.legRef;
                    return LCCR;
                }
            }
        }

        return LCCR;
    }

    /**
     * Returns the legs that are provided by the supplied service type, or NIL if none of the legs
     * is provided by the service type
     *
     * @param serviceType   The required service type
     * @param stopAtFirst   Indicates whether the first leg with the supplied mode
     *                      should be returned, or all legs with the supplied mode
     * @return              The legs in the leg collection with the supplied mode type
     */
    public Vector<clsLeg> getLegsWithMode(int serviceType, boolean stopAtFirst) {
        Vector<clsLeg> legsForMode;
        Vector<clsLeg> modeLegs = new Vector<clsLeg>();
        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {
                if (leg.serviceType==serviceType) {
                    modeLegs.add(leg);
                    if (stopAtFirst) {
                        return legsForMode = modeLegs;
                    }
                }
            }
        }
        if (modeLegs.isEmpty()) {
                 legsForMode = null;
        } else {
                legsForMode = modeLegs;
        }
        return legsForMode;
    }

    /**
     * Returns the leg reference of the leg that includes the given location
     *  This is the first variant of this method.
     *  Note PassStopEvent attribute no longer contains a ClsLocationCode.
     *
     * @param CRSCode   The CRS code of the required location
     * @return          The results of the search.  The LegRef attribute
     *                  contains the leg reference of the first leg that
     *                  includes the specified CRS location.
     *                  The Found attribute indicates whether at least
     *                  one of the legs includes the specified location
     */
    public clsLegCollectionCheckResult hasEventLocation(String CRSCode) {
        clsLegCollectionCheckResult LCCR = new clsLegCollectionCheckResult();
        LCCR.found = false;
        LCCR.legRef = 0;
        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {

                if (leg.origin.CRSCode.equals(CRSCode)) {
                    LCCR.found = true;
                    LCCR.legRef = leg.legRef;
                    return LCCR;
                }

                if (leg.destination.CRSCode.equals(CRSCode)) {
                    LCCR.found = true;
                    LCCR.legRef = leg.legRef;
                    return LCCR;
                }

                if (leg instanceof clsTimetableLeg) {
                    clsTimetableLeg TTleg = (clsTimetableLeg) leg;

                    if (TTleg.passStop!=null) {
                        for (clsPassStopEvent pse : TTleg.passStop) {
                            if ((pse.eventLocation!=null) && (pse.eventLocation.CRSCode.equals(CRSCode))) {
                                LCCR.found = true;
                                LCCR.legRef = leg.legRef;
                                return LCCR;
                            }
                        }
                    }
                }
            }
        }

        return LCCR;
    }

    /**
     * Returns the leg reference of the leg that includes one of the given locations.
     *  This is the second variant of this method.
     *  Note PassStopEvent attribute no longer contains a ClsLocationCode
     *
     * @param CRSCodes      The CRS codes of the required locations
     * @return              The results of the search.  The LegRef attribute
     *                      contains the leg reference of the first leg that
     *                      includes one of the specified CRS locations.
     *                      The Found attribute indicates whether at least
     *                      one of the legs includes one of the specified locations
     */
    public clsLegCollectionCheckResult hasEventLocation(Vector<String> CRSCodes) {
        clsLegCollectionCheckResult LCCR = new clsLegCollectionCheckResult();
        LCCR.found = false;
        if ((this.legs!=null) && (CRSCodes!=null)) {

            for (clsLeg leg : this.legs) {
                for (String CRSCode : CRSCodes) {
                    if (leg.origin.CRSCode.equals(CRSCode)) {
                        LCCR.found = true;
                        LCCR.legRef = leg.legRef;
                        return LCCR;
                    }

                    if (leg.destination.CRSCode.equals(CRSCode)) {
                        LCCR.found = true;
                        LCCR.legRef = leg.legRef;
                        return LCCR;
                    }

                    if (leg instanceof clsTimetableLeg) {
                        clsTimetableLeg TTleg = (clsTimetableLeg) leg;

                        if (TTleg.passStop!=null) {
                            for (clsPassStopEvent pse : TTleg.passStop) {
                                if ((pse.eventLocation!=null) && (pse.eventLocation.CRSCode.equals(CRSCode))) {
                                    LCCR.found = true;
                                    LCCR.legRef = leg.legRef;
                                    return LCCR;
                                }
                            }

                        }
                    }
                }
            }
        }

        return LCCR;
    }

    /**
     * Returns the arrival time of the journey represented by the LegCollection,
     *  allowing for the last leg in the leg collection being a fixed leg
     *
     * @return      Arrival time of last leg in collection
     */
    public Date getArrival() {
        Date arrivalDateTime = null;
        int timeToAdd = 0;
        clsLeg leg;

        if (legs!=null) {
            for (int i=legs.size(); i>0; i--){      // Search backwards from last leg to first
                leg = (clsLeg) (legs.get(i-1));

                if (leg instanceof clsFixedLeg) {
                    clsFixedLeg fixedLeg = (clsFixedLeg) leg;
                    timeToAdd = timeToAdd + fixedLeg.transitTime + fixedLeg.changeTime;

                } else if (leg instanceof clsTimetableLeg) {
                    clsTimetableLeg TTLeg = (clsTimetableLeg) leg;

                    Calendar cal = Calendar.getInstance();
                    cal.setTime(TTLeg.arrival);
                    cal.add(Calendar.MINUTE,timeToAdd);
                    arrivalDateTime = cal.getTime();
                    break;
                }
            }
        }

        return arrivalDateTime;
    }

    /**
     * Returns the departure time of the journey represented by the LegCollection,
     *  allowing for the first leg in the leg collection being a fixed leg
     *  Equivalent method on the Forte object uses IntervalData to perform
     *  calculation - this specification assumes integer values containing minutes
     *
     * @return      Departure time of first leg in collection
     */
    public Date getDeparture() {
        Date departureDateTime = null;
        int timeToSubtract = 0;

        if (this.legs!=null) {
            for (clsLeg leg : this.legs) {

                if (leg instanceof clsFixedLeg) {
                    clsFixedLeg fixedLeg = (clsFixedLeg) leg;
                    timeToSubtract = timeToSubtract + fixedLeg.transitTime + fixedLeg.changeTime;

                } else if (leg instanceof clsTimetableLeg) {
                    clsTimetableLeg TTLeg = (clsTimetableLeg) leg;

                    Calendar cal = Calendar.getInstance();
                    cal.setTime(TTLeg.departure);
                    cal.add(Calendar.MINUTE,-timeToSubtract);
                    departureDateTime = cal.getTime();
                    break;
                }
            }
        }

        return departureDateTime;
    }


    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n        ........";
        sData.append(PREFIX + "changeTakesTooLong=" + this.changeTakesTooLong +
                     "\tovertaken=" + this.overtaken +
                     "\trestartSequence=" + this.restartSequence +
                     PREFIX + "legs=" + this.legs);

        return sData.toString();
    }


}
