/* Generated from Forte class clsPassStopEvent in plan RJIJQIBus
   on 10/06/05 10:00:19

   Author: R.Lamberton, CRE02
   (c) Fujitsu Services 2005

 * Change history
 * When             Who             What
 * 30.09.2009       abjm            IR12264: Made Serializable for cloning.
 * 02.01.2013       Rob Swain       RAIL-250: added activity attribute as String.
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import com.example.twolibs.LocationBL.clsLocation; // JP_EDIT
// JP_EDIT import JourneyPlanner.RouteingGuide.BusinessClasses.clsENRGPassStopEvent;

/** Holds details of a pass/stop event.
 *  This is different from the equivalent Forte object, because it
 *  does not contain ClsLocationCode attribute */
public class clsPassStopEvent implements java.io.Serializable {

    /**
     * Generated by Eclipse
     */
    private static final long serialVersionUID = -819082107042484355L;

    /** Location at which the pass/stop occurred */
    public  clsLocation eventLocation;

    /** The time at which the pass/stop occurred */
    public  String eventTime;

    /** Station at which pass/stop occurs */
    public String CRSCode;

    /** Indicates the activity at the location, eg pick up, set down, both, origin, destination */
    public String activity;

    /** The departure time associated with this pass stop event taken from the
     *  leg stopping pattern. This is used when splitting the leg for cheaper fare
     *  options processing. (hhMM format)
     */
    public String departureTime;

    /**
     * Indicates whether there is a split or join at this location.
     * 0 £ no split/join
     * 1 £ leg splits at this point
     * 2 £ leg joins at this point
     */
    public int splitJoinIndicator;

    // Default constructor
    public clsPassStopEvent() {
        // Initialisation code goes here
        eventLocation = new clsLocation();
    }

    /**
     * Returns a pass/stop event in the format suitable for use by ENRG.
     *
     * @return  ENRG version of pass/stop event
     */
    public clsENRGPassStopEvent giveENRGPassStopEvent() {
        clsENRGPassStopEvent ENRGPassStopEvent = new clsENRGPassStopEvent();
        ENRGPassStopEvent.eventLocation = this.eventLocation.CRSCode;
        ENRGPassStopEvent.eventTime = this.eventTime;
        return ENRGPassStopEvent;
    }

    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n    ";
        sData.append(PREFIX).append("eventTime=").append(this.eventTime)
             .append(PREFIX).append("eventLocation=").append(this.eventLocation)
             .append(PREFIX).append("CRSCode=").append(this.CRSCode)
             .append(PREFIX).append("activity=").append(this.activity)
             .append(PREFIX).append("departureTime=").append(this.departureTime)
             .append(PREFIX).append("splitJoinIndicator=").append(this.splitJoinIndicator);
        return sData.toString();
    }

}
