/* Generated from Forte class clsTimeTableLeg in plan RJIJQIBus
 * on 10/06/05 10:00:19
 *
 * Author: R.Lamberton, CRE02
 *
 * (c) Fujitsu Services 2005
 *
 * Change history
 * When             Who             What
 * 01/12/2006       MAC             Amended to produce javadoc.
 * 15.08.2007       R.Lamberton     Prevented Null pointer exceptions in SetAttributes() method.
 * 15.08.2008       R.Lamberton     IR12653 - Added serviceType to the list of attributes in setAttributes
 * 27.10.2008       Dave Oakley     Changed bitwise Or to Logical Or expressions in setAttributes
 * 30.09.2009       abjm            IR12264: Made Serializable for cloning.
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import com.example.twolibs.LocationBL.clsLocation; // JP_EDIT

//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.NO_SPLIT_JOIN;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_ADVISED;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_MANDATORY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.RESERVE_POSSIBLE;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SEATS_FIRSTANDSTD;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SEATS_FIRSTONLY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SEATS_NONE;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SEATS_STDONLY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SLPR_FIRSTANDSTD;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SLPR_FIRSTONLY;
//JP_EDIT import static JourneyPlanner.IJQ.CONSTANTS_IJQE.SLPR_STDONLY;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;

//JP_EDIT import JourneyPlanner.Utilities.clsUtilities;

/** Holds details of a timetable service.  This class inherits from clsLeg */
public class clsTimetableLeg extends clsLeg implements java.io.Serializable {

//    public  boolean    stdClassAvailable;

    private static final long serialVersionUID = -4250070520127064526L;

    /** All the pass/stop events included in the leg */
    public  Vector<clsPassStopEvent>     passStop;

    /** Indicates whether the service runs on a bank holiday */
    public  boolean    BHX;

    /** Indicates whether there is a change that is more than 90 minutes */
    public  boolean    changeTakesTooLong;

    /** Indicates whether first class accommodation is available */
    public  boolean    firstClassAvailable;

    /** Indicates whether std class accommodation is available */
    public  boolean    stdClassAvailable;

    /** Indicates whether the leg is provided by an intercity service */
    public  boolean    intercity;

    /** Leg signature */
    public  byte[]     legSignature;

    /** Indicates whether the service operates Saturdays only */
    public  boolean    SO;

    /** Indicates whether the service operates except Saturdays */
    public  boolean    SX;

    /** Indicates whether the service splits */
    public  boolean    trainSplits;

    /** Date/time of leg arrival */
    public  Date       arrival;

    /** Date/time of leg departure */
    public  Date       departure;

    /** End date of train service */
    public  Date       CATETrainEnd;

    /** Start date of train service */
    public  Date       CATETrainStart;

    /** Indicates the type of reservations possible on the service */
    public  int        reservable;

    /** Indicates the type of seats available on the service */
    public  int        seats;

    /** Indicates whether sleeper accommodation is available on the service */
    public  int        sleeper;

    /** Catering available on the service */
    public  clsCateringCodes     cateringCodes;

    /** The location from which the train originates */
    public  clsLocation trainOrigin;

    /** The final location of the train  */
    public  clsLocation trainDestination;

    /** CRS code of train origin */
    public  String 	trainOriginCode;

    /** CRS code of train destination */
    public  String 	trainDestinationCode;

    /** Markers to denote on which days the service operates */
    public  String     daysRunning;

    /** The TOC code of the TOC providing the service */
    public  String     primaryTOC;

    /** Reservation code */
    public  String     reserveCode;

    /** Retail service id of service */
    public  String     retailTrainID;

    /** Seating code */
    public  String     seatingCode;

    /** The TOC code of the secondary TOC */
    public  String     secondaryTOC;

    /** The sector code */
    public  String     sectorCode;

    /** Brand of train providing the service */
    public  String     serviceBrand;

    /** Sleeper code */
    public  String     sleeperCode;

    /** For a service that splits, the point at which the split occurs */
    public  String     splitAt;

    /** Stock type of train providing the service */
    public  String     stockType;

    /** Arrival date/time of the train */
    public  String     trainArrival;

    /** Departure date/time of the train */
    public  String     trainDeparture;

    /* Train UID */
    public  String     trainUID;


    // Default constructor
    public clsTimetableLeg() {
        // Initialisation code goes here
        passStop = new Vector<clsPassStopEvent>();
        cateringCodes = new clsCateringCodes();
        arrival = new Date();
        departure = new Date();
        changeTakesTooLong = false;
    }


    /**
     * Sets the attributes of this class depending on the
     *  attributes of a supplied ClsIJQTimetableLeg.
     *
     * @param TTleg     Supplied TimetableLeg
     */
    public void setAttributes(clsIJQTimetableLeg TTleg) {

        // Set the essential details as passed in to IJQ in a ClsIJQTimetableLeg
        // object as part of journey information derived from another source
        // i.e. not our timetable search.
        // Certain fields are filled in later
        //
        legRef              = TTleg.legRef;
        originCode          = TTleg.originLocationCode;
        destinationCode     = TTleg.destinationLocationCode;
        serviceType         = TTleg.serviceType;
        BHX                 = TTleg.BHX;
        departure           = TTleg.departure;
        arrival             = TTleg.arrival;
        reservable          = TTleg.reservable;
        seats               = TTleg.seats;
        sleeper             = TTleg.sleeper;
        cateringCodes       = TTleg.cateringCodes;
        daysRunning         = TTleg.daysRunning;
        trainOriginCode     = TTleg.trainOriginLocationCode;
        trainDestinationCode= TTleg.trainDestLocationCode;
        primaryTOC          = TTleg.primaryTOC;
        secondaryTOC        = TTleg.secondaryTOC;
        sectorCode          = TTleg.sectorCode;
        stockType           = TTleg.stockType;
        trainDeparture      = TTleg.trainDeparture;
        trainArrival        = TTleg.trainArrival;
        trainUID            = TTleg.trainUID;
        legSignature        = TTleg.legSignature;
        trainSplits         = TTleg.trainSplits;
        retailTrainID       = TTleg.retailTrainID;

        if ("I".equals(TTleg.sectorCode)) {
            intercity = true;
        } else {
            intercity = false;
        }

        // Set codes etc based on values.
        if ("0000010".equals(TTleg.daysRunning)) {
            SO = true;
        } else {
            SO = false;
        }

        if ("1111101".equals(TTleg.daysRunning)) {
            SX = true;
        } else {
            SX = false;
        }

        if (TTleg.reservable == CONSTANTS_IJQE.RESERVE_POSSIBLE) { // JP_EDIT
            reserveCode = "S";
        } else if (TTleg.reservable == CONSTANTS_IJQE.RESERVE_MANDATORY) { // JP_EDIT
            reserveCode = "A";
        } else if (TTleg.reservable == CONSTANTS_IJQE.RESERVE_ADVISED) { // JP_EDIT
            reserveCode = "R";
        } else {
            reserveCode = "N";
        }

        if (TTleg.seats == CONSTANTS_IJQE.SEATS_FIRSTANDSTD) { // JP_EDIT
            seatingCode = "B";
        } else if (TTleg.seats == CONSTANTS_IJQE.SEATS_FIRSTONLY) { // JP_EDIT
            seatingCode = "F";
        } else if (TTleg.seats == CONSTANTS_IJQE.SEATS_STDONLY) { // JP_EDIT
            seatingCode = "S";
        } else {
            seatingCode = " ";  // None
        }

        if (TTleg.sleeper == CONSTANTS_IJQE.SLPR_FIRSTANDSTD) { // JP_EDIT
            sleeperCode = "B";
        } else  if (TTleg.sleeper == CONSTANTS_IJQE.SLPR_FIRSTONLY) { // JP_EDIT
            sleeperCode = "F";
        } else  if (TTleg.sleeper == CONSTANTS_IJQE.SLPR_STDONLY) { // JP_EDIT
            sleeperCode = "S";
        } else{
            sleeperCode = " ";  //None
        }

        // Set 1st/Std Available booleans based on Seats/Sleepers
        if (seats == CONSTANTS_IJQE.SEATS_FIRSTANDSTD) { // JP_EDIT
            firstClassAvailable = true;
            stdClassAvailable = true;

        } else if (seats == CONSTANTS_IJQE.SEATS_FIRSTONLY) { // JP_EDIT
            firstClassAvailable = true;

            if ((sleeper == CONSTANTS_IJQE.SLPR_STDONLY) || (sleeper == CONSTANTS_IJQE.SLPR_FIRSTANDSTD)) { // JP_EDIT
                stdClassAvailable = true;
            } else {
                stdClassAvailable = false;
            }

        } else if (seats == CONSTANTS_IJQE.SEATS_STDONLY) { // JP_EDIT
            stdClassAvailable = true;

            if ((sleeper == CONSTANTS_IJQE.SLPR_FIRSTONLY) || (sleeper == CONSTANTS_IJQE.SLPR_FIRSTANDSTD)) { // JP_EDIT
                firstClassAvailable = true;
            } else {
                firstClassAvailable = false;
            }
        } else if (seats == CONSTANTS_IJQE.SEATS_NONE) { // JP_EDIT

            if ((sleeper == CONSTANTS_IJQE.SLPR_FIRSTONLY) || (sleeper == CONSTANTS_IJQE.SLPR_FIRSTANDSTD)) { // JP_EDIT
                firstClassAvailable = true;
            } else {
                firstClassAvailable = false;
            }

            if ((sleeper == CONSTANTS_IJQE.SLPR_STDONLY) || (sleeper == CONSTANTS_IJQE.SLPR_FIRSTANDSTD)) { // JP_EDIT
                stdClassAvailable = true;
            } else {
                stdClassAvailable = false;
            }

        }

    }

    /**
     * Returns an IJQLeg.
     *
     * @return  The IJQLeg generated from this Leg
     */
    public clsIJQLeg giveIJQLeg() {
        // Instantiate IJQTimetableLeg object and set attributes from leg.

        clsIJQTimetableLeg leg = new clsIJQTimetableLeg();
        leg.legRef                  = this.legRef;
        leg.originLocationCode      = this.originCode;
        leg.destinationLocationCode = this.destinationCode;
        leg.serviceType             = this.serviceType;
        leg.departure               = this.departure;
        leg.arrival                 = this.arrival;
        leg.trainOriginLocationCode = this.trainOriginCode;
        leg.trainDestLocationCode   = this.trainDestinationCode;
        leg.trainDeparture          = this.trainDeparture;
        leg.trainArrival            = this.trainArrival;
        leg.BHX                     = this.BHX;
        leg.SO                      = this.SO;
        leg.SX                      = this.SX;
        leg.daysRunning             = this.daysRunning;
        leg.primaryTOC              = this.primaryTOC;
        leg.reservable              = this.reservable;
        leg.cateringCodes           = this.cateringCodes;
        leg.firstClassAvailable     = this.firstClassAvailable;
        leg.stdClassAvailable       = this.stdClassAvailable;
        leg.seats                   = this.seats;
        leg.sleeper                 = this.sleeper;
        leg.CATETrainStart          = this.CATETrainStart;
        leg.CATETrainEnd            = this.CATETrainEnd;
        leg.stockType               = this.stockType;
        leg.interCity               = this.intercity;
        leg.sectorCode              = this.sectorCode;
        leg.secondaryTOC            = this.secondaryTOC;
        leg.trainUID                = this.trainUID;
        leg.legSignature            = this.legSignature;
        leg.serviceBrand            = this.serviceBrand;
        leg.trainSplits             = this.trainSplits;
        leg.retailTrainID           = this.retailTrainID;

        if ((this.passStop != null) && (!this.passStop.isEmpty())) {
            ArrayList<clsIJQSplitJoin> splitJoinList = new ArrayList<clsIJQSplitJoin>();
            for (clsPassStopEvent passStopEvent : this.passStop) {
                if (passStopEvent.splitJoinIndicator != CONSTANTS_IJQE.NO_SPLIT_JOIN) {  // JP_EDIT
                    clsIJQSplitJoin splitJoin = new clsIJQSplitJoin();
                    splitJoin.CRSCode = passStopEvent.CRSCode;
                    splitJoin.splitJoinIndicator = passStopEvent.splitJoinIndicator;
                    splitJoinList.add(splitJoin);
                }
            }

            if (!splitJoinList.isEmpty()) {
                leg.splitJoinLocations = splitJoinList;
            }
        }

        return (clsIJQLeg) leg;
    };

    /**
     * Splits the leg into two separate TimetableLeg objects at the specified split point.
     *
     * @param   splitPoint  Indicates where the leg is to be split into two.
     * @return              Split legs or null object if leg cannot be split.
     */
    public Vector<clsTimetableLeg> splitLeg(clsPassStopEvent splitPoint) {

        Vector<clsTimetableLeg> legs = null;
        //All elements in the current PassStop list prior to the
        //PassStopEvent for the split point, empty list if none
        Vector<clsPassStopEvent> passStopPrior = new Vector<clsPassStopEvent>();
        //All elements in the current PassStop list after to the
        //PassStopEvent for the split point, empty list if none
        Vector<clsPassStopEvent> passStopAfter = new Vector<clsPassStopEvent>();
        //PassStop that matches splitPoint
        clsPassStopEvent passStopEventMatched = null;
        boolean passStopEventFound = false;

        //Find PassStopEvent in PassStop that matches splitPoint(match by CRS code only)
        for (clsPassStopEvent passStopEvent : passStop) {

            if (passStopEvent.CRSCode.equals(splitPoint.CRSCode)) {
                // Found the split point
                passStopEventMatched = passStopEvent;
                passStopEventFound = true;
            }

            // Divide the passStopEvents into two lists, those before and those
            // after the split point once we've found it.  we do not want to add
            // the passStopEvent for the split point itself because we will be
            // creating a new timetable leg whose origin will be the leg split point
            if (passStopEventFound) {
                if (!(passStopEventMatched.CRSCode.equals(passStopEvent.CRSCode))) {
                    passStopAfter.add(passStopEvent);
                }
            } else {
                passStopPrior.add(passStopEvent);
            }
        }

        // PassStopEvent not found
        if (!(passStopEventFound)) {
            return null;
        } else {
            legs = new Vector<clsTimetableLeg>();
            /**
             * We want to build a date/time object which includes the leg date plus the event time
             * (which will typically be the arrival time unless it was null in the stopping pattern).
             * The original leg has a departure attribute which contains the leg departure date and time.
             * We need to create a new Date object for the arrival of Leg1 and departure of Leg2
             * by 'merging' the original leg date with the time obtained from EventTime and departure time
             * on the pass stop event respectively.
             *
             * There is a complication, in that if the EventTime/departure time is over midnight,
             * then the Date we build needs to have one day added.
             *
             * Examples:
             * Where the original leg departure is 15/12/2012 15:30:00 and the EventTime to use is 1615
             * we want to create a new Date containing 15/12/2012 16:15:00
             *
             * Where the original leg departure is 15/12/2012 23:45:00 and the EventTime to use is 0110
             * we want to create a new Date containing 16/12/2012 01:10:00
             */
            Date arrivalTime = clsUtilities.setTimeZero(departure);
            Calendar arrivalTimeCal = Calendar.getInstance();

            arrivalTimeCal.setTime(departure);
            arrivalTimeCal.set(Calendar.HOUR_OF_DAY,Integer.parseInt(passStopEventMatched.eventTime.substring(0,2)));
            arrivalTimeCal.set(Calendar.MINUTE,Integer.parseInt(passStopEventMatched.eventTime.substring(2,4)));

            if (departure.after(arrivalTimeCal.getTime())) {
                arrivalTimeCal.add(Calendar.DATE, 1);
            }
            arrivalTime = arrivalTimeCal.getTime();

            // Set all attributes to same values as this leg
            // The departure time for leg 1 is the departure time for the whole leg - assigned in clone
            clsTimetableLeg timetableLeg1   = (clsTimetableLeg) clsUtilities.deepClone(this);
            // The arrival time for leg1 is the eventTime of the passStop
            timetableLeg1.arrival           = arrivalTime;
            timetableLeg1.destination       = passStopEventMatched.eventLocation;
            timetableLeg1.destinationCode   = passStopEventMatched.CRSCode;
            timetableLeg1.passStop          = passStopPrior;

            // Set all attributes to same values as this leg
            // The arrival time for leg 2 is the arrival time of the whole leg (before the split) - assigned in clone
            clsTimetableLeg timetableLeg2   = (clsTimetableLeg) clsUtilities.deepClone(this);
            // The departure time for leg2 is the departure time associated with the passStop, which
            // should never be null because we cannot split on the last leg of a service.
            Date depatureTime = clsUtilities.setTimeZero(departure);
            Calendar departureTimeCal = Calendar.getInstance();

            departureTimeCal.setTime(departure);
            departureTimeCal.set(Calendar.HOUR_OF_DAY,Integer.parseInt(passStopEventMatched.departureTime.substring(0,2)));
            departureTimeCal.set(Calendar.MINUTE,Integer.parseInt(passStopEventMatched.departureTime.substring(2,4)));

            if (departure.after(departureTimeCal.getTime())) {
                departureTimeCal.add(Calendar.DATE, 1);
            }

            depatureTime = departureTimeCal.getTime();

            timetableLeg2.departure         = depatureTime;
            timetableLeg2.origin            = passStopEventMatched.eventLocation;
            timetableLeg2.originCode        = passStopEventMatched.CRSCode;
            timetableLeg2.passStop          = passStopAfter;

            legs.add(timetableLeg1);
            legs.add(timetableLeg2);
            return legs;
        }

    }

    /**
     * Returns a list of all the stations in the leg.
     * @return  A list of CRS codes
     */
    public List<String> getStationList() {
        List<String> stationList = new ArrayList<String>();

        stationList.add(origin.CRSCode);
        if ((passStop != null) && (passStop.isEmpty() == false)) {
            for (clsPassStopEvent pse : passStop) {
                stationList.add(pse.CRSCode);
            }
        }
        stationList.add(destination.CRSCode);

        return stationList;
    }

    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuffer sData = new StringBuffer();
        final String PREFIX = "\n        ............";
        sData.append(super.toString());
        sData.append(PREFIX + "arrival=" + this.arrival +
                     "\tdeparture=" + this.departure +
                     PREFIX + "BHX=" + this.BHX +
                     "\tSO=" + this.SO +
                     "\tSX=" + this.SX +
                     PREFIX + "reservable=" + this.reservable +
                     "\treserveCode=" + this.reserveCode +
                     "\tfirstClassAvailable=" + this.firstClassAvailable +
                     "\tstdClassAvailable=" + this.stdClassAvailable +
                     PREFIX + "seats=" + this.seats +
                     "\tseatingCode=" + this.seatingCode +
                     "\tsleeper=" + this.sleeper +
                     "\tsleeperCode=" + this.sleeperCode +
                     PREFIX + "cateringCodes=" + this.cateringCodes +
                     "\tdaysRunning=" + this.daysRunning +
                     "\tprimaryTOC=" + this.primaryTOC +
                     "\tsecondaryTOC=" + this.secondaryTOC +
                     PREFIX + "retailTrainID=" + this.retailTrainID +
                     "\tintercity=" + this.intercity +
                     "\tsectorCode=" + this.sectorCode +
                     "\tserviceBrand=" + this.serviceBrand +
                     "\tstockType=" + this.stockType +
                     PREFIX + "changeTakesTooLong=" + this.changeTakesTooLong +
                     "\ttrainSplits=" + this.trainSplits +
                     "\tsplitAt=" + this.splitAt +
                     "\tlegSignature=" + (this.legSignature==null ? "null" : new String(this.legSignature)) +
                     PREFIX + "CATETrainStart=" + this.CATETrainStart +
                     "\tCATETrainEnd=" + this.CATETrainEnd +
                     PREFIX + "trainOriginCode=" + this.trainOriginCode +
                     "\ttrainDestinationCode=" + this.trainDestinationCode +
                     PREFIX + "trainOrigin=" + this.trainOrigin +
                     PREFIX + "trainDestination=" + this.trainDestination +
                     PREFIX + "trainDeparture=" + this.trainDeparture +
                     "\ttrainArrival=" + this.trainArrival +
                     "\ttrainUID=" + this.trainUID +
                     PREFIX + "passStop=" + this.passStop);
        return sData.toString();
    }

}
