/**
 * Copyright (c) 2012 Fujitsu Services Ltd.
 */

package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import java.io.Serializable;

/** Contains the line and interchange data describing an underground train leg. */
public class clsUndergroundDetail implements Serializable{

    private static final long serialVersionUID = -7872684240328360568L;

    /** 3-character code for the line.e.g. DIS for District line. */
    public String line;

    /**
     * Station code for the origin station.
     * Note: This is usually a CRS code,
     * but for those underground stations which do not have CRS codes,
     * a unique 3-char code will be used to simulate a CRS code.
     */
    public String origin;

    /**
     * Station code for the destination / interchange station.
     * Note: This is usually a CRS code,
     * but for those underground stations which do not have CRS codes,
     * a unique 3-char code will be used to simulate a CRS code.
     */
    public String destination;

    /** Time taken to travel to the destination. */
    public int elapsedTime;

    /** Number of trains scheduled, for the hour of that day travelled (e.g. 1pm on a Monday). */
    public int trainsPerHour;

    /** Interchange time at the destination, in minutes. */
    public int interchangeTimeAtDest;

    /** Departure time in minutes of the first service of the day. */
    public String firstServiceDeparts;

    /** Departure time in minutes of the final service of the day. */
    public String lastServiceDeparts;

    /** Constructor */
    public clsUndergroundDetail() {
    }

    /** Returns a string representation of this object, for logging purposes. */
    public String toString() {
        StringBuilder sData = new StringBuilder();
        final String PREFIX = "\n    ";
        sData.append(PREFIX + "clsUndergroundDetail:")
             .append(PREFIX + "  line = ")                    .append(this.line)
             .append(PREFIX + "  origin = ")                  .append(this.origin)
             .append(PREFIX + "  destination = ")             .append(this.destination)
             .append(PREFIX + "  elapsedTime = ")             .append(this.elapsedTime)
             .append(PREFIX + "  trainsPerHour = ")           .append(this.trainsPerHour)
             .append(PREFIX + "  interchangeTimeAtDest = ")   .append(this.interchangeTimeAtDest)
             .append(PREFIX + "  firstServiceDeparts = ")     .append(this.firstServiceDeparts)
             .append(PREFIX + "  lastServiceDeparts = ")      .append(this.lastServiceDeparts);

        return sData.toString();
    }
}
