package com.example.twolibs.TimeTableBL;
//JP_EDIT package JourneyPlanner.IJQ.BusinessClasses;

import java.io.Serializable;
import java.util.ArrayList;

/** Represents an underground leg which subclasses clsFixedLeg
 * to provide the extra detail about the underground journey portion. */
public class clsUndergroundLeg extends clsFixedLeg implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -2219840820675692072L;

    /** Detail entries, one for each line traveled on the underground. */
    public  ArrayList<clsUndergroundDetail>     details;

    /** List of zones traveled across all lines in the leg */
    public  String     zones;

    /** Constructor */
    public clsUndergroundLeg() {
    }

    /**
     * Takes a record from the matrix file and populates the object with data extracted from the record.
     *
     * @return      Returns an IJQLeg, which in this case will be an instance of clsIJQUndergroundLeg.
     */
    public clsIJQLeg giveIJQLeg() {
        clsIJQUndergroundLeg ijqUndergroundLeg = new clsIJQUndergroundLeg();

        ijqUndergroundLeg.legRef                    = this.legRef;
        ijqUndergroundLeg.originLocationCode        = this.originCode;
        ijqUndergroundLeg.destinationLocationCode   = this.destinationCode;
        ijqUndergroundLeg.serviceType               = this.serviceType;
        ijqUndergroundLeg.zones                     = this.zones;
        ijqUndergroundLeg.details                   = this.details;
        ijqUndergroundLeg.transitTime               = this.transitTime;
        ijqUndergroundLeg.changeTime                = this.changeTime;

        clsIJQLeg ijqLeg = (clsIJQLeg)ijqUndergroundLeg;
        return ijqLeg;
    }

    /** Returns a string representation of this object, for logging purposes */
    public String toString() {
        StringBuilder sData = new StringBuilder();
        final String PREFIX = "\n    ";
        sData.append(PREFIX + "clsUndergroundLeg:")
             .append(super.toString())
             .append(PREFIX + "details = ") .append(this.details)
             .append(PREFIX + "zones = ")   .append(this.zones);

        return sData.toString();
    }
}
