package com.example.twolibs.TimeTableGUI;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTLeg;

public class JourneyListAdaptor extends ArrayAdapter<TTJourney> {
	private final Activity context;
	private final List<TTJourney> jnyList;
	private final AppContext bb;


	
	static class ViewHolder {
		public TextView txtDepartTime;
		public TextView txtOrigin;
		public TextView txtArriveTime;
		public TextView txtDestination;
		public TextView txtNotes;
		public TextView txtLegs;
		public Button   cmdDetail;
		public int	position;
	}
	
	public JourneyListAdaptor(Activity context,List<TTJourney> jnyList, AppContext bb) {
	  super(context, R.layout.journey_summary, jnyList);
	  this.context = context;
	  this.jnyList = jnyList;
	  this.bb = bb;
	}
	
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
	  View rowView = convertView;
	  String crsCode;
	  String txtDescription;
	  String txtNotes;
	  String txtChanges;
 	
  	
	  // reuse views
	  if (rowView == null) {
	    LayoutInflater inflater = context.getLayoutInflater();
	    rowView = inflater.inflate(R.layout.journey_summary, null);
	    // configure view holder
	    ViewHolder viewHolder = new ViewHolder();
	    viewHolder.txtDepartTime = (TextView) rowView.findViewById(R.id.txtDepartTime);
	    viewHolder.txtOrigin = (TextView) rowView.findViewById(R.id.txtOrigin);
	    
	    viewHolder.txtArriveTime = (TextView) rowView.findViewById(R.id.txtArriveTime);
	    viewHolder.txtDestination = (TextView) rowView.findViewById(R.id.txtDestination);
	    viewHolder.txtNotes = (TextView) rowView.findViewById(R.id.txtNotes);
	    viewHolder.txtLegs = (TextView) rowView.findViewById(R.id.txtLegs);
	    viewHolder.cmdDetail = (Button) rowView.findViewById(R.id.cmdDetail);

	    rowView.setTag(viewHolder);
	  }
	
	  ViewHolder holder = (ViewHolder) rowView.getTag();
	  
	    // Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	  holder.cmdDetail.setOnClickListener(mOnDetailClickListener);
	  
	 
	  
	  // fill data
	  holder.position = position;
	  TTJourney j = jnyList.get(position);
	  TTLeg l = j.getJy_legs().get(0);
	  
	  holder.txtDepartTime.setText(l.getLeg_departsTime());
	  
	  Location loc;
	  crsCode = l.getLeg_origin();
	  loc = Location.getLocationByCRS(crsCode);
	  if(loc != null){
		  txtDescription = loc.getDescription();
	  } else {
		  txtDescription = crsCode;
	  }
	  holder.txtOrigin.setText(txtDescription);
	  
	  l = j.getJy_legs().get(j.getJy_legs().size()-1);
	  
	  holder.txtArriveTime.setText(l.getLeg_arrivesTime());
	  
	  crsCode = l.getLeg_destination();
	  loc = Location.getLocationByCRS(crsCode);
	  if(loc != null){
		  txtDescription = loc.getDescription();
	  } else {
		  txtDescription = crsCode;
	  }
	  holder.txtDestination.setText(txtDescription);
	  
	  txtNotes = "";
	  if(j.getJy_overtakentrainlevel() > 0){
		  txtNotes = " Overtaken";
	  }
	  holder.txtNotes.setText(txtNotes);

	  if(j.getJy_numlegs() == 1){
		  txtChanges = " Direct";
	  } else if(j.getJy_numlegs() == 2){
		  txtChanges = " One change";
	  } else {
		  txtChanges = " " + (j.getJy_numlegs() -1) +" changes";
	  }

	  holder.txtLegs.setText(txtChanges );
	
	
	  return rowView;
	}

	private OnClickListener mOnDetailClickListener = new OnClickListener() {
        @Override
        public void onClick(View v) {

        	
        	LinearLayout button_container = (LinearLayout) v.getParent();
           	LinearLayout column_container = (LinearLayout) button_container.getParent();
           	RelativeLayout row_container = (RelativeLayout) column_container.getParent();
           	
            ListView parent = (ListView) row_container.getParent();
            int position = parent.getPositionForView(v);


  	        if (position != ListView.INVALID_POSITION) {
  	        	TTJourney jny = jnyList.get(position);
                bb.selJourney =  jny;

                for (int j = 0; j < parent.getChildCount(); j++)
                	parent.getChildAt(j).setBackgroundColor(Color.TRANSPARENT);

               // change the background color of the selected element
                ((View)v.getParent()).setBackgroundColor(Color.LTGRAY);
               
	            Log.e("XXX", "Title clicked" + position);
	            //  	            //DO THE STUFF YOU WANT TO DO WITH THE position
	            
				Intent nextScreen = new Intent(context, LegDetails.class);
				
				//Sending data to another Activity                 
				nextScreen.putExtra("direction", "from");

				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
		        context.startActivityForResult(nextScreen, 1);
				//startActivity(nextScreen); 
				}  
				

  	        
	        }
         	
    };


}
